/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util.stimuli;

import java.math.BigInteger;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;
import org.eclipse.app4mc.amalthea.model.util.stimuli.EventModelFactory;
import org.eclipse.app4mc.amalthea.model.util.stimuli.IEventModel;
import org.eclipse.emf.common.util.EMap;

public class EMPeriodic
implements IEventModel {
    private Time tOuterPeriod;
    private Time tMinDistance;
    private Time tJitter;

    @Override
    public long etaPlus(Time dt) {
        double eta_plus;
        if (dt.getValue().compareTo(BigInteger.ZERO) == 0) {
            return 0L;
        }
        Time num = dt.add(this.tJitter);
        double eta_plus_p = Math.ceil(num.divide(this.tOuterPeriod));
        if (this.tMinDistance.getValue().compareTo(BigInteger.ZERO) != 0) {
            double eta_plus_d = Math.ceil(dt.divide(this.tMinDistance));
            eta_plus = Math.min(eta_plus_p, eta_plus_d);
        } else {
            eta_plus = eta_plus_p;
        }
        return (long)eta_plus;
    }

    @Override
    public long etaMinus(Time dt) {
        double eta_min;
        if (dt.getValue().compareTo(BigInteger.ZERO) == 0) {
            return 0L;
        }
        Time num = dt.subtract(this.tJitter);
        double eta_min_p = Math.floor(num.divide(this.tOuterPeriod));
        if (this.tMinDistance.getValue().compareTo(BigInteger.ZERO) != 0) {
            double eta_min_d = Math.floor(dt.divide(this.tMinDistance));
            eta_min = Math.max(eta_min_p, eta_min_d);
        } else {
            eta_min = eta_min_p;
        }
        return (long)Math.max(0.0, eta_min);
    }

    @Override
    public Time deltaPlus(long n) {
        if (n < 2L) {
            return null;
        }
        Time tMinDistanceCalc = EventModelFactory.max(this.tOuterPeriod, this.tMinDistance);
        Time tDistance = tMinDistanceCalc.multiply(n - 1L);
        return tDistance.add(this.tJitter);
    }

    @Override
    public Time deltaMinus(long n) {
        if (n < 2L) {
            return FactoryUtil.createTime("0ms");
        }
        Time tMinDistanceCalc = EventModelFactory.max(this.tOuterPeriod, this.tMinDistance);
        Time tDistance = tMinDistanceCalc.multiply(n - 1L);
        if (this.tOuterPeriod.compareTo(this.tMinDistance) > 0) {
            Time tDiffRecMinDistance = this.tOuterPeriod.subtract(this.tMinDistance);
            Time tMaxJitter = this.tJitter.compareTo(tDiffRecMinDistance) > 0 ? tDiffRecMinDistance : this.tJitter;
            return tDistance.subtract(tMaxJitter);
        }
        return tDistance;
    }

    @Override
    public double getUtilization(Process process, RuntimeUtil.TimeType tt, EMap<ModeLabel, String> modes) {
        Time time = RuntimeUtil.getExecutionTimeForProcess(process, modes, tt);
        return time.divide(this.tOuterPeriod);
    }

    public Time getRecurrence() {
        return this.tOuterPeriod;
    }

    public void setRecurrence(Time recurrence) {
        this.tOuterPeriod = recurrence;
    }

    public Time getMinDistance() {
        return this.tMinDistance;
    }

    public void setMinDistance(Time minDistance) {
        this.tMinDistance = minDistance;
    }

    public Time getJitter() {
        return this.tJitter;
    }

    public void setJitter(Time jitter) {
        this.tJitter = jitter;
    }
}

