/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.mapping;

import java.util.HashSet;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.InterruptController;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-Mapping-Scheduler-Allocation-Top-Level-Responsibility", checks={"A processing unit should have at most one top level task scheduler and one interrupt controller responsible for it"})
public class AmMappingSchedulerAllocationTopLevelResponsibility
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getMappingModel();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof MappingModel) {
            MappingModel mm = (MappingModel)object;
            HashSet<ProcessingUnit> pUsWithTLScheduler = new HashSet<ProcessingUnit>();
            HashSet<ProcessingUnit> pUsWithIC = new HashSet<ProcessingUnit>();
            for (SchedulerAllocation sall : mm.getSchedulerAllocation()) {
                if (sall.getScheduler() == null) continue;
                Scheduler sched = sall.getScheduler();
                for (ProcessingUnit pu : sall.getResponsibility()) {
                    if (sched instanceof InterruptController && !pUsWithIC.add(pu)) {
                        this.addIssue(results, (EObject)sall, (EStructuralFeature)ePackage.getSchedulerAllocation_Responsibility(), String.valueOf(this.objectInfo((EObject)pu)) + " should have at most one interrupt controller that is responsible for it");
                    }
                    if (!(sched instanceof TaskScheduler) || ((TaskScheduler)sched).getParentScheduler() != null || pUsWithTLScheduler.add(pu)) continue;
                    this.addIssue(results, (EObject)sall, (EStructuralFeature)ePackage.getSchedulerAllocation_Responsibility(), String.valueOf(this.objectInfo((EObject)pu)) + " should have at most one top level scheduler that is responsible for it");
                }
            }
        }
    }
}

