/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.btf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.app4mc.amalthea.model.ProcessEventType;
import org.eclipse.app4mc.amalthea.model.RunnableEventType;
import org.eclipse.app4mc.atdb.EntityType;
import org.eclipse.app4mc.atdb._import.btf.model.BTFEntityState;

public enum BTFEntityType implements EntityType<Enum<?>>
{
    PROCESS(ProcessEventType.class, "T", "I"),
    RUNNABLE(RunnableEventType.class, "R");

    private static final Map<String, BTFEntityType> name2Literal;
    public static final List<BTFEntityType> literals;
    private final List<String> traceAliases;
    private final String entityTypeName;

    static {
        name2Literal = Stream.of(BTFEntityType.values()).collect(Collectors.toMap(et -> et.entityTypeName, et -> et));
        literals = Collections.unmodifiableList(Arrays.asList(BTFEntityType.values()));
    }

    private BTFEntityType(Class<? extends Enum<?>> eventTypeClass, String ... traceAlias) {
        this.traceAliases = Collections.unmodifiableList(Arrays.asList(traceAlias));
        String className = eventTypeClass.getSimpleName();
        this.entityTypeName = className.substring(0, className.indexOf("EventType")).toLowerCase();
    }

    public String getName() {
        return this.entityTypeName;
    }

    public boolean isTraceAlias(String traceAlias) {
        return this.traceAliases.stream().anyMatch(traceAlias::equals);
    }

    public List<String> getTraceAliases() {
        return this.traceAliases;
    }

    public static BTFEntityType getForName(String name) {
        return name2Literal.get(name);
    }

    public Set<Enum<?>> getPossibleEvents() {
        return BTFEntityState.getPossibleEventsFor(this);
    }

    public List<String> getValidityConstraints() {
        return BTFEntityState.getValidityConstraints(this);
    }
}

