/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.app4mc.amalthea.model.editor.util.AmaltheaEditorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IEditorAssociationOverride;

public class AmaltheaEditorAssociationOverride
implements IEditorAssociationOverride {
    private static final String AMALTHEA_CONTENT_TYPE = "org.eclipse.app4mc.amalthea.xmi.contentType";
    private static final String AMALTHEA_EDITOR_DUMMY = "org.eclipse.app4mc.amalthea.model.editor.dummy";
    private static final String AMALTHEA_EDITOR_EXTENDED = "org.eclipse.app4mc.amalthea.model.editor.extended";
    private static final List<String> AMALTHEA_EDITORS = Arrays.asList("org.eclipse.app4mc.amalthea.model.editor.extended", "org.eclipse.app4mc.amalthea.model.editor.dummy");
    private static final List<String> REJECTED_EDITORS = Arrays.asList("org.eclipse.emf.ecore.presentation.ReflectiveEditorID", "org.eclipse.xtext.builder.trace.TraceEditorID");

    public IEditorDescriptor[] overrideEditors(IEditorInput editorInput, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        if (!this.isAmaltheaType(contentType)) {
            return editorDescriptors;
        }
        return (IEditorDescriptor[])Stream.of(editorDescriptors).filter(this::isValidEditor).filter(desc -> this.isValidAmaltheaEditor(editorInput, (IEditorDescriptor)desc)).toArray(IEditorDescriptor[]::new);
    }

    public IEditorDescriptor[] overrideEditors(String fileName, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        if (!this.isAmaltheaType(contentType)) {
            return editorDescriptors;
        }
        return (IEditorDescriptor[])Stream.of(editorDescriptors).filter(this::isValidEditor).toArray(IEditorDescriptor[]::new);
    }

    public IEditorDescriptor overrideDefaultEditor(IEditorInput editorInput, IContentType contentType, IEditorDescriptor editorDescriptor) {
        if (!this.isAmaltheaType(contentType)) {
            return editorDescriptor;
        }
        return this.overrideEditorDescriptor(editorInput, editorDescriptor);
    }

    public IEditorDescriptor overrideDefaultEditor(String fileName, IContentType contentType, IEditorDescriptor editorDescriptor) {
        return editorDescriptor;
    }

    private boolean isAmaltheaType(IContentType contentType) {
        return contentType != null && AMALTHEA_CONTENT_TYPE.equals(contentType.getId());
    }

    private boolean isValidEditor(IEditorDescriptor editorDescriptor) {
        if (editorDescriptor == null) {
            return false;
        }
        return !REJECTED_EDITORS.contains(editorDescriptor.getId());
    }

    private boolean isValidAmaltheaEditor(IEditorInput editorInput, IEditorDescriptor editorDescriptor) {
        if (editorDescriptor == null) {
            return false;
        }
        IFile iFile = AmaltheaEditorUtil.getIFile(editorInput);
        boolean isCurrentVersion = AmaltheaEditorUtil.isNamespaceValid(iFile);
        if (AMALTHEA_EDITOR_DUMMY.equals(editorDescriptor.getId())) {
            return !isCurrentVersion;
        }
        if (AMALTHEA_EDITOR_EXTENDED.equals(editorDescriptor.getId())) {
            return isCurrentVersion;
        }
        return true;
    }

    private IEditorDescriptor overrideEditorDescriptor(IEditorInput editorInput, IEditorDescriptor editorDescriptor) {
        if (editorDescriptor == null || !AMALTHEA_EDITORS.contains(editorDescriptor.getId())) {
            return editorDescriptor;
        }
        IFile iFile = AmaltheaEditorUtil.getIFile(editorInput);
        boolean isCurrentVersion = AmaltheaEditorUtil.isNamespaceValid(iFile);
        if (isCurrentVersion) {
            return PlatformUI.getWorkbench().getEditorRegistry().findEditor(AMALTHEA_EDITOR_EXTENDED);
        }
        return PlatformUI.getWorkbench().getEditorRegistry().findEditor(AMALTHEA_EDITOR_DUMMY);
    }
}

