/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.ui.util;

import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.app4mc.validation.core.IProfile;
import org.eclipse.app4mc.validation.util.CachedValidator;
import org.eclipse.app4mc.validation.util.ValidationExecutor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ValidationExecutorWithMonitor
extends ValidationExecutor {
    public ValidationExecutorWithMonitor(Class<? extends IProfile> profileClass) {
        super(profileClass);
    }

    public ValidationExecutorWithMonitor(Collection<Class<? extends IProfile>> profileClasses) {
        super(profileClasses);
    }

    public ValidationExecutorWithMonitor(ConcurrentMap<EClassifier, CopyOnWriteArraySet<CachedValidator>> validationMap) {
        super(validationMap);
    }

    public IStatus validateWithMonitor(EObject model) {
        return this.validateWithMonitor(model, (IProgressMonitor)new NullProgressMonitor());
    }

    public IStatus validateWithMonitor(EObject model, IProgressMonitor monitor) {
        this.results.clear();
        try {
            int count = this.getModelObjectCount(model);
            monitor.beginTask("Validating objects", count / 1000 + 1);
            TreeIterator iterator = EcoreUtil.getAllContents((EObject)model, (boolean)false);
            this.validateObject(model);
            int i = 0;
            while (iterator.hasNext()) {
                if (i++ % 1000 == 0) {
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                EObject next = (EObject)iterator.next();
                this.validateObject(next);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private int getModelObjectCount(EObject object) {
        int count = 1;
        TreeIterator iter = object.eAllContents();
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }
}

