/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.ui.provider;

import org.eclipse.app4mc.validation.util.CachedProfile;
import org.eclipse.app4mc.validation.util.CachedValidator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class ProfileLabelProvider
extends CellLabelProvider
implements ILabelProvider {
    public String getText(Object element) {
        if (element instanceof CachedProfile) {
            CachedProfile node = (CachedProfile)element;
            return node.getName();
        }
        return element == null ? "" : element.toString();
    }

    public String getToolTipText(Object element) {
        if (element instanceof CachedProfile) {
            CachedProfile node = (CachedProfile)element;
            StringBuilder sb = new StringBuilder();
            if (node.getDescription().isEmpty()) {
                sb.append(node.getName());
            } else {
                sb.append(node.getDescription());
            }
            for (CachedValidator validator : node.getCachedValidations().values()) {
                sb.append("\n   " + validator.getValidationID());
                String[] stringArray = validator.getValidationChecks();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String check = stringArray[n2];
                    sb.append("\n      * " + check);
                    ++n2;
                }
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        return null;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setText(this.getText(element));
    }

    public Image getImage(Object element) {
        return null;
    }
}

