/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.converter;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.jdom2.Document;
import org.jdom2.Element;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(factory="org.eclipse.app4mc.amalthea.namespaceconverter.factory")
public class NamespaceConverter
extends AbstractConverter {
    public static final Logger LOGGER = LoggerFactory.getLogger(NamespaceConverter.class);

    @Override
    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Override
    public void convert(File targetFile, Map<File, Document> fileName2documentMap, List<ICache> caches) {
        LOGGER.info("Migration from {} to {} : Executing Namespace converter for model file : {}", new Object[]{this.getInputModelVersion(), this.getOutputModelVersion(), targetFile.getName()});
        Document document = fileName2documentMap.get(targetFile);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        ModelVersion inputVersion = ModelVersion.getModelVersion(this.getInputModelVersion());
        ModelVersion outputVersion = ModelVersion.getModelVersion(this.getOutputModelVersion());
        if (inputVersion != null && outputVersion != null) {
            HelperUtil.updateRootElement_NameSpaces(rootElement, inputVersion, outputVersion);
        } else {
            LOGGER.error("input model version {} or output model version {} are invalid!", (Object)this.getInputModelVersion(), (Object)this.getOutputModelVersion());
        }
    }
}

