/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters080.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.2", "output_model_version=0.8.0"}, service={IConverter.class})
public class StimuliConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StimuliConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.7.2 to 0.8.0 : Executing Stimuli converter for model file : {}", (Object)targetFile.getName());
        Document root = filename2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateSignedTime(rootElement);
        this.updateSignedTimeObject(rootElement);
    }

    private void updateSignedTimeObject(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append(".//customProperties//@xsi:type[.=\"am:SignedTimeObject\"]");
        List types = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Attribute.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Attribute signedTimeObjectAttribute : types) {
            signedTimeObjectAttribute.setValue("am:TimeObject");
        }
    }

    private void updateSignedTime(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./stimuliModel/stimuli/stimulusDeviation//*[@xsi:type=\"am:SignedTime\"]");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element signedTimeElement : elements) {
            Attribute attribute = signedTimeElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (attribute == null) continue;
            attribute.setValue("am:Time");
        }
    }
}

