/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.testing.scoping;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.amp.amf.parameters.AParInterpreter;
import org.eclipse.amp.amf.parameters.aPar.Import;
import org.eclipse.amp.amf.parameters.aPar.Model;
import org.eclipse.amp.amf.testing.ATestInterpreter;
import org.eclipse.amp.amf.testing.aTest.Constraint;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAgent;
import org.metaabm.SAttribute;
import org.metaabm.SAttributed;
import org.metaabm.SContext;
import org.metaabm.SProjection;
import org.metaabm.SState;
import org.metaabm.SStateValue;

@Singleton
public class ATestScopeProvider
extends AbstractDeclarativeScopeProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IScope getScope(EObject object, EReference reference) {
        if (!(object instanceof Constraint)) return super.getScope(object, reference);
        Constraint constraint = (Constraint)object;
        ArrayList<IEObjectDescription> allElems = new ArrayList<IEObjectDescription>();
        ResourceSet resourceSet = this.getResourceSet(object);
        if (reference.getEType() != MetaABMPackage.eINSTANCE.getSAgent() && reference.getEType() != MetaABMPackage.eINSTANCE.getSAttribute()) {
            if (reference.getEType() != MetaABMPackage.eINSTANCE.getSStateValue()) return new SimpleScope(allElems);
        }
        if (reference.getEType() == MetaABMPackage.eINSTANCE.getSAgent()) {
            for (Resource resource : resourceSet.getResources()) {
                TreeIterator iter = resource.getAllContents();
                while (iter.hasNext()) {
                    EObject next = (EObject)iter.next();
                    if (!(next instanceof SAgent)) continue;
                    SAgent sAgent = (SAgent)next;
                    allElems.add(EObjectDescription.create((String)StringUtils.capitalize((String)sAgent.getID()), (EObject)sAgent));
                }
            }
            return new SimpleScope(allElems);
        } else if (reference.getEType() == MetaABMPackage.eINSTANCE.getSAttribute()) {
            if (constraint.getAgent() == null) return IScope.NULLSCOPE;
            this.findAttributes((SAttributed)constraint.getAgent(), allElems);
            return new SimpleScope(allElems);
        } else {
            if (reference.getEType() != MetaABMPackage.eINSTANCE.getSStateValue()) return new SimpleScope(allElems);
            if (!(constraint.getAttribute() instanceof SState)) return IScope.NULLSCOPE;
            SState state = (SState)constraint.getAttribute();
            for (SStateValue value : state.getOptions()) {
                allElems.add(EObjectDescription.create((String)StringUtils.capitalize((String)value.getID()), (EObject)value));
            }
        }
        return new SimpleScope(allElems);
    }

    protected ResourceSet getResourceSet(EObject object) {
        Resource aparAnalog;
        ResourceSet resourceSet = object.eResource().getResourceSet();
        URI aparURI = ATestInterpreter.getParameterURI(object.eResource());
        if (aparURI.isPlatform() && URIConverter.INSTANCE.exists(aparURI, null) && (aparAnalog = resourceSet.getResource(aparURI, true)) != null && aparAnalog.getContents().size() > 0) {
            Model aparModel = (Model)aparAnalog.getContents().get(0);
            Resource resource = resourceSet.getResource(URI.createURI((String)AParInterpreter.convertURI((Import)aparModel.getModel()), (boolean)true), true);
        }
        return resourceSet;
    }

    protected void findAttributes(SAttributed attributed, List<IEObjectDescription> allElems) {
        for (SAttribute attr : attributed.getAttributes()) {
            if (attr.isImmutable()) continue;
            this.addElem(attributed, attr, allElems);
        }
        if (attributed instanceof SContext) {
            for (SProjection proj : ((SContext)attributed).getProjections()) {
                this.findAttributes((SAttributed)proj, allElems);
            }
        }
    }

    private void addElem(SAttributed parent, SAttribute attr, List<IEObjectDescription> allElems) {
        String id = StringUtils.capitalize((String)attr.getID());
        if (parent instanceof SProjection) {
            id = StringUtils.capitalize((String)(String.valueOf(parent.getID()) + id));
        }
        allElems.add(EObjectDescription.create((String)id, (EObject)attr));
    }
}

