/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Predicate;
import com.google.inject.ImplementedBy;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.grammaranalysis.IPDAState;
import org.eclipse.xtext.serializer.analysis.GrammarAlias;
import org.eclipse.xtext.serializer.analysis.SyntacticSequencerPDAProvider;
import org.eclipse.xtext.serializer.sequencer.RuleCallStack;
import org.eclipse.xtext.util.formallang.ITokenPdaAdapter;

@ImplementedBy(value=SyntacticSequencerPDAProvider.class)
public interface ISyntacticSequencerPDAProvider {
    public ISynAbsorberState getPDA(EObject var1, EClass var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ISynAbsorberState
    extends ISynState {
        public List<ISynTransition> getOutTransitions();

        public Map<AbstractElement, ISynTransition> getOutTransitionsByElement();

        public Map<AbstractElement, ISynTransition> getOutTransitionsByRuleCallEnter();

        public Map<AbstractElement, ISynTransition> getOutTransitionsByRuleCallExit();
    }

    public static interface ISynEmitterState
    extends ISynState,
    ISynNavigable {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ISynFollowerOwner {
        public List<ISynState> getFollowers();

        public EClass getEClass();

        public EObject getContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ISynNavigable
    extends ISynFollowerOwner {
        public ISynAbsorberState getTarget();

        public ITokenPdaAdapter<ISynState, RuleCall, AbstractElement> getPathToTarget();

        public List<ISynState> getShortestPathTo(AbstractElement var1, RuleCallStack var2);

        public List<ISynState> getShortestStackpruningPathTo(AbstractElement var1, RuleCallStack var2);

        public List<ISynState> getShortestPathToAbsorber(RuleCallStack var1);

        public List<ISynState> getShortestStackpruningPathToAbsorber(RuleCallStack var1);

        public boolean involvesUnassignedTokenRuleCalls();

        public boolean isSyntacticallyAmbiguous();

        public boolean hasEmitters();
    }

    public static interface ISynState
    extends ISynFollowerOwner {
        public AbstractElement getGrammarElement();

        public SynStateType getType();
    }

    public static interface ISynTransition
    extends ISynNavigable {
        public ISynAbsorberState getSource();

        public GrammarAlias.AbstractElementAlias getAmbiguousSyntax();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SynPredicates {
        public static Predicate<ISynState> absorber(final AbstractElement ele) {
            return new Predicate<ISynState>(){

                public boolean apply(ISynState input) {
                    return input.getGrammarElement() == ele && input instanceof ISynAbsorberState;
                }
            };
        }

        public static Predicate<ISynState> element(final AbstractElement ele) {
            return new Predicate<ISynState>(){

                public boolean apply(ISynState input) {
                    return input.getGrammarElement() == ele;
                }
            };
        }

        public static Predicate<ISynState> emitter(final AbstractElement ele) {
            return new Predicate<ISynState>(){

                public boolean apply(ISynState input) {
                    return input.getGrammarElement() == ele && input instanceof ISynEmitterState;
                }
            };
        }

        public static Predicate<ISynState> ruleCallEnter(final RuleCall ele) {
            return new Predicate<ISynState>(){

                public boolean apply(ISynState input) {
                    return input.getGrammarElement() == ele && input.getType().isRuleCallEnter();
                }
            };
        }

        public static Predicate<ISynState> ruleCallExit(final RuleCall ele) {
            return new Predicate<ISynState>(){

                public boolean apply(ISynState input) {
                    return input.getGrammarElement() == ele && input.getType().isRuleCallExit();
                }
            };
        }

        public static Predicate<ISynState> ruleCallExits() {
            return new Predicate<ISynState>(){

                public boolean apply(ISynState input) {
                    return input.getType().isRuleCallExit();
                }
            };
        }

        public static Predicate<ISynState> ruleCallExitsOrAbsorber() {
            return new Predicate<ISynState>(){

                public boolean apply(ISynState input) {
                    return input.getType().isRuleCallExit() || input instanceof ISynAbsorberState;
                }
            };
        }

        public static Predicate<ISynState> absorber() {
            return new Predicate<ISynState>(){

                public boolean apply(ISynState input) {
                    return input instanceof ISynAbsorberState;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SynStateType {
        ASSIGNED_ACTION_CALL(IPDAState.PDAStateType.ELEMENT),
        ASSIGNED_BOOLEAN_KEYWORD(IPDAState.PDAStateType.ELEMENT),
        ASSIGNED_CROSSREF_DATATYPE_RULE_CALL(IPDAState.PDAStateType.ELEMENT),
        ASSIGNED_CROSSREF_ENUM_RULE_CALL(IPDAState.PDAStateType.ELEMENT),
        ASSIGNED_CROSSREF_KEYWORD(IPDAState.PDAStateType.ELEMENT),
        ASSIGNED_CROSSREF_TERMINAL_RULE_CALL(IPDAState.PDAStateType.ELEMENT),
        ASSIGNED_DATATYPE_RULE_CALL(IPDAState.PDAStateType.ELEMENT),
        ASSIGNED_ENUM_RULE_CALL(IPDAState.PDAStateType.ELEMENT),
        ASSIGNED_KEYWORD(IPDAState.PDAStateType.ELEMENT),
        ASSIGNED_PARSER_RULE_CALL(IPDAState.PDAStateType.ELEMENT),
        ASSIGNED_TERMINAL_RULE_CALL(IPDAState.PDAStateType.ELEMENT),
        START(IPDAState.PDAStateType.START),
        STOP(IPDAState.PDAStateType.STOP),
        TRANSITION(null),
        UNASSIGEND_ACTION_CALL(IPDAState.PDAStateType.ELEMENT),
        UNASSIGEND_KEYWORD(IPDAState.PDAStateType.ELEMENT),
        UNASSIGNED_DATATYPE_RULE_CALL(IPDAState.PDAStateType.ELEMENT),
        UNASSIGNED_PARSER_RULE_ENTER(IPDAState.PDAStateType.RULECALL_ENTER),
        UNASSIGNED_PARSER_RULE_EXIT(IPDAState.PDAStateType.RULECALL_EXIT),
        UNASSIGNED_TERMINAL_RULE_CALL(IPDAState.PDAStateType.ELEMENT);

        protected IPDAState.PDAStateType simpleType;

        private SynStateType(IPDAState.PDAStateType simpleType) {
            this.simpleType = simpleType;
        }

        public IPDAState.PDAStateType getSimpleType() {
            return this.simpleType;
        }

        public boolean isElement() {
            return this.simpleType == IPDAState.PDAStateType.ELEMENT;
        }

        public boolean isRuleCallEnter() {
            return this.simpleType == IPDAState.PDAStateType.RULECALL_ENTER;
        }

        public boolean isRuleCallExit() {
            return this.simpleType == IPDAState.PDAStateType.RULECALL_EXIT;
        }

        public boolean isStart() {
            return this.simpleType == IPDAState.PDAStateType.START;
        }

        public boolean isStop() {
            return this.simpleType == IPDAState.PDAStateType.STOP;
        }
    }
}

