/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.ui.editor.syntaxcoloring.LightweightPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergingHighlightedPositionAcceptor
implements IHighlightedPositionAcceptor,
ISemanticHighlightingCalculator {
    private final ISemanticHighlightingCalculator delegate;
    private final List<LightweightPosition> positions;
    private int timestamp;
    private int expectedOffset;
    private boolean requireMerge;

    public MergingHighlightedPositionAcceptor(ISemanticHighlightingCalculator delegate) {
        this.delegate = delegate;
        this.positions = new ArrayList<LightweightPosition>(50);
        this.initialize();
    }

    @Override
    public void addPosition(int offset, int length, String ... ids) {
        if (length > 0) {
            this.getPositions().add(new LightweightPosition(offset, length, this.timestamp, ids));
            if (offset < this.expectedOffset) {
                this.requireMerge = true;
            }
            this.expectedOffset = offset + length;
        }
        ++this.timestamp;
    }

    @Override
    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        this.initialize();
        this.delegate.provideHighlightingFor(resource, this);
        this.mergePositions();
        for (LightweightPosition pos : this.getPositions()) {
            acceptor.addPosition(pos.getOffset(), pos.getLength(), pos.getIds());
        }
    }

    private void initialize() {
        if (!this.positions.isEmpty()) {
            this.positions.clear();
        }
        this.timestamp = 0;
        this.expectedOffset = 0;
        this.requireMerge = false;
    }

    public void mergePositions() {
        if (this.getPositions().size() < 2 || !this.requireMerge) {
            return;
        }
        Collections.sort(this.getPositions());
        LightweightPosition prev = this.getPositions().get(0);
        int i = 1;
        while (i < this.getPositions().size()) {
            LightweightPosition next = this.getPositions().get(i);
            int exclusiveEndOffset = prev.getOffset() + prev.getLength();
            if (next.getOffset() < exclusiveEndOffset) {
                int newLength = next.getOffset() - prev.getOffset();
                prev.setLength(newLength);
                this.mergePositions(i, exclusiveEndOffset, prev.getTimestamp(), prev.internalGetIds());
                if (prev.getLength() == 0) {
                    this.getPositions().remove(i - 1);
                }
            }
            if (prev.getLength() != 0) {
                ++i;
            }
            prev = next;
        }
    }

    private void mergePositions(int listIdx, int exclusiveEndOffset, int timestamp, LightweightPosition.IntToStringArray[] ids) {
        int newPosSize;
        int prevEnd;
        int i = listIdx;
        List newPositions = null;
        LightweightPosition prev = null;
        while (i < this.getPositions().size()) {
            int prevEnd2;
            LightweightPosition next = this.getPositions().get(i);
            if (next.getOffset() >= exclusiveEndOffset) {
                int newPosSize2;
                if (prev != null && (prevEnd2 = prev.getOffset() + prev.getLength()) != exclusiveEndOffset) {
                    if (newPositions == null) {
                        newPositions = Lists.newArrayListWithExpectedSize((int)4);
                    }
                    newPositions.add(new LightweightPosition(prevEnd2, exclusiveEndOffset - prevEnd2, timestamp, ids));
                }
                int n = newPosSize2 = newPositions != null ? newPositions.size() : 0;
                if (newPosSize2 != 0) {
                    this.getPositions().addAll(i, newPositions);
                }
                if (i + newPosSize2 != listIdx) {
                    Collections.sort(this.getPositions().subList(listIdx, i + newPosSize2));
                }
                return;
            }
            if (prev != null && (prevEnd2 = prev.getOffset() + prev.getLength()) < next.getOffset()) {
                if (newPositions == null) {
                    newPositions = Lists.newArrayListWithExpectedSize((int)4);
                }
                newPositions.add(new LightweightPosition(prevEnd2, next.getOffset() - prevEnd2, timestamp, ids));
            }
            if (next.getOffset() + next.getLength() <= exclusiveEndOffset) {
                next.merge(ids);
            } else {
                int oldLength = next.getLength();
                next.setLength(exclusiveEndOffset - next.getOffset());
                if (newPositions == null) {
                    newPositions = Lists.newArrayListWithExpectedSize((int)4);
                }
                newPositions.add(new LightweightPosition(next.getOffset() + next.getLength(), oldLength - next.getLength(), next.getTimestamp(), next.getIds()));
                next.merge(ids);
            }
            ++i;
            prev = next;
        }
        if (prev != null && (prevEnd = prev.getOffset() + prev.getLength()) < exclusiveEndOffset) {
            if (newPositions == null) {
                newPositions = Lists.newArrayListWithExpectedSize((int)4);
            }
            newPositions.add(new LightweightPosition(prevEnd, exclusiveEndOffset - prevEnd, timestamp, ids));
        }
        int n = newPosSize = newPositions != null ? newPositions.size() : 0;
        if (newPosSize != 0) {
            this.getPositions().addAll(i, newPositions);
        }
        if (i - 1 + newPosSize != listIdx) {
            Collections.sort(this.getPositions().subList(listIdx, i + newPosSize));
        }
    }

    public List<LightweightPosition> getPositions() {
        return this.positions;
    }
}

