/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;
import org.eclipse.xtext.ui.editor.model.ITokenTypeToPartitionTypeMapper;
import org.eclipse.xtext.ui.editor.model.Regions;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionTokenScanner
implements IPartitionTokenScanner {
    private Iterator<ILexerTokenRegion> tokens;
    private int currentPartitionOffSet = 0;
    private ILexerTokenRegion firstOfNext = null;
    @Inject
    private ITokenTypeToPartitionTypeMapper mapper;
    private int currentPartitionLength;

    public void setMapper(ITokenTypeToPartitionTypeMapper mapper) {
        this.mapper = mapper;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.setPartialRange(document, offset, length, null, 0);
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.tokens = Iterables.filter(this.getTokens(document), Regions.overlaps(offset, length)).iterator();
        this.currentPartitionOffSet = 0;
        this.firstOfNext = this.tokens.hasNext() ? this.tokens.next() : null;
    }

    protected Iterable<ILexerTokenRegion> getTokens(IDocument document) {
        return ((XtextDocument)document).getTokens();
    }

    public IToken nextToken() {
        if (this.firstOfNext == null) {
            return Token.EOF;
        }
        this.currentPartitionOffSet = this.firstOfNext.getOffset();
        this.currentPartitionLength = this.firstOfNext.getLength();
        String tokenPartition = this.mapper.getPartitionType(this.firstOfNext.getLexerTokenType());
        while (this.tokens.hasNext()) {
            this.firstOfNext = this.tokens.next();
            String partitionOfNext = this.mapper.getPartitionType(this.firstOfNext.getLexerTokenType());
            this.currentPartitionLength = this.firstOfNext.getOffset() - this.currentPartitionOffSet;
            if (partitionOfNext.equals(tokenPartition)) continue;
            return new Token((Object)tokenPartition);
        }
        this.firstOfNext = null;
        return new Token((Object)tokenPartition);
    }

    public int getTokenOffset() {
        return this.currentPartitionOffSet;
    }

    public int getTokenLength() {
        return this.currentPartitionLength;
    }
}

