/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public abstract class WizardImportPage
extends WizardDataTransferPage {
    private IResource currentResourceSelection;
    private String initialContainerFieldValue;
    private Text containerNameField;
    private Button containerBrowseButton;

    protected WizardImportPage(String name, IStructuredSelection selection) {
        super(name);
        this.currentResourceSelection = selection.size() == 1 ? (IResource)selection.getFirstElement() : null;
        if (this.currentResourceSelection != null) {
            if (this.currentResourceSelection.getType() == 1) {
                this.currentResourceSelection = this.currentResourceSelection.getParent();
            }
            if (!this.currentResourceSelection.isAccessible()) {
                this.currentResourceSelection = null;
            }
        }
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        this.createSourceGroup(composite);
        this.createSpacer(composite);
        this.createBoldLabel(composite, IDEWorkbenchMessages.WizardImportPage_destinationLabel);
        this.createDestinationGroup(composite);
        this.createSpacer(composite);
        this.createBoldLabel(composite, IDEWorkbenchMessages.WizardImportPage_options);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite);
    }

    protected final void createDestinationGroup(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        Label resourcesLabel = new Label(containerGroup, 0);
        resourcesLabel.setText(IDEWorkbenchMessages.WizardImportPage_folder);
        this.containerNameField = new Text(containerGroup, 2052);
        this.containerNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.containerNameField.setLayoutData((Object)data);
        this.containerBrowseButton = new Button(containerGroup, 8);
        this.containerBrowseButton.setText(IDEWorkbenchMessages.WizardImportPage_browseLabel);
        this.containerBrowseButton.setLayoutData((Object)new GridData(256));
        this.containerBrowseButton.addListener(13, (Listener)this);
        this.initialPopulateContainerField();
    }

    protected abstract void createSourceGroup(Composite var1);

    protected void displayErrorDialog(String message) {
        MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardImportPage_errorDialogTitle, (String)message, (int)0x10000000);
    }

    protected IPath getContainerFullPath() {
        IPath testPath;
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IStatus result = workspace.validatePath((testPath = this.getResourcePath()).toString(), 6);
        if (result.isOK()) {
            return testPath;
        }
        return null;
    }

    protected IPath getResourcePath() {
        return this.getPathFromText(this.containerNameField);
    }

    protected IContainer getSpecifiedContainer() {
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IPath path = this.getContainerFullPath();
        if (workspace.getRoot().exists(path)) {
            return (IContainer)workspace.getRoot().findMember(path);
        }
        return null;
    }

    protected void handleContainerBrowseButtonPressed() {
        IPath containerPath = this.queryForContainer(this.getSpecifiedContainer(), IDEWorkbenchMessages.WizardImportPage_selectFolderLabel);
        if (containerPath != null) {
            this.containerNameField.setText(containerPath.makeRelative().toString());
        }
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.containerBrowseButton) {
            this.handleContainerBrowseButtonPressed();
        }
        this.setPageComplete(this.determinePageCompletion());
        this.updateWidgetEnablements();
    }

    protected final void initialPopulateContainerField() {
        if (this.initialContainerFieldValue != null) {
            this.containerNameField.setText(this.initialContainerFieldValue);
        } else if (this.currentResourceSelection != null) {
            this.containerNameField.setText(this.currentResourceSelection.getFullPath().toString());
        }
    }

    public void setContainerFieldValue(String value) {
        if (this.containerNameField == null) {
            this.initialContainerFieldValue = value;
        } else {
            this.containerNameField.setText(value);
        }
    }

    protected final boolean validateDestinationGroup() {
        if (this.getContainerFullPath() == null) {
            return false;
        }
        IContainer container = this.getSpecifiedContainer();
        if (container != null && !container.isAccessible()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardImportPage_folderMustExist);
            return false;
        }
        return true;
    }
}

