/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute;

import java.io.File;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.acute.AcutePreferenceInitializer;
import org.eclipse.acute.DotnetVersionUtil;
import org.eclipse.acute.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AcutePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String PAGE_ID = "org.eclipse.acute.preferencePage";
    private IPreferenceStore store;
    private Text explicitDotnetPathText;
    private Label versionLabel;

    public void init(IWorkbench workbench) {
        this.store = this.doGetPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.createDotnetPathPart(container);
        this.initializeContent();
        return container;
    }

    private void initializeContent() {
        this.explicitDotnetPathText.setText(this.store.getString(AcutePreferenceInitializer.explicitDotnetPathPreference));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return AcutePlugin.getDefault().getPreferenceStore();
    }

    private boolean isPageValid() {
        if (this.explicitDotnetPathText.getText().isEmpty()) {
            this.setErrorMessage(Messages.preferences_EmptyPathError);
            return false;
        }
        File dotnetCommand = new File(this.explicitDotnetPathText.getText());
        if (!dotnetCommand.exists() || !dotnetCommand.isFile()) {
            this.setErrorMessage(Messages.preferences_InvalidPathError);
            return false;
        }
        if (!dotnetCommand.canExecute()) {
            this.setErrorMessage(Messages.preferences_NonexecutablePathError);
            return false;
        }
        String version = DotnetVersionUtil.getVersion(this.explicitDotnetPathText.getText());
        if (!DotnetVersionUtil.isValidVersionFormat(version)) {
            this.setErrorMessage(Messages.dotnetInvalidPathError_message);
            return false;
        }
        if (!DotnetVersionUtil.isValidVersionNumber(version)) {
            this.setErrorMessage(Messages.dotnetInvalidVersionError_message);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void performDefaults() {
        this.explicitDotnetPathText.setText(this.store.getDefaultString(AcutePreferenceInitializer.explicitDotnetPathPreference));
        super.performDefaults();
    }

    public boolean performOk() {
        this.store.setValue(AcutePreferenceInitializer.explicitDotnetPathPreference, this.explicitDotnetPathText.getText());
        return super.performOk();
    }

    private void createDotnetPathPart(Composite container) {
        Label infoLabel = new Label(container, 64);
        infoLabel.setText(Messages.preferences_DotnetPathInfo);
        infoLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridData textIndent = new GridData(4, 0x1000000, true, false, 1, 1);
        textIndent.horizontalIndent = 25;
        this.explicitDotnetPathText = new Text(container, 2048);
        this.explicitDotnetPathText.setLayoutData((Object)textIndent);
        this.explicitDotnetPathText.addModifyListener(e -> {
            this.setValid(this.isPageValid());
            this.versionLabel.setText(NLS.bind((String)Messages.preferences_CommandVersion, (Object)DotnetVersionUtil.getVersion(this.explicitDotnetPathText.getText())));
        });
        Button browseButton = new Button(container, 0);
        browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        browseButton.setText(Messages.preferences_BrowseButton);
        browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(browseButton.getShell());
            String path = dialog.open();
            if (path != null) {
                this.explicitDotnetPathText.setText(path);
            }
        }));
        this.versionLabel = new Label(container, 0);
        this.versionLabel.setLayoutData((Object)textIndent);
        this.versionLabel.setEnabled(false);
    }
}

