/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.debug;

import java.util.HashSet;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.acute.Messages;
import org.eclipse.acute.debug.DebuggersRegistry;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class DotnetDebugLaunchShortcut
implements ILaunchShortcut2 {
    public void launch(ISelection selection, String mode) {
        try {
            this.getLaunchConfigurations(selection)[0].launch(mode, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void launch(IEditorPart editor, String mode) {
        try {
            this.getLaunchConfigurations(editor)[0].launch(mode, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return new ILaunchConfiguration[]{this.getLaunchConfiguration(this.getLaunchableResource(selection))};
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return new ILaunchConfiguration[]{this.getLaunchConfiguration(this.getLaunchableResource(editorpart))};
    }

    public IResource getLaunchableResource(ISelection selection) {
        HashSet<IResource> resources = new HashSet<IResource>();
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                IResource resource = (IResource)Adapters.adapt((Object)o, IResource.class);
                if (resource != null) {
                    resources.add(resource);
                }
                ++n2;
            }
        }
        if (resources.isEmpty()) {
            return null;
        }
        if (resources.size() == 1) {
            return (IResource)resources.iterator().next();
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        if (editorpart.getEditorInput() instanceof IFileEditorInput) {
            return ((FileEditorInput)editorpart.getEditorInput()).getFile();
        }
        return null;
    }

    private ILaunchConfiguration getLaunchConfiguration(IResource resource) {
        String mode = "debug";
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("org.eclipse.acute.debug.launchType");
        try {
            ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(configType);
            String configName = resource.getLocation().toFile().isFile() ? NLS.bind((String)Messages.DotnetRunDelegate_configuration, (Object)(String.valueOf(resource.getParent().getName()) + "." + resource.getName())) : NLS.bind((String)Messages.DotnetRunDelegate_configuration, (Object)resource.getName());
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
            int n = launchConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n2];
                if (iLaunchConfiguration.getName().equals(configName) && iLaunchConfiguration.getModes().contains("debug")) {
                    return iLaunchConfiguration;
                }
                ++n2;
            }
            configName = launchManager.generateLaunchConfigurationName(configName);
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, configName);
            if (resource.getLocation().toFile().isFile()) {
                resource = resource.getParent();
            }
            wc.setAttribute("PROJECT_FOLDER", resource.getFullPath().toString());
            DebuggersRegistry.DebuggerInfo info = DebuggersRegistry.getDefaultDebugger();
            wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", info.debugger.getAbsolutePath());
            wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", info.args);
            return wc;
        }
        catch (CoreException e) {
            AcutePlugin.logError(e);
            return null;
        }
    }
}

