/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.debug;

import org.eclipse.acute.AcutePlugin;
import org.eclipse.acute.Messages;
import org.eclipse.acute.Tester;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DebugLaunchMainTab
extends AbstractLaunchConfigurationTab {
    private Combo projectCombo;
    private Text programArgsText;

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(2, false));
        Label project = new Label(control, 0);
        project.setText(Messages.AcuteDebugMainTab_project);
        this.projectCombo = new Combo(control, 2048);
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (Tester.isDotnetProject(p)) {
                this.projectCombo.add(p.getName());
            }
            ++n2;
        }
        ControlDecoration projectComboDecoration = new ControlDecoration((Control)this.projectCombo, 16512);
        projectComboDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        this.projectCombo.addModifyListener(e -> {
            this.setDirty(true);
            String projectName = this.projectCombo.getText();
            IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (p == null || !p.exists()) {
                this.setErrorMessage(Messages.AcuteDebugMainTab_notAProject);
                projectComboDecoration.setDescriptionText(Messages.AcuteDebugMainTab_notAProject);
                projectComboDecoration.show();
            } else if (!Tester.isDotnetProject(p)) {
                this.setErrorMessage(Messages.AcuteDebugMainTab_notADotnetProject);
                projectComboDecoration.setDescriptionText(Messages.AcuteDebugMainTab_notADotnetProject);
                projectComboDecoration.show();
            } else {
                this.setErrorMessage(null);
                projectComboDecoration.hide();
            }
            this.updateLaunchConfigurationDialog();
        });
        Label programArgsLabel = new Label(control, 0);
        programArgsLabel.setText(Messages.AcuteDebugMainTab_promgramArgs);
        this.programArgsText = new Text(control, 2048);
        this.programArgsText.addModifyListener(e -> this.setDirty(true));
        this.setControl((Control)control);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.projectCombo.setText(configuration.getAttribute("PROJECT_FOLDER", ""));
            if (this.projectCombo.getText().isEmpty() && this.projectCombo.getItems().length > 0) {
                this.projectCombo.setText(this.projectCombo.getItems()[0]);
            }
            this.programArgsText.setText(configuration.getAttribute("PROJECT_ARGUMENTS", ""));
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.getProject() != null) {
            configuration.setAttribute("PROJECT_FOLDER", this.getProject().getName());
        }
        String programArgs = this.programArgsText.getText();
        configuration.setAttribute("PROJECT_ARGUMENTS", programArgs);
    }

    private IContainer getProject() {
        String projectName = this.projectCombo.getText();
        if (projectName != null && !projectName.isEmpty()) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    public String getName() {
        return Messages.AcuteDebugMainTab_title;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String projectName;
        block4: {
            if (!super.isValid(launchConfig)) {
                return false;
            }
            try {
                projectName = launchConfig.getAttribute("PROJECT_FOLDER", "");
                if (!projectName.isEmpty()) break block4;
                return false;
            }
            catch (CoreException e) {
                AcutePlugin.logError(e);
                this.setErrorMessage(e.getMessage());
                return false;
            }
        }
        return Tester.isDotnetProject(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
    }
}

