/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import org.objectweb.asm.ByteVector;
import org.objectweb.asm.Edge;
import org.objectweb.asm.Frame;
import org.objectweb.asm.MethodVisitor;

public class Label {
    static final int FLAG_DEBUG_ONLY = 1;
    static final int FLAG_JUMP_TARGET = 2;
    static final int FLAG_RESOLVED = 4;
    static final int FLAG_REACHABLE = 8;
    static final int FLAG_SUBROUTINE_CALLER = 16;
    static final int FLAG_SUBROUTINE_START = 32;
    static final int FLAG_SUBROUTINE_BODY = 64;
    static final int FLAG_SUBROUTINE_END = 128;
    static final int LINE_NUMBERS_CAPACITY_INCREMENT = 4;
    static final int VALUES_CAPACITY_INCREMENT = 6;
    static final int FORWARD_REFERENCE_TYPE_MASK = -268435456;
    static final int FORWARD_REFERENCE_TYPE_SHORT = 0x10000000;
    static final int FORWARD_REFERENCE_TYPE_WIDE = 0x20000000;
    static final int FORWARD_REFERENCE_HANDLE_MASK = 0xFFFFFFF;
    static final Label EMPTY_LIST = new Label();
    public Object info;
    short flags;
    private short lineNumber;
    private int[] otherLineNumbers;
    int bytecodeOffset;
    private short valueCount;
    private int[] values;
    short inputStackSize;
    short outputStackSize;
    short outputStackMax;
    Frame frame;
    Label nextBasicBlock;
    Edge outgoingEdges;
    Label nextListElement;

    public int getOffset() {
        if ((this.flags & 4) == 0) {
            throw new IllegalStateException("Label offset position has not been resolved yet");
        }
        return this.bytecodeOffset;
    }

    final Label getCanonicalInstance() {
        return this.frame == null ? this : this.frame.owner;
    }

    final void addLineNumber(int lineNumber) {
        if (this.lineNumber == 0) {
            this.lineNumber = (short)lineNumber;
        } else {
            int otherLineNumberIndex;
            if (this.otherLineNumbers == null) {
                this.otherLineNumbers = new int[4];
            }
            if ((otherLineNumberIndex = (this.otherLineNumbers[0] = this.otherLineNumbers[0] + 1)) >= this.otherLineNumbers.length) {
                int[] newLineNumbers = new int[this.otherLineNumbers.length + 6];
                System.arraycopy(this.otherLineNumbers, 0, newLineNumbers, 0, this.otherLineNumbers.length);
                this.otherLineNumbers = newLineNumbers;
            }
            this.otherLineNumbers[otherLineNumberIndex] = lineNumber;
        }
    }

    final void accept(MethodVisitor methodVisitor, boolean visitLineNumbers) {
        methodVisitor.visitLabel(this);
        if (visitLineNumbers && this.lineNumber != 0) {
            methodVisitor.visitLineNumber(this.lineNumber & 0xFFFF, this);
            if (this.otherLineNumbers != null) {
                for (int i = 1; i <= this.otherLineNumbers[0]; ++i) {
                    methodVisitor.visitLineNumber(this.otherLineNumbers[i], this);
                }
            }
        }
    }

    final void put(ByteVector code, int sourceInsnBytecodeOffset, boolean wideReference) {
        if ((this.flags & 4) == 0) {
            if (wideReference) {
                this.addForwardReference(sourceInsnBytecodeOffset, 0x20000000, code.length);
                code.putInt(-1);
            } else {
                this.addForwardReference(sourceInsnBytecodeOffset, 0x10000000, code.length);
                code.putShort(-1);
            }
        } else if (wideReference) {
            code.putInt(this.bytecodeOffset - sourceInsnBytecodeOffset);
        } else {
            code.putShort(this.bytecodeOffset - sourceInsnBytecodeOffset);
        }
    }

    private void addForwardReference(int sourceInsnBytecodeOffset, int referenceType, int referenceHandle) {
        if (this.values == null) {
            this.values = new int[6];
        }
        if (this.valueCount >= this.values.length) {
            int[] newValues = new int[this.values.length + 6];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            this.values = newValues;
        }
        short s = this.valueCount;
        this.valueCount = (short)(s + 1);
        this.values[s] = sourceInsnBytecodeOffset;
        short s2 = this.valueCount;
        this.valueCount = (short)(s2 + 1);
        this.values[s2] = referenceType | referenceHandle;
    }

    final boolean resolve(byte[] code, int bytecodeOffset) {
        this.flags = (short)(this.flags | 4);
        this.bytecodeOffset = bytecodeOffset;
        boolean hasAsmInstructions = false;
        for (int i = 0; i < this.valueCount; i += 2) {
            int sourceInsnBytecodeOffset = this.values[i];
            int reference = this.values[i + 1];
            int relativeOffset = bytecodeOffset - sourceInsnBytecodeOffset;
            int handle = reference & 0xFFFFFFF;
            if ((reference & 0xF0000000) == 0x10000000) {
                if (relativeOffset < Short.MIN_VALUE || relativeOffset > Short.MAX_VALUE) {
                    int opcode = code[sourceInsnBytecodeOffset] & 0xFF;
                    code[sourceInsnBytecodeOffset] = opcode < 198 ? (byte)(opcode + 49) : (byte)(opcode + 20);
                    hasAsmInstructions = true;
                }
                code[handle++] = (byte)(relativeOffset >>> 8);
                code[handle] = (byte)relativeOffset;
                continue;
            }
            code[handle++] = (byte)(relativeOffset >>> 24);
            code[handle++] = (byte)(relativeOffset >>> 16);
            code[handle++] = (byte)(relativeOffset >>> 8);
            code[handle] = (byte)relativeOffset;
        }
        return hasAsmInstructions;
    }

    final void markSubroutine(int subroutineId, int numSubroutine) {
        Label listOfBlocksToProcess = this;
        listOfBlocksToProcess.nextListElement = EMPTY_LIST;
        while (listOfBlocksToProcess != EMPTY_LIST) {
            Label basicBlock = listOfBlocksToProcess;
            listOfBlocksToProcess = listOfBlocksToProcess.nextListElement;
            basicBlock.nextListElement = null;
            if (basicBlock.isInSubroutine(subroutineId)) continue;
            basicBlock.addToSubroutine(subroutineId, numSubroutine);
            listOfBlocksToProcess = basicBlock.pushSuccessors(listOfBlocksToProcess);
        }
    }

    final void addSubroutineRetSuccessors(Label subroutineCaller) {
        Label listOfProcessedBlocks = EMPTY_LIST;
        Label listOfBlocksToProcess = this;
        listOfBlocksToProcess.nextListElement = EMPTY_LIST;
        while (listOfBlocksToProcess != EMPTY_LIST) {
            Label basicBlock = listOfBlocksToProcess;
            listOfBlocksToProcess = basicBlock.nextListElement;
            basicBlock.nextListElement = listOfProcessedBlocks;
            listOfProcessedBlocks = basicBlock;
            if ((basicBlock.flags & 0x80) != 0 && !basicBlock.isInSameSubroutine(subroutineCaller)) {
                basicBlock.outgoingEdges = new Edge(basicBlock.outputStackSize, subroutineCaller.outgoingEdges.successor, basicBlock.outgoingEdges);
            }
            listOfBlocksToProcess = basicBlock.pushSuccessors(listOfBlocksToProcess);
        }
        while (listOfProcessedBlocks != EMPTY_LIST) {
            Label newListOfProcessedBlocks = listOfProcessedBlocks.nextListElement;
            listOfProcessedBlocks.nextListElement = null;
            listOfProcessedBlocks = newListOfProcessedBlocks;
        }
    }

    private Label pushSuccessors(Label listOfLabelsToProcess) {
        Label newListOfLabelsToProcess = listOfLabelsToProcess;
        Edge outgoingEdge = this.outgoingEdges;
        while (outgoingEdge != null) {
            boolean isJsrTarget;
            boolean bl = isJsrTarget = (this.flags & 0x10) != 0 && outgoingEdge == this.outgoingEdges.nextEdge;
            if (!isJsrTarget && outgoingEdge.successor.nextListElement == null) {
                outgoingEdge.successor.nextListElement = newListOfLabelsToProcess;
                newListOfLabelsToProcess = outgoingEdge.successor;
            }
            outgoingEdge = outgoingEdge.nextEdge;
        }
        return newListOfLabelsToProcess;
    }

    private boolean isInSubroutine(int subroutineId) {
        if ((this.flags & 0x40) != 0) {
            return (this.values[subroutineId / 32] & 1 << subroutineId % 32) != 0;
        }
        return false;
    }

    private boolean isInSameSubroutine(Label basicBlock) {
        if ((this.flags & 0x40) == 0 || (basicBlock.flags & 0x40) == 0) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if ((this.values[i] & basicBlock.values[i]) == 0) continue;
            return true;
        }
        return false;
    }

    private void addToSubroutine(int subroutineId, int numSubroutine) {
        if ((this.flags & 0x40) == 0) {
            this.flags = (short)(this.flags | 0x40);
            this.values = new int[numSubroutine / 32 + 1];
        }
        int n = subroutineId / 32;
        this.values[n] = this.values[n] | 1 << subroutineId % 32;
    }

    public String toString() {
        return "L" + System.identityHashCode(this);
    }
}

