/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.formatting;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;

@Singleton
public class PreferenceStoreIndentationInformation
implements IIndentationInformation,
IPropertyChangeListener {
    private IPreferenceStoreAccess storeAccess;
    private final String WS = "                                     ";
    private String indentString = null;

    @Inject
    public void setPreferenceStoreAccess(IPreferenceStoreAccess storeAccess) {
        this.storeAccess = storeAccess;
        storeAccess.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public int getTabWidth() {
        return this.storeAccess.getPreferenceStore().getInt("tabWidth");
    }

    public boolean isSpacesForTab() {
        return this.storeAccess.getPreferenceStore().getBoolean("spacesForTabs");
    }

    public synchronized String getIndentString() {
        if (this.indentString == null) {
            this.indentString = this.isSpacesForTab() ? "                                     ".substring(0, Math.min(this.getTabWidth(), "                                     ".length())) : "\t";
        }
        return this.indentString;
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("tabWidth".equals(property) || "spacesForTabs".equals(property)) {
            this.indentString = null;
        }
    }
}

