/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.validation;

import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.structuredtextcore.Messages;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class STCoreImportValidator {
    public static final String WILDCARD = "*";
    @Inject
    private IQualifiedNameConverter nameConverter;
    @Inject
    private IGlobalScopeProvider globalScopeProvider;

    public void validateImports(String packageName, List<? extends Import> imports, Set<QualifiedName> usedTypes, ValidationMessageAcceptor acceptor) {
        if (imports.isEmpty()) {
            return;
        }
        QualifiedName packageQualifiedName = Strings.isEmpty((String)packageName) ? QualifiedName.EMPTY : this.nameConverter.toQualifiedName(packageName);
        IScope scope = this.globalScopeProvider.getScope(imports.get(0).eResource(), STCorePackage.eINSTANCE.getSTFeatureExpression_Feature(), null);
        imports.stream().forEach(imp -> this.validateImport((Import)imp, packageQualifiedName, usedTypes, scope, acceptor));
    }

    protected void validateImport(Import imp, QualifiedName packageName, Set<QualifiedName> usedTypes, IScope scope, ValidationMessageAcceptor acceptor) {
        String importedNamespace = imp.getImportedNamespace();
        if (Strings.isEmpty((String)importedNamespace)) {
            return;
        }
        QualifiedName qualifiedName = this.nameConverter.toQualifiedName(importedNamespace);
        if (qualifiedName == null || qualifiedName.isEmpty()) {
            return;
        }
        if (WILDCARD.equals(qualifiedName.getLastSegment())) {
            if (qualifiedName.getSegmentCount() <= 1) {
                acceptor.acceptError(MessageFormat.format(Messages.STCoreValidator_InvalidWildcardImport, importedNamespace), (EObject)imp, (EStructuralFeature)LibraryElementPackage.eINSTANCE.getImport_ImportedNamespace(), -1, "org.eclipse.fordiac.ide.structuredtextcore.invalidImport", new String[]{importedNamespace});
            } else if (!this.existsWildcardImport(qualifiedName, (EObject)imp)) {
                acceptor.acceptError(MessageFormat.format(Messages.STCoreImportValidator_ImportNotFound, importedNamespace), (EObject)imp, (EStructuralFeature)LibraryElementPackage.eINSTANCE.getImport_ImportedNamespace(), -1, "org.eclipse.fordiac.ide.structuredtextcore.invalidImport", new String[]{importedNamespace});
            } else {
                acceptor.acceptWarning(MessageFormat.format(Messages.STCoreValidator_WildcardImportDiscouraged, importedNamespace), (EObject)imp, (EStructuralFeature)LibraryElementPackage.eINSTANCE.getImport_ImportedNamespace(), -1, "org.eclipse.fordiac.ide.structuredtextcore.wildcardImport", new String[]{importedNamespace});
            }
        } else if (scope.getSingleElement(qualifiedName) == null) {
            acceptor.acceptError(MessageFormat.format(Messages.STCoreImportValidator_ImportNotFound, importedNamespace), (EObject)imp, (EStructuralFeature)LibraryElementPackage.eINSTANCE.getImport_ImportedNamespace(), -1, "org.eclipse.fordiac.ide.structuredtextcore.invalidImport", new String[]{importedNamespace});
        } else if (STCoreImportValidator.isImplicitImport(qualifiedName, packageName) || STCoreImportValidator.isUnusedImport(qualifiedName, usedTypes)) {
            acceptor.acceptWarning(MessageFormat.format(Messages.STCoreValidator_UnusedImport, importedNamespace), (EObject)imp, (EStructuralFeature)LibraryElementPackage.eINSTANCE.getImport_ImportedNamespace(), -1, "org.eclipse.fordiac.ide.structuredtextcore.unusedImport", new String[]{importedNamespace});
        }
    }

    protected boolean existsWildcardImport(QualifiedName qualifiedName, EObject context) {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext(context);
        return typeLibrary == null || typeLibrary.getPackages().contains(this.nameConverter.toString(qualifiedName.skipLast(1))) || typeLibrary.getGlobalConstantsEntry(this.nameConverter.toString(qualifiedName.skipLast(1))) != null;
    }

    public static boolean isImplicitImport(QualifiedName imported, QualifiedName packageName) {
        return imported.getSegmentCount() <= 1 || imported.skipLast(1).equals((Object)packageName);
    }

    protected static boolean isUnusedImport(QualifiedName imported, Set<QualifiedName> usedTypes) {
        return !usedTypes.contains(imported) && usedTypes.stream().noneMatch(usedType -> usedType.startsWithIgnoreCase(imported));
    }
}

