/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.interactors;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.AbstractDelegatingDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementExecutorService;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.GlobalConstantsEntry;

public class DeviceManagementExecutorService
extends AbstractDelegatingDeviceManagementInteractor
implements IDeviceManagementExecutorService {
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    protected DeviceManagementExecutorService(IDeviceManagementInteractor delegate) {
        super(delegate);
    }

    @Override
    public void connect() throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.connectAsync());
    }

    @Override
    public void disconnect() throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.disconnectAsync());
    }

    @Override
    public void createResource(Resource resource) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.createResourceAsync(resource));
    }

    @Override
    public void writeResourceParameter(Resource resource, String parameter, String value) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.writeResourceParameterAsync(resource, parameter, value));
    }

    @Override
    public void writeDeviceParameter(Device device, String parameter, String value) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.writeDeviceParameterAsync(device, parameter, value));
    }

    @Override
    public void createFBInstance(FBDeploymentData fb, Resource res) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.createFBInstanceAsync(fb, res));
    }

    @Override
    public void writeFBParameter(Resource resource, String name, String value) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.writeFBParameterAsync(resource, name, value));
    }

    @Override
    public void writeFBParameter(Resource resource, String value, FBDeploymentData fb, VarDeclaration varDecl) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.writeFBParameterAsync(resource, value, fb, varDecl));
    }

    @Override
    public void createConnection(Resource res, ConnectionDeploymentData connectionData) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.createConnectionAsync(res, connectionData));
    }

    @Override
    public void startFB(Resource res, FBDeploymentData fb) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.startFBAsync(res, fb));
    }

    @Override
    public void startResource(Resource res) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.startResourceAsync(res));
    }

    @Override
    public void resetResource(String resName) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.resetResourceAsync(resName));
    }

    @Override
    public void killResource(String resName) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.killResourceAsync(resName));
    }

    @Override
    public void stopResource(Resource res) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.stopResourceAsync(res));
    }

    @Override
    public void startDevice(Device dev) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.startDeviceAsync(dev));
    }

    @Override
    public void deleteResource(String resName) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.deleteResourceAsync(resName));
    }

    @Override
    public void deleteFB(Resource res, FBDeploymentData fb) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.deleteFBAsync(res, fb));
    }

    @Override
    public void deleteConnection(Resource res, ConnectionDeploymentData con) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.deleteConnectionAsync(res, con));
    }

    @Override
    public void killDevice(Device dev) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.killDeviceAsync(dev));
    }

    @Override
    public List<org.eclipse.fordiac.ide.deployment.devResponse.Resource> queryResources() throws DeploymentException {
        return DeviceManagementExecutorService.unwrap(this.queryResourcesAsync());
    }

    @Override
    public Response queryFBType(FBTypeEntry entry) throws DeploymentException {
        return DeviceManagementExecutorService.unwrap(this.queryFBTypeAsync(entry));
    }

    @Override
    public Response queryDataType(DataTypeEntry entry) throws DeploymentException {
        return DeviceManagementExecutorService.unwrap(this.queryDataTypeAsync(entry));
    }

    @Override
    public Response queryGlobalConstType(GlobalConstantsEntry entry) throws DeploymentException {
        return DeviceManagementExecutorService.unwrap(this.queryGlobalConstTypeAsync(entry));
    }

    @Override
    public Response readWatches() throws DeploymentException {
        return DeviceManagementExecutorService.unwrap(this.readWatchesAsync());
    }

    @Override
    public boolean addWatch(Resource resource, String name) throws DeploymentException {
        return DeviceManagementExecutorService.unwrap(this.addWatchAsync(resource, name));
    }

    @Override
    public boolean removeWatch(Resource resource, String name) throws DeploymentException {
        return DeviceManagementExecutorService.unwrap(this.removeWatchAsync(resource, name));
    }

    @Override
    public void triggerEvent(Resource resource, String name) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.triggerEventAsync(resource, name));
    }

    @Override
    public void forceValue(Resource resource, String name, String value) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.forceValueAsync(resource, name, value));
    }

    @Override
    public void clearForce(Resource resource, String name) throws DeploymentException {
        DeviceManagementExecutorService.unwrap(this.clearForceAsync(resource, name));
    }

    @Override
    public Future<Void> connectAsync() {
        return this.executorService.submit(() -> {
            this.getDelegate().connect();
            return null;
        });
    }

    @Override
    public Future<Void> disconnectAsync() {
        return this.executorService.submit(() -> {
            this.getDelegate().disconnect();
            return null;
        });
    }

    @Override
    public Future<Void> createResourceAsync(Resource resource) {
        return this.executorService.submit(() -> {
            this.getDelegate().createResource(resource);
            return null;
        });
    }

    @Override
    public Future<Void> writeResourceParameterAsync(Resource resource, String parameter, String value) {
        return this.executorService.submit(() -> {
            this.getDelegate().writeResourceParameter(resource, parameter, value);
            return null;
        });
    }

    @Override
    public Future<Void> writeDeviceParameterAsync(Device device, String parameter, String value) {
        return this.executorService.submit(() -> {
            this.getDelegate().writeDeviceParameter(device, parameter, value);
            return null;
        });
    }

    @Override
    public Future<Void> createFBInstanceAsync(FBDeploymentData fb, Resource res) {
        return this.executorService.submit(() -> {
            this.getDelegate().createFBInstance(fb, res);
            return null;
        });
    }

    @Override
    public Future<Void> writeFBParameterAsync(Resource resource, String name, String value) throws DeploymentException {
        return this.executorService.submit(() -> {
            this.getDelegate().writeFBParameter(resource, name, value);
            return null;
        });
    }

    @Override
    public Future<Void> writeFBParameterAsync(Resource resource, String value, FBDeploymentData fb, VarDeclaration varDecl) throws DeploymentException {
        return this.executorService.submit(() -> {
            this.getDelegate().writeFBParameter(resource, value, fb, varDecl);
            return null;
        });
    }

    @Override
    public Future<Void> createConnectionAsync(Resource res, ConnectionDeploymentData connectionData) {
        return this.executorService.submit(() -> {
            this.getDelegate().createConnection(res, connectionData);
            return null;
        });
    }

    @Override
    public Future<Void> startFBAsync(Resource res, FBDeploymentData fb) {
        return this.executorService.submit(() -> {
            this.getDelegate().startFB(res, fb);
            return null;
        });
    }

    @Override
    public Future<Void> startResourceAsync(Resource res) {
        return this.executorService.submit(() -> {
            this.getDelegate().startResource(res);
            return null;
        });
    }

    @Override
    public Future<Void> resetResourceAsync(String resName) {
        return this.executorService.submit(() -> {
            this.getDelegate().resetResource(resName);
            return null;
        });
    }

    @Override
    public Future<Void> killResourceAsync(String resName) {
        return this.executorService.submit(() -> {
            this.getDelegate().killResource(resName);
            return null;
        });
    }

    @Override
    public Future<Void> stopResourceAsync(Resource res) {
        return this.executorService.submit(() -> {
            this.getDelegate().stopResource(res);
            return null;
        });
    }

    @Override
    public Future<Void> startDeviceAsync(Device dev) {
        return this.executorService.submit(() -> {
            this.getDelegate().startDevice(dev);
            return null;
        });
    }

    @Override
    public Future<Void> deleteResourceAsync(String resName) {
        return this.executorService.submit(() -> {
            this.getDelegate().deleteResource(resName);
            return null;
        });
    }

    @Override
    public Future<Void> deleteFBAsync(Resource res, FBDeploymentData fb) {
        return this.executorService.submit(() -> {
            this.getDelegate().deleteFB(res, fb);
            return null;
        });
    }

    @Override
    public Future<Void> deleteConnectionAsync(Resource res, ConnectionDeploymentData con) {
        return this.executorService.submit(() -> {
            this.getDelegate().deleteConnection(res, con);
            return null;
        });
    }

    @Override
    public Future<Void> killDeviceAsync(Device dev) {
        return this.executorService.submit(() -> {
            this.getDelegate().killDevice(dev);
            return null;
        });
    }

    @Override
    public Future<List<org.eclipse.fordiac.ide.deployment.devResponse.Resource>> queryResourcesAsync() {
        return this.executorService.submit(this.getDelegate()::queryResources);
    }

    @Override
    public Future<Response> queryFBTypeAsync(FBTypeEntry entry) {
        return this.executorService.submit(() -> this.getDelegate().queryFBType(entry));
    }

    @Override
    public Future<Response> queryDataTypeAsync(DataTypeEntry entry) {
        return this.executorService.submit(() -> this.getDelegate().queryDataType(entry));
    }

    @Override
    public Future<Response> queryGlobalConstTypeAsync(GlobalConstantsEntry entry) {
        return this.executorService.submit(() -> this.getDelegate().queryGlobalConstType(entry));
    }

    @Override
    public ScheduledFuture<Void> queryResourcesPeriodically(Consumer<List<org.eclipse.fordiac.ide.deployment.devResponse.Resource>> consumer, long period, TimeUnit unit) {
        return this.executorService.scheduleAtFixedRate(() -> {
            try {
                consumer.accept(this.getDelegate().queryResources());
            }
            catch (DeploymentException e) {
                DeviceManagementExecutorService.sneakyThrow(e);
            }
        }, 0L, period, unit);
    }

    @Override
    public ScheduledFuture<Void> queryResourcesPeriodically(Consumer<List<org.eclipse.fordiac.ide.deployment.devResponse.Resource>> consumer, Consumer<DeploymentException> error, long period, TimeUnit unit) {
        return this.executorService.scheduleAtFixedRate(() -> {
            try {
                consumer.accept(this.getDelegate().queryResources());
            }
            catch (DeploymentException e) {
                error.accept(e);
            }
        }, 0L, period, unit);
    }

    @Override
    public Future<Response> readWatchesAsync() {
        return this.executorService.submit(this.getDelegate()::readWatches);
    }

    @Override
    public ScheduledFuture<Void> readWatchesPeriodically(Consumer<Response> consumer, long period, TimeUnit unit) {
        return this.executorService.scheduleWithFixedDelay(() -> {
            try {
                consumer.accept(this.getDelegate().readWatches());
            }
            catch (DeploymentException e) {
                DeviceManagementExecutorService.sneakyThrow(e);
            }
        }, 0L, period, unit);
    }

    @Override
    public ScheduledFuture<Void> readWatchesPeriodically(Consumer<Response> consumer, Consumer<DeploymentException> error, long period, TimeUnit unit) {
        return this.executorService.scheduleWithFixedDelay(() -> {
            try {
                consumer.accept(this.getDelegate().readWatches());
            }
            catch (DeploymentException e) {
                error.accept(e);
            }
        }, 0L, period, unit);
    }

    @Override
    public Future<Boolean> addWatchAsync(Resource resource, String name) {
        return this.executorService.submit(() -> this.getDelegate().addWatch(resource, name));
    }

    @Override
    public Future<Boolean> removeWatchAsync(Resource resource, String name) {
        return this.executorService.submit(() -> this.getDelegate().removeWatch(resource, name));
    }

    @Override
    public Future<Void> triggerEventAsync(Resource resource, String name) {
        return this.executorService.submit(() -> {
            this.getDelegate().triggerEvent(resource, name);
            return null;
        });
    }

    @Override
    public Future<Void> forceValueAsync(Resource resource, String name, String value) {
        return this.executorService.submit(() -> {
            this.getDelegate().forceValue(resource, name, value);
            return null;
        });
    }

    @Override
    public Future<Void> clearForceAsync(Resource resource, String name) {
        return this.executorService.submit(() -> {
            this.getDelegate().clearForce(resource, name);
            return null;
        });
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public void close() throws Exception {
        this.executorService.close();
        if (this.getDelegate().isConnected()) {
            this.getDelegate().disconnect();
        }
    }

    @Override
    public Future<Void> readTracesAsync(Device device, String path) throws DeploymentException {
        return this.executorService.submit(() -> {
            this.getDelegate().readTraces(device, path);
            return null;
        });
    }

    @Override
    public Future<Optional<String>> replayNextEventAsync(Resource resource) throws DeploymentException {
        return this.executorService.submit(() -> this.getDelegate().replayNextEvent(resource));
    }

    private static <T> T unwrap(Future<T> future) throws DeploymentException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DeploymentException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof DeploymentException) {
                DeploymentException de = (DeploymentException)throwable;
                throw de;
            }
            throw new DeploymentException(e.getCause().getMessage(), e.getCause());
        }
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }
}

