/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.function;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public interface Functions {
    public static Value invoke(Class<? extends Functions> clazz, String name, Object ... arguments) throws Throwable {
        return Functions.invoke(clazz, name, List.of(arguments));
    }

    public static Value invoke(Class<? extends Functions> clazz, String name, List<Object> arguments) throws Throwable {
        Method method = Functions.findMethod(clazz, name, arguments.stream().map(argument -> argument != null ? argument.getClass() : Object.class).toList());
        MethodHandle handle = MethodHandles.lookup().unreflect(method);
        return (Value)handle.invokeWithArguments(arguments);
    }

    public static Method findMethod(Class<? extends Functions> clazz, String name, Class<?> ... argumentTypes) throws NoSuchMethodException, SecurityException {
        return Functions.findMethod(clazz, name, List.of(argumentTypes));
    }

    public static Method findMethod(Class<? extends Functions> clazz, String name, List<Class<?>> argumentTypes) throws NoSuchMethodException, SecurityException {
        try {
            return clazz.getMethod(name, argumentTypes.toArray(new Class[argumentTypes.size()]));
        }
        catch (NoSuchMethodException e) {
            List<Method> methods = Stream.of(clazz.getMethods()).filter(method -> method.getName().equals(name) && Functions.isAssignableFrom(List.of(method.getParameterTypes()), argumentTypes, method.isVarArgs())).toList();
            if (methods.isEmpty()) {
                throw new NoSuchMethodException(String.format("No method with name %s in class %s", name, clazz.getName()));
            }
            if (methods.size() > 1) {
                throw new IllegalStateException(String.format("Multiple candidates found for method with name %s in class %s", name, clazz.getName()));
            }
            return methods.get(0);
        }
    }

    public static List<Method> findMethods(Class<? extends Functions> clazz, String name) {
        return Stream.of(clazz.getMethods()).filter(method -> method.getName().equals(name)).toList();
    }

    public static List<Method> findMethods(Class<? extends Functions> clazz, List<Class<?>> argumentTypes) {
        Map exactMatches = Stream.of(clazz.getMethods()).filter(method -> List.of(method.getParameterTypes()).equals(argumentTypes)).collect(Collectors.toMap(Method::getName, Function.identity()));
        return Stream.concat(exactMatches.values().stream(), Stream.of(clazz.getMethods()).filter(method -> !exactMatches.containsKey(method.getName()) && Functions.isAssignableFrom(List.of(method.getParameterTypes()), argumentTypes, method.isVarArgs()))).toList();
    }

    public static List<Method> getMethods(Class<? extends Functions> clazz) {
        return List.of(clazz.getMethods());
    }

    public static Class<?> inferReturnType(Class<? extends Functions> clazz, String name, List<Class<?>> argumentTypes) throws NoSuchMethodException, SecurityException {
        return Functions.inferReturnType(Functions.findMethod(clazz, name, argumentTypes), argumentTypes);
    }

    public static Class<?> inferReturnType(Method method, List<Class<?>> argumentTypes) {
        try {
            Type returnType = method.getGenericReturnType();
            if (returnType instanceof TypeVariable) {
                Class<?> result = null;
                int i = 0;
                while (i < argumentTypes.size()) {
                    Type parameterTypeForArgument = Functions.getGenericParameterValueType(method, i);
                    if (parameterTypeForArgument != null && parameterTypeForArgument.equals(returnType)) {
                        result = Functions.commonSupertype(result, argumentTypes.get(i));
                    }
                    ++i;
                }
                if (result != null && method.getReturnType().isAssignableFrom(result)) {
                    return result;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method.getReturnType() != Void.TYPE ? method.getReturnType() : null;
    }

    public static List<Class<?>> inferParameterTypes(Class<? extends Functions> clazz, String name, List<Class<?>> argumentTypes) throws NoSuchMethodException, SecurityException {
        return Functions.inferParameterTypes(Functions.findMethod(clazz, name, argumentTypes), argumentTypes);
    }

    public static List<Class<?>> inferParameterTypes(Method method, List<Class<?>> argumentTypes) {
        return IntStream.range(0, Math.max(method.getParameterCount(), argumentTypes.size())).mapToObj(i -> Functions.inferParameterType(method, argumentTypes, i)).filter(Objects::nonNull).toList();
    }

    public static Class<?> inferParameterType(Method method, List<Class<?>> argumentTypes, int index) {
        try {
            Type parameterType = Functions.getGenericParameterValueType(method, index);
            if (parameterType instanceof TypeVariable) {
                TypeVariable parameterTypeVariable = (TypeVariable)parameterType;
                Class<?> parameterTypeBound = Functions.getCommonTypeBound(parameterTypeVariable);
                if (parameterTypeBound != null) {
                    Class<?> result = null;
                    int i = 0;
                    while (i < argumentTypes.size()) {
                        Type parameterTypeForArgument = Functions.getGenericParameterValueType(method, i);
                        if (parameterTypeForArgument != null && parameterTypeForArgument.equals(parameterType)) {
                            result = Functions.commonSupertype(result, argumentTypes.get(i));
                        }
                        ++i;
                    }
                    if (result != null && parameterTypeBound.isAssignableFrom(result)) {
                        return result;
                    }
                    return parameterTypeBound;
                }
            } else if (parameterType instanceof Class) {
                Class parameterClass = (Class)parameterType;
                return parameterClass;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Functions.getParameterValueType(method, index);
    }

    public static Class<?> inferExpectedParameterType(Method method, Class<?> expectedReturnType, int index) {
        try {
            Type parameterType = Functions.getGenericParameterValueType(method, index);
            if (parameterType instanceof TypeVariable) {
                TypeVariable parameterTypeVariable = (TypeVariable)parameterType;
                Class<?> parameterTypeBound = Functions.getCommonTypeBound(parameterTypeVariable);
                if (parameterTypeBound != null) {
                    Type returnType = method.getGenericReturnType();
                    if (returnType instanceof TypeVariable && parameterType.equals(returnType) && expectedReturnType != null && parameterTypeBound.isAssignableFrom(expectedReturnType)) {
                        return expectedReturnType;
                    }
                    return parameterTypeBound;
                }
            } else if (parameterType instanceof Class) {
                Class parameterClass = (Class)parameterType;
                return parameterClass;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Functions.getParameterValueType(method, index);
    }

    public static Method findMethodFromDataTypes(Class<? extends Functions> clazz, String name, DataType ... argumentTypes) throws NoSuchMethodException, SecurityException {
        return Functions.findMethodFromDataTypes(clazz, name, List.of(argumentTypes));
    }

    public static Method findMethodFromDataTypes(Class<? extends Functions> clazz, String name, List<DataType> argumentTypes) throws NoSuchMethodException, SecurityException {
        return Functions.findMethod(clazz, name, Functions.getValueTypes(argumentTypes));
    }

    public static List<Method> findMethodsFromDataTypes(Class<? extends Functions> clazz, List<DataType> argumentTypes) {
        return Functions.findMethods(clazz, Functions.getValueTypes(argumentTypes));
    }

    public static DataType inferReturnTypeFromDataTypes(Class<? extends Functions> clazz, String name, DataType ... argumentTypes) throws NoSuchMethodException, SecurityException {
        return Functions.inferReturnTypeFromDataTypes(clazz, name, List.of(argumentTypes));
    }

    public static DataType inferReturnTypeFromDataTypes(Class<? extends Functions> clazz, String name, List<DataType> argumentTypes) throws NoSuchMethodException, SecurityException {
        return Functions.inferReturnTypeFromDataTypes(Functions.findMethodFromDataTypes(clazz, name, argumentTypes), null, () -> argumentTypes);
    }

    public static DataType inferReturnTypeFromDataTypes(Method method, Supplier<DataType> expectedReturnTypeSupplier, Supplier<List<DataType>> argumentTypesSupplier) {
        try {
            Type returnType = method.getGenericReturnType();
            if (returnType instanceof TypeVariable) {
                DataType result = null;
                List<DataType> argumentTypes = argumentTypesSupplier.get();
                int i = 0;
                while (i < argumentTypes.size()) {
                    Type parameterTypeForArgument = Functions.getGenericParameterValueType(method, i);
                    if (parameterTypeForArgument != null && parameterTypeForArgument.equals(returnType)) {
                        result = Functions.commonSupertype(result, argumentTypes.get(i));
                    }
                    ++i;
                }
                if (result != null && ValueOperations.dataType(method.getReturnType()).isAssignableFrom(result)) {
                    return result;
                }
            } else if (returnType instanceof Class) {
                Class returnTypeClass = (Class)returnType;
                if (returnType != Void.TYPE) {
                    DataType expectedReturnType;
                    DataType result = ValueOperations.dataType(returnTypeClass);
                    if (IecTypes.GenericTypes.isAnyType((DataType)result) && expectedReturnTypeSupplier != null && (expectedReturnType = expectedReturnTypeSupplier.get()) != null && result.isAssignableFrom(expectedReturnType)) {
                        return expectedReturnType;
                    }
                    return result;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method.getReturnType() != Void.TYPE ? ValueOperations.dataType(method.getReturnType()) : null;
    }

    public static List<DataType> inferParameterTypesFromDataTypes(Class<? extends Functions> clazz, String name, DataType ... argumentTypes) throws NoSuchMethodException, SecurityException {
        return Functions.inferParameterTypesFromDataTypes(clazz, name, List.of(argumentTypes));
    }

    public static List<DataType> inferParameterTypesFromDataTypes(Class<? extends Functions> clazz, String name, List<DataType> argumentTypes) throws NoSuchMethodException, SecurityException {
        return Functions.inferParameterTypesFromDataTypes(Functions.findMethodFromDataTypes(clazz, name, argumentTypes), argumentTypes);
    }

    public static List<DataType> inferParameterTypesFromDataTypes(Method method, List<DataType> argumentTypes) {
        return IntStream.range(0, Math.max(method.getParameterCount(), argumentTypes.size())).mapToObj(i -> Functions.inferParameterTypeFromDataType(method, argumentTypes, i)).filter(Objects::nonNull).toList();
    }

    public static DataType inferParameterTypeFromDataType(Method method, List<DataType> argumentTypes, int index) {
        try {
            Type parameterType = Functions.getGenericParameterValueType(method, index);
            if (parameterType instanceof TypeVariable) {
                TypeVariable parameterTypeVariable = (TypeVariable)parameterType;
                DataType parameterTypeBound = ValueOperations.dataType(Functions.getCommonTypeBound(parameterTypeVariable));
                if (parameterTypeBound != null) {
                    DataType result = null;
                    int i = 0;
                    while (i < argumentTypes.size()) {
                        Type parameterTypeForArgument = Functions.getGenericParameterValueType(method, i);
                        if (parameterTypeForArgument != null && parameterTypeForArgument.equals(parameterType)) {
                            result = Functions.commonSupertype(result, argumentTypes.get(i));
                        }
                        ++i;
                    }
                    if (result != null && parameterTypeBound.isAssignableFrom(result)) {
                        return result;
                    }
                    return parameterTypeBound;
                }
            } else if (parameterType instanceof Class) {
                Class parameterClass = (Class)parameterType;
                return ValueOperations.dataType(parameterClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ValueOperations.dataType(Functions.getParameterValueType(method, index));
    }

    public static DataType inferExpectedParameterTypeFromDataType(Method method, DataType expectedReturnType, List<DataType> argumentTypes, int index) {
        try {
            Type parameterType = Functions.getGenericParameterValueType(method, index);
            if (parameterType instanceof TypeVariable) {
                TypeVariable parameterTypeVariable = (TypeVariable)parameterType;
                DataType parameterTypeBound = ValueOperations.dataType(Functions.getCommonTypeBound(parameterTypeVariable));
                if (parameterTypeBound != null) {
                    Type returnType = method.getGenericReturnType();
                    if (returnType instanceof TypeVariable && parameterType.equals(returnType) && expectedReturnType != null && parameterTypeBound.isAssignableFrom(expectedReturnType)) {
                        return expectedReturnType;
                    }
                    DataType result = null;
                    int i = 0;
                    while (i < argumentTypes.size()) {
                        Type parameterTypeForArgument = Functions.getGenericParameterValueType(method, i);
                        if (parameterTypeForArgument != null && parameterTypeForArgument.equals(parameterType)) {
                            result = Functions.commonSupertype(result, argumentTypes.get(i));
                        }
                        ++i;
                    }
                    if (result != null && parameterTypeBound.isAssignableFrom(result)) {
                        return result;
                    }
                    return parameterTypeBound;
                }
            } else if (parameterType instanceof Class) {
                Class parameterClass = (Class)parameterType;
                return ValueOperations.dataType(parameterClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ValueOperations.dataType(Functions.getParameterValueType(method, index));
    }

    public static Type getGenericParameterValueType(Method method, int index) {
        ParameterizedType parameterizedType;
        Type type = Functions.getGenericParameterType(method, index);
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() == Variable.class) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return type;
    }

    public static Type getGenericParameterType(Method method, int index) {
        if (method.isVarArgs() && index >= method.getParameterCount() - 1) {
            Type varargsType = method.getGenericParameterTypes()[method.getParameterCount() - 1];
            if (varargsType instanceof Class) {
                return ((Class)varargsType).getComponentType();
            }
            if (varargsType instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)varargsType;
                return genericArrayType.getGenericComponentType();
            }
            throw new IllegalStateException("Unsupported varargs type");
        }
        if (index < method.getParameterCount()) {
            return method.getGenericParameterTypes()[index];
        }
        return null;
    }

    public static Class<?> getParameterValueType(Method method, int index) {
        Type parameterType = Functions.getGenericParameterValueType(method, index);
        if (parameterType instanceof TypeVariable) {
            TypeVariable parameterTypeVariable = (TypeVariable)parameterType;
            Class<?> parameterTypeBound = Functions.getCommonTypeBound(parameterTypeVariable);
            if (parameterTypeBound != null) {
                return parameterTypeBound;
            }
        } else if (parameterType instanceof Class) {
            Class parameterClass = (Class)parameterType;
            return parameterClass;
        }
        return Functions.getParameterType(method, index);
    }

    public static Class<?> getParameterType(Method method, int index) {
        if (method.isVarArgs() && index >= method.getParameterCount() - 1) {
            return method.getParameterTypes()[method.getParameterCount() - 1].getComponentType();
        }
        if (index < method.getParameterCount()) {
            return method.getParameterTypes()[index];
        }
        return null;
    }

    public static Parameter getParameter(Method method, int index) {
        if (method.isVarArgs() && index >= method.getParameterCount() - 1) {
            return method.getParameters()[method.getParameterCount() - 1];
        }
        if (index < method.getParameterCount()) {
            return method.getParameters()[index];
        }
        return null;
    }

    private static Class<?> getCommonTypeBound(TypeVariable<?> typeVariable) {
        return Stream.of(typeVariable.getBounds()).filter(Class.class::isInstance).map(Class.class::cast).reduce(Functions::commonSubtype).orElse(null);
    }

    private static boolean isAssignableFrom(List<Class<?>> parameterTypes, List<Class<?>> argumentTypes, boolean varargs) {
        if (Functions.isAssignableFrom(parameterTypes, argumentTypes)) {
            return true;
        }
        if (!varargs || parameterTypes.isEmpty()) {
            return false;
        }
        if (argumentTypes.size() < parameterTypes.size() - 1) {
            return false;
        }
        int i = parameterTypes.size() - 2;
        while (i >= 0) {
            if (!Functions.isAssignableFrom(parameterTypes.get(i), argumentTypes.get(i))) {
                return false;
            }
            --i;
        }
        Class<?> varargsType = parameterTypes.get(parameterTypes.size() - 1);
        Class<?> varargsComponentType = varargsType.getComponentType();
        int i2 = argumentTypes.size() - 1;
        while (i2 >= parameterTypes.size() - 1) {
            if (!Functions.isAssignableFrom(varargsComponentType, argumentTypes.get(i2))) {
                return false;
            }
            --i2;
        }
        return true;
    }

    private static boolean isAssignableFrom(List<Class<?>> parameterTypes, List<Class<?>> argumentTypes) {
        if (argumentTypes.size() != parameterTypes.size()) {
            return false;
        }
        int i = parameterTypes.size() - 1;
        while (i >= 0) {
            if (!Functions.isAssignableFrom(parameterTypes.get(i), argumentTypes.get(i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    private static boolean isAssignableFrom(Class<?> parameterType, Class<?> argumentType) {
        if (parameterType.isAssignableFrom(argumentType) || Variable.class.isAssignableFrom(parameterType)) {
            return true;
        }
        DataType type1 = ValueOperations.dataType(parameterType);
        DataType type2 = ValueOperations.dataType(argumentType);
        return type1 != null && type2 != null && type1.isAssignableFrom(type2);
    }

    private static Class<?> commonSupertype(Class<?> clazz1, Class<?> clazz2) {
        if (clazz1 == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz1;
        }
        if (clazz1.isAssignableFrom(clazz2)) {
            return clazz1;
        }
        if (clazz2.isAssignableFrom(clazz1)) {
            return clazz2;
        }
        DataType type1 = ValueOperations.dataType(clazz1);
        DataType type2 = ValueOperations.dataType(clazz2);
        return ValueOperations.valueType((INamedElement)Functions.commonSupertype(type1, type2));
    }

    private static DataType commonSupertype(DataType type1, DataType type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1.isAssignableFrom(type2)) {
            return type1;
        }
        if (type2.isAssignableFrom(type1)) {
            return type2;
        }
        return null;
    }

    private static Class<?> commonSubtype(Class<?> clazz1, Class<?> clazz2) {
        if (clazz1 == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz1;
        }
        if (clazz1.isAssignableFrom(clazz2)) {
            return clazz2;
        }
        if (clazz2.isAssignableFrom(clazz1)) {
            return clazz1;
        }
        DataType type1 = ValueOperations.dataType(clazz1);
        DataType type2 = ValueOperations.dataType(clazz2);
        return ValueOperations.valueType((INamedElement)Functions.commonSubtype(type1, type2));
    }

    private static DataType commonSubtype(DataType type1, DataType type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1.isAssignableFrom(type2)) {
            return type2;
        }
        if (type2.isAssignableFrom(type1)) {
            return type1;
        }
        return null;
    }

    private static List<Class<?>> getValueTypes(List<DataType> argumentTypes) {
        return argumentTypes.stream().map(ValueOperations::valueType).map(c -> Objects.requireNonNullElse(c, Object.class)).toList();
    }
}

