/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.polyomino;

import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.common.polyomino.structures.Direction;
import org.eclipse.elk.alg.common.polyomino.structures.Polyomino;
import org.eclipse.elk.alg.common.utils.UniqueTriple;
import org.eclipse.elk.core.util.Pair;

public class SuccessorQuadrantsGeneric
implements BiFunction<Pair<Integer, Integer>, Polyomino, Pair<Integer, Integer>> {
    private Polyomino lastPoly;
    private boolean posX;
    private boolean posY;
    private boolean negX;
    private boolean negY;
    private BiFunction<Pair<Integer, Integer>, Polyomino, Pair<Integer, Integer>> costFun;

    public SuccessorQuadrantsGeneric(BiFunction<Pair<Integer, Integer>, Polyomino, Pair<Integer, Integer>> costFun) {
        this.costFun = costFun;
    }

    @Override
    public Pair<Integer, Integer> apply(Pair<Integer, Integer> coords, Polyomino poly) {
        if (!poly.equals(this.lastPoly)) {
            this.lastPoly = poly;
            Function<UniqueTriple, Direction> detectDirections = polyExt -> (Direction)((Object)((Object)polyExt.getFirst()));
            Set dirSet = poly.getPolyominoExtensions().parallelStream().map(detectDirections).collect(Collectors.toSet());
            this.posX = true;
            this.posY = true;
            this.negX = true;
            this.negY = true;
            boolean containsPos = dirSet.contains((Object)Direction.NORTH);
            boolean containsNeg = dirSet.contains((Object)Direction.SOUTH);
            if (containsPos && !containsNeg) {
                this.posY = false;
            }
            if (!containsPos && containsNeg) {
                this.negY = false;
            }
            containsPos = dirSet.contains((Object)Direction.EAST);
            containsNeg = dirSet.contains((Object)Direction.WEST);
            if (containsPos && !containsNeg) {
                this.negX = false;
            }
            if (!containsPos && containsNeg) {
                this.posX = false;
            }
        }
        Pair<Integer, Integer> nextCoords = this.costFun.apply(coords, poly);
        int newX = (Integer)nextCoords.getFirst();
        int newY = (Integer)nextCoords.getSecond();
        boolean invalid = false;
        if (newX < 0) {
            if (!this.negX) {
                invalid = true;
            }
        } else if (!this.posX) {
            invalid = true;
        }
        if (newY < 0) {
            if (!this.negY) {
                invalid = true;
            }
        } else if (!this.posY) {
            invalid = true;
        }
        if (invalid) {
            return this.apply(nextCoords, poly);
        }
        return nextCoords;
    }
}

