/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editparts;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.gef.policies.AbstractViewRenameEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceDiagramEditor;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceEditorInput;
import org.eclipse.fordiac.ide.systemconfiguration.Activator;
import org.eclipse.fordiac.ide.systemconfiguration.policies.DeleteResourceEditPolicy;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ResourceEditPart
extends AbstractViewEditPart {
    private ResourceFigure figure;

    protected void refreshVisuals() {
    }

    public void refreshName() {
        this.getNameLabel().setText(this.getINamedElement().getName());
    }

    protected IFigure createFigureForModel() {
        if (this.figure == null) {
            this.figure = new ResourceFigure();
        }
        return this.figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteResourceEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new AbstractViewRenameEditPolicy());
    }

    public boolean understandsRequest(Request req) {
        if (this.getModel().isDeviceTypeResource()) {
            return false;
        }
        return super.understandsRequest(req);
    }

    public Resource getModel() {
        return (Resource)super.getModel();
    }

    protected EContentAdapter createContentAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                ResourceEditPart.this.refresh();
                super.notifyChanged(notification);
            }
        };
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    public Label getNameLabel() {
        return ((ResourceFigure)this.getFigure()).getInstanceName();
    }

    public IPropertyChangeListener getPreferenceChangeListener() {
        return null;
    }

    protected void backgroundColorChanged(IFigure figure) {
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            ResourceEditorInput input = new ResourceEditorInput(this.getModel());
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                activePage.openEditor((IEditorInput)input, ResourceDiagramEditor.class.getName());
            }
            catch (PartInitException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            }
        } else {
            super.performRequest(request);
        }
    }

    public class ResourceFigure
    extends Figure {
        private final Label instanceName;
        private final Label typeInfo;

        public ResourceFigure() {
            GridLayout mainLayout = new GridLayout(2, false);
            mainLayout.marginHeight = 2;
            this.setLayoutManager((LayoutManager)mainLayout);
            this.instanceName = ResourceEditPart.this.getINamedElement() == null ? new Label("N/D") : new Label(ResourceEditPart.this.getINamedElement().getName());
            if (ResourceEditPart.this.getModel().isDeviceTypeResource()) {
                this.instanceName.setIcon(FordiacImage.ICON_FirmwareResource.getImage());
            }
            this.add((IFigure)this.instanceName);
            String type = "N/D";
            if (ResourceEditPart.this.getModel() != null) {
                type = ResourceEditPart.this.getModel().getTypeName();
            }
            this.typeInfo = new Label("(" + type + ")");
            this.typeInfo.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
            this.add((IFigure)this.typeInfo);
            this.setOpaque(false);
        }

        public Label getInstanceName() {
            return this.instanceName;
        }
    }
}

