/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.resourceediting.editors;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceDiagramEditorContextMenuProvider;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceEditorInput;
import org.eclipse.fordiac.ide.resourceediting.editparts.ResourceDiagramEditPartFactory;
import org.eclipse.fordiac.ide.util.ColorManager;
import org.eclipse.fordiac.ide.util.PersistableUntypedEditorInput;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorInput;

public class ResourceDiagramEditor
extends FBNetworkEditor {
    private EContentAdapter resourceAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature) && ResourceDiagramEditor.this.getResource().equals(notification.getNotifier())) {
                ResourceDiagramEditor.this.setPartName(ResourceEditorInput.getResourceEditorName(ResourceDiagramEditor.this.getResource()));
            }
            super.notifyChanged(notification);
        }
    };
    private EContentAdapter colorChangeListener = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getColorizableElement_Color()) {
                ResourceDiagramEditor.this.updateGridColor();
            }
        }
    };

    private Resource getResource() {
        return (Resource)this.getModel().eContainer();
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.updateGridColor();
    }

    protected EditPartFactory getEditPartFactory() {
        return new ResourceDiagramEditPartFactory(this, this.getZoomManger());
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new ResourceDiagramEditorContextMenuProvider(this, this.getActionRegistry(), zoomManager, this.getPalette());
    }

    protected void setModel(IEditorInput input) {
        PersistableUntypedEditorInput untypedInput;
        Object content;
        if (input instanceof PersistableUntypedEditorInput && (content = (untypedInput = (PersistableUntypedEditorInput)input).getContent()) instanceof Resource) {
            this.setModel(((Resource)content).getFBNetwork());
            this.getResource().eAdapters().add((Object)this.resourceAdapter);
            this.getResource().getDevice().eAdapters().add((Object)this.colorChangeListener);
            if (input.getName() != null) {
                this.setPartName(input.getName());
            }
        }
        super.setModel(input);
    }

    public void dispose() {
        if (this.getResource() != null) {
            this.getResource().eAdapters().remove((Object)this.resourceAdapter);
            this.getResource().getDevice().eAdapters().remove((Object)this.colorChangeListener);
        }
        super.dispose();
    }

    private void updateGridColor() {
        Color devColor;
        IFigure layer;
        if (this.getResource() != null && (layer = ((ZoomScalableFreeformRootEditPart)this.getViewer().getRootEditPart()).getLayer((Object)"Grid Layer")) != null && (devColor = this.getResource().getDevice().getColor()) != null) {
            org.eclipse.swt.graphics.Color newColor = ColorManager.getColor((RGB)new RGB(devColor.getRed(), devColor.getGreen(), devColor.getBlue()));
            layer.setForegroundColor(newColor);
        }
    }
}

