/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.ui.controls.Abstract4DIACUIPlugin;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IEditorPart;

public class ChangeValueCommand
extends Command {
    private static final String CHANGE = Messages.ChangeValueCommand_LABEL_ChangeValue;
    private VarDeclaration var;
    private VarDeclaration mirroredVar;
    private String newValue;
    private String oldValue;
    private IEditorPart editor;

    public ChangeValueCommand(VarDeclaration var, String value) {
        this.var = var;
        this.newValue = value;
    }

    public boolean canExecute() {
        if (this.var != null && this.var.getType() != null && this.var.getType().equals(DataTypeLibrary.getInstance().getType("ANY")) && this.newValue != null && !this.newValue.equals("") && !this.newValue.contains("#")) {
            Abstract4DIACUIPlugin.statusLineErrorMessage((String)"Constant Values are not allowed on ANY Input!");
            return false;
        }
        return super.canExecute();
    }

    public boolean canUndo() {
        return this.editor.equals(Abstract4DIACUIPlugin.getCurrentActiveEditor());
    }

    public ChangeValueCommand() {
        super(CHANGE);
    }

    public void execute() {
        this.editor = Abstract4DIACUIPlugin.getCurrentActiveEditor();
        this.mirroredVar = this.getMirroredVariable();
        if (this.var.getValue() == null) {
            this.var.setValue(LibraryElementFactory.eINSTANCE.createValue());
            if (this.mirroredVar != null) {
                this.mirroredVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
            }
            this.oldValue = "";
        } else {
            String string = this.oldValue = this.var.getValue().getValue() != null ? this.var.getValue().getValue() : "";
        }
        if ("".equals(this.newValue)) {
            this.newValue = null;
        }
        this.var.getValue().setValue(this.newValue);
        this.setMirroredVar(this.newValue);
    }

    public void undo() {
        this.var.getValue().setValue(this.oldValue);
        this.setMirroredVar(this.oldValue);
    }

    public void redo() {
        this.var.getValue().setValue(this.newValue);
        this.setMirroredVar(this.newValue);
    }

    private VarDeclaration getMirroredVariable() {
        IInterfaceElement element;
        FBNetworkElement opposite;
        if (this.var.getFBNetworkElement() != null && this.var.getFBNetworkElement().isMapped() && (opposite = this.var.getFBNetworkElement().getOpposite()) != null && (element = opposite.getInterfaceElement(this.var.getName())) instanceof VarDeclaration) {
            return (VarDeclaration)element;
        }
        return null;
    }

    private void setMirroredVar(String val) {
        if (this.mirroredVar != null) {
            this.mirroredVar.getValue().setValue(val);
        }
    }
}

