/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class ConnectionSection
extends AbstractSection {
    private Text commentText;
    private Text sourceText;
    private Text targetText;

    protected Connection getType() {
        return (Connection)this.type;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, Messages.ConnectionSection_Source);
        this.sourceText = this.createGroupText(composite, false);
        this.getWidgetFactory().createCLabel(composite, Messages.ConnectionSection_Target);
        this.targetText = this.createGroupText(composite, false);
        this.getWidgetFactory().createCLabel(composite, Messages.ConnectionSection_Comment);
        this.commentText = this.createGroupText(composite, true);
        this.commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionSection.this.removeContentAdapter();
                ConnectionSection.this.executeCommand((Command)new ChangeCommentCommand((INamedElement)ConnectionSection.this.getType(), ConnectionSection.this.commentText.getText()));
                ConnectionSection.this.addContentAdapter();
            }
        });
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            if (this.getType().getSource() != null) {
                this.sourceText.setText(String.valueOf(this.getFBNameFromIInterfaceElement(this.getType().getSource())) + "." + this.getType().getSource().getName());
            }
            if (this.getType().getDestination() != null) {
                this.targetText.setText(String.valueOf(this.getFBNameFromIInterfaceElement(this.getType().getDestination())) + "." + this.getType().getDestination().getName());
            }
        }
        this.commandStack = commandStackBuffer;
    }

    private String getFBNameFromIInterfaceElement(IInterfaceElement element) {
        return element.eContainer().eContainer() instanceof FBNetworkElement ? ((FBNetworkElement)element.eContainer().eContainer()).getName() : "";
    }
}

