/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.draw2d;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.util.ColorHelper;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class AdvancedRoundedRectangle
extends RoundedRectangle {
    protected int side = 0;
    private ZoomManager zoomManager;
    private Figure parent;
    private boolean useGradient = false;
    private Color color;

    public AdvancedRoundedRectangle(int side) {
        this.side = side;
    }

    public AdvancedRoundedRectangle(int side, ZoomManager zoomManager, Figure parent, boolean useGradient, Color color) {
        this.side = side;
        this.zoomManager = zoomManager;
        this.parent = parent;
        this.useGradient = useGradient;
        this.color = color;
    }

    public void setSide(int side) {
        this.side = side;
    }

    protected void fillShape(Graphics graphics) {
        if (this.useGradient) {
            this.setPattern(graphics, true);
        } else {
            super.fillShape(graphics);
        }
    }

    private void setPattern(Graphics graphics, boolean background) {
        Display display = Display.getCurrent();
        Rectangle boundingRect = this.parent != null ? this.parent.getBounds().getCopy() : this.getBounds().getCopy();
        if (this.zoomManager != null) {
            boundingRect.scale(this.zoomManager.getZoom());
        }
        Point topLeft = boundingRect.getTopLeft();
        Point bottomRight = boundingRect.getBottomRight();
        Color first = ColorHelper.lighter((Color)this.getBackgroundColor());
        Pattern pattern = new Pattern((Device)display, (float)topLeft.x, (float)topLeft.y, (float)bottomRight.x, (float)bottomRight.y, first, this.getBackgroundColor());
        if (background) {
            graphics.setBackgroundPattern(pattern);
        } else {
            graphics.setForegroundPattern(pattern);
        }
        graphics.fillRoundRectangle(this.getBounds(), this.getCornerDimensions().width, this.getCornerDimensions().height);
        graphics.setBackgroundPattern(null);
        pattern.dispose();
        first.dispose();
    }

    protected void outlineShape(Graphics graphics) {
        if (this.color != null) {
            graphics.setForegroundColor(this.color);
        }
        float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
        int inset1 = (int)Math.floor(lineInset);
        int inset2 = (int)Math.ceil(lineInset);
        Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
        r.x += inset1;
        r.y += inset1;
        r.width -= inset1 + inset2;
        r.height -= inset1 + inset2;
        int x = r.x;
        int y = r.y;
        int width = r.width;
        int height = r.height;
        int arcWidth = Math.max(0, this.getCornerDimensions().width - (int)lineInset);
        int arcHeight = Math.max(0, this.getCornerDimensions().height - (int)lineInset);
        if (width == 0 || height == 0) {
            return;
        }
        if (arcWidth == 0 || arcHeight == 0) {
            if ((this.side & 1) != 0) {
                graphics.drawLine(r.x, r.y, r.x + r.width, r.y);
            }
            if ((this.side & 0x10) != 0) {
                graphics.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + r.height);
            }
            if ((this.side & 4) != 0) {
                graphics.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
            }
            if ((this.side & 8) != 0) {
                graphics.drawLine(r.x, r.y, r.x, r.y + r.height);
            }
            return;
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (arcWidth < 0) {
            arcWidth = -arcWidth;
        }
        if (arcHeight < 0) {
            arcHeight = -arcHeight;
        }
        if (arcWidth > width) {
            arcWidth = width;
        }
        if (arcHeight > height) {
            arcHeight = height;
        }
        if (arcWidth < width) {
            if ((this.side & 1) != 0) {
                graphics.drawLine(x + arcWidth / 2, y, x + width - arcWidth / 2, y);
            }
            if ((this.side & 4) != 0) {
                graphics.drawLine(x + arcWidth / 2, y + height, x + width - arcWidth / 2, y + height);
            }
        }
        if (arcHeight < height) {
            if ((this.side & 8) != 0) {
                graphics.drawLine(x, y + arcHeight / 2, x, y + height - arcHeight / 2);
            }
            if ((this.side & 0x10) != 0) {
                graphics.drawLine(x + width, y + arcHeight / 2, x + width, y + height - arcHeight / 2);
            }
        }
        if (arcWidth != 0 && arcHeight != 0 && this.side != 0) {
            graphics.drawArc(x, y, arcWidth, arcHeight, 90, 90);
            graphics.drawArc(x + width - arcWidth, y, arcWidth, arcHeight, 0, 90);
            graphics.drawArc(x + width - arcWidth, y + height - arcHeight, arcWidth, arcHeight, 0, -90);
            graphics.drawArc(x, y + height - arcHeight, arcWidth, arcHeight, 180, 90);
        }
    }
}

