# frozen_string_literal: true

class PrepareAsyncIndexesForVulnerabilityOccurrencePipelinesPipelineToBigint < Gitlab::Database::Migration[2.2]
  milestone '17.0'

  TABLE_NAME = :vulnerability_occurrence_pipelines
  INDEX_NAME = :index_vulnerability_occurrence_pipelines_on_pipeline_id_bigint
  COLUMN_NAME = :pipeline_id_convert_to_bigint
  COMPOSITE_INDEX_NAME = :vulnerability_occurrence_pipelines_on_unique_keys_bigint
  COMPOSITE_INDEX_COLUMNS = [:occurrence_id, :pipeline_id_convert_to_bigint]

  def up
    prepare_async_index TABLE_NAME, COLUMN_NAME, name: INDEX_NAME
    prepare_async_index TABLE_NAME, COMPOSITE_INDEX_COLUMNS, unique: true, name: COMPOSITE_INDEX_NAME
  end

  def down
    unprepare_async_index TABLE_NAME, COLUMN_NAME, name: INDEX_NAME
    unprepare_async_index TABLE_NAME, COMPOSITE_INDEX_COLUMNS, unique: true, name: COMPOSITE_INDEX_NAME
  end
end
