---
stage: Create
group: Editor Extensions
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# GitLab extension for Visual Studio

The [GitLab extension](https://marketplace.visualstudio.com/items?itemName=GitLab.GitLabExtensionForVisualStudio)
integrates GitLab with Visual Studio. The following Visual Studio versions are supported:

- Visual Studio 2022 (AMD64)
- Visual Studio 2022 (Arm64)

## Supported features

GitLab for Visual Studio supports [GitLab Duo Code Suggestions](../../user/project/repository/code_suggestions/index.md).

## Download the extension

Download the extension from the [Visual Studio Marketplace](https://marketplace.visualstudio.com/items?itemName=GitLab.GitLabExtensionForVisualStudio).

## Configure the extension

Instructions for getting started can be found in the project README under [setup](https://gitlab.com/gitlab-org/editor-extensions/gitlab-visual-studio-extension/#setup).

## Report issues with the extension

Report any issues, bugs, or feature requests in the
[`gitlab-visual-studio-extension` issue queue](https://gitlab.com/gitlab-org/editor-extensions/gitlab-visual-studio-extension/-/issues).

## Related topics

- [Download the plugin](https://marketplace.visualstudio.com/items?itemName=GitLab.GitLabExtensionForVisualStudio)
- [Plugin documentation](https://gitlab.com/gitlab-org/editor-extensions/gitlab-visual-studio-extension/-/blob/main/README.md)
- [View source code](https://gitlab.com/gitlab-org/editor-extensions/gitlab-visual-studio-extension)

## Troubleshooting

For troubleshooting information, see the
[extension's troubleshooting page](https://gitlab.com/gitlab-org/editor-extensions/gitlab-visual-studio-extension/-/blob/main/docs/user/troubleshooting.md).
