<!--
Triage of infradev Issues is desired to occur asynchronously.
For maximum efficiency, please ensure the following, so that your infradev issues can gain maximum traction.

https://about.gitlab.com/handbook/engineering/workflow/#a-guide-to-creating-effective-infradev-issues
-->

## Summary
<!--
Clearly state the scope of the problem, and how it affects GitLab.com
-->


## Impact
<!--
- Quantify the effect of the problem to help ensure that correct prioritization occurs.
- Include costs to availability. The Incident Budget Explorer dashboard can help here.
- Include the number of times alerts have fired owing to the problem, how much time was spent dealing with the problem, and how many people were involved.
- Link to affected incidents, and cross-reference them as related issues.
- Include screenshots of visualization from Grafana or Kibana.
- Always include a permalink to the source of the screenshot so that others can investigate further.
-->


## Recommendation
<!--
Provide a clear, unambiguous, self-contained solution to the problem.
-->


## Verification
<!--
Provide a method for validating that the original issue still exists.

Having a way of checking validity can save on a great deal of back-and-forth discussion between Infradev Triage participants including Engineering Managers, Directors and Product Managers and make space for other non-resolved issues to get scheduled sooner.

Ideally, provide a link to a Thanos query or an ELK query and clear instructions on how to interpret the results to determine whether the problem is still occurring.
-->


<!--
Workflow and other relevant labels

/label ~"severity::"
/label ~"priority::"
/label ~"group::"
/label ~"devops::"

See also:
- https://about.gitlab.com/handbook/engineering/quality/issue-triage/#availability
- https://about.gitlab.com/handbook/product/categories/
- https://gitlab.com/gitlab-com/www-gitlab-com/blob/master/data/stages.yml
-->

/label ~"infradev"
/label ~"type::bug"
