# frozen_string_literal: true

class CreateIndexForVulnerabilityReadsOnCommonProjectFilters < Gitlab::Database::Migration[2.1]
  disable_ddl_transaction!

  INDEX_NAME = 'index_project_vulnerability_reads_common_finder_query_desc'

  def up
    add_concurrent_index :vulnerability_reads,
      [:project_id, :state, :report_type, :severity, :vulnerability_id],
      order: { severity: :desc, vulnerability_id: :desc },
      name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end
end
