#include <stdio.h>
#include <stdlib.h>
#include <ustr.h>
#include "lib/confdata.h"
#include "lib/env.h"
#include "lib/util.h"

int test1 (void)
{
  int rc = 1;
  run2_env_spec_t * envspec;
  run2_env_t * env;
#if defined (_WIN32) && !defined(__CYGWIN__)
  const char * expected_PATH = "/c/e;/c/d;/c/c;/c/b;/c/a;/c/WINDOWS/system32;/c/f;.";
#else
  const char * expected_PATH = "/c/e:/c/d:/c/c:/c/b:/c/a:/c/WINDOWS/system32:/c/f:.";
#endif
  const char * expected_SHELL = "/c/MinGW/bin/sh.exe";
  const char * expected_ACCUM = "edcba_MIDDLE_uvxyz";

  const char * result_PATH = NULL;
  const char * result_SHELL = NULL;
  const char * result_ACCUM = NULL;

  env = run2_env_create ();
  envspec = run2_env_get_var (env, USTR1 (\4, "PATH"));
  run2_env_spec_set (envspec, USTR1 (\x13, "/c/WINDOWS/system32"));
  run2_env_spec_prepend (envspec, USTR1 (\4, "/c/a"));
  run2_env_spec_prepend (envspec, USTR1 (\4, "/c/b"));
  run2_env_spec_prepend (envspec, USTR1 (\4, "/c/c"));
  run2_env_spec_prepend (envspec, USTR1 (\4, "/c/d"));
  run2_env_spec_prepend (envspec, USTR1 (\4, "/c/e"));
  run2_env_spec_append (envspec, USTR1 (\4, "/c/f"));
  envspec = run2_env_get_var (env, USTR1 (\5, "SHELL"));
  run2_env_spec_set (envspec, USTR1 (\x13, "/c/MinGW/bin/sh.exe"));
  envspec = run2_env_get_var (env, USTR1 (\4, "PATH"));
  run2_env_spec_append  (envspec, USTR1 (\1, "."));
  envspec = run2_env_get_var (env, USTR1 (\5, "ACCUM"));
  run2_env_spec_set (envspec, USTR1 (\6, "MIDDLE"));
  run2_env_spec_prepend (envspec, USTR1 (\2, "a_"));
  run2_env_spec_prepend (envspec, USTR1 (\1, "b"));
  run2_env_spec_prepend (envspec, USTR1 (\1, "c"));
  run2_env_spec_prepend (envspec, USTR1 (\1, "d"));
  run2_env_spec_prepend (envspec, USTR1 (\1, "e"));
  run2_env_spec_append (envspec, USTR1 (\2, "_u"));
  run2_env_spec_append (envspec, USTR1 (\1, "v"));
  run2_env_spec_append (envspec, USTR1 (\1, "x"));
  run2_env_spec_append (envspec, USTR1 (\1, "y"));
  run2_env_spec_append (envspec, USTR1 (\1, "z"));
  run2_env_print  (stdout, 0, USTR1 (\5, "test1"), env);

  run2_apply_env (env);
  rc = 0;

  result_PATH = getenv ("PATH");
  result_SHELL = getenv ("SHELL");
  result_ACCUM = getenv ("ACCUM");
  rc = 0;

  if (strcmp(result_PATH, expected_PATH) != 0)
    {
      errorMsg ("FAILED test 1a:\n\texpected: PATH=%s\n\tresult  : PATH=%s",
                expected_PATH, result_PATH);
      rc++;
    }
  if (strcmp(result_SHELL, expected_SHELL) != 0)
    {
      errorMsg ("FAILED test 1b:\n\texpected: SHELL=%s\n\tresult  : SHELL=%s",
                expected_SHELL, result_SHELL);
      rc++;
    }
  if (strcmp(result_ACCUM, expected_ACCUM) != 0)
    {
      errorMsg ("FAILED test 1c:\n\texpected: ACCUM=%s\n\tresult  : ACCUM=%s",
                expected_ACCUM, result_ACCUM);
      rc++;
    }

  run2_env_delete (env);
  return rc;
}

int main (int argc, char * argv[])
{
  int rc = 0;
  run2_set_program_name (argv[0]);
  run2_set_verbose_level (RUN2_DEFAULT_LOG_LEVEL);
  rc += test1 ();
  return rc;
}

