/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of Gnu.xs. Do not edit this file, edit Gnu.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "Gnu.xs"
/*
 *      Gnu.xs --- GNU Readline wrapper module
 *
 *      Copyright (c) 1996-2025 Hiroo Hayashi.  All rights reserved.
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the same terms as Perl itself.
 */

#ifdef __cplusplus
extern "C" {
#endif
#define PERLIO_NOT_STDIO 0
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"
#ifdef __cplusplus
}
#endif

#include <stdio.h>
#ifdef __CYGWIN__
#include <sys/termios.h>
#endif /* __CYGWIN__ */
#if (RL_READLINE_VERSION < 0x0803)
#define HAVE_STDARG_H 1 /* to declare rl_message() correctly */
#endif
#include <readline/readline.h>
#include <readline/history.h>

/*
 * In Readline 4.2 many variables, function arguments, and function
 * return values are now declared `const' where appropriate.
 */
#if (RL_READLINE_VERSION < 0x0402)
#define CONST
#else  /* (RL_READLINE_VERSION >= 0x0402) */
#define CONST const
#endif /* (RL_READLINE_VERSION >= 0x0402) */

/* from GNU Readline:xmalloc.h */
#ifndef PTR_T
#ifdef __STDC__
#  define PTR_T void *
#else
#  define PTR_T char *
#endif
#endif /* !PTR_T */

/* from GNU Readline:xmalloc.h */
extern PTR_T xmalloc (size_t);
extern PTR_T xrealloc (PTR_T, size_t);
extern void xfree (PTR_T);

extern char *tgetstr (const char *, char **);
extern int tputs (const char *, int, int (*)(int));

typedef char *  t_utf8;                 /* string which must not be xfreed */
typedef char *  t_utf8_free;            /* string which must be xfreed */

/*
 * utf8_mode is set in the Perl side, and it must be set before
 * calling sv_2mortal_utf8()
 */
static int utf8_mode = 0;
static SV*
sv_2mortal_utf8(SV *sv)
{
  sv = sv_2mortal(sv);
  if (utf8_mode)
    sv_utf8_decode(sv);
  return sv;
}

/*
 * compatibility definitions
 */
#if (RL_READLINE_VERSION < 0x0402)
typedef int rl_command_func_t (int, int);
typedef char *rl_compentry_func_t (const char *, int);
typedef char **rl_completion_func_t (const char *, int, int);
typedef char *rl_quote_func_t (char *, int, char *);
typedef char *rl_dequote_func_t (char *, int);
typedef int rl_compignore_func_t (char **);
typedef void rl_compdisp_func_t (char **, int, int);
typedef int rl_hook_func_t (void);
typedef int rl_getc_func_t (FILE *);
typedef int rl_linebuf_func_t (char *, int);

/* `Generic' function pointer typedefs */
typedef int rl_intfunc_t (int);
#define rl_ivoidfunc_t rl_hook_func_t
typedef int rl_icpfunc_t (char *);
typedef int rl_icppfunc_t (char **);

typedef void rl_voidfunc_t (void);
typedef void rl_vintfunc_t (int);
typedef void rl_vcpfunc_t (char *);
typedef void rl_vcppfunc_t (char **);

/* rl_last_func() is defined in rlprivate.h */
extern rl_command_func_t *rl_last_func;
#endif /* (RL_READLINE_VERSION < 0x0402) */

#if (RL_READLINE_VERSION < 0x0500)
typedef char *rl_cpvfunc_t (void);
#endif /* (RL_READLINE_VERSION < 0x0500) */


#if (RL_READLINE_VERSION < 0x0201)
/* features introduced by GNU Readline 2.1 */
static rl_vintfunc_t *rl_prep_term_function;
static rl_voidfunc_t *rl_deprep_term_function;
#endif /* (RL_READLINE_VERSION < 0x0201) */

#if (RL_READLINE_VERSION < 0x0202)
/* features introduced by GNU Readline 2.2 */
static int
rl_unbind_function_in_map (rl_command_func_t *func, Keymap map)
{
  register int i, rval;

  for (i = rval = 0; i < KEYMAP_SIZE; i++)
    {
      if (map[i].type == ISFUNC && map[i].function == func)
        {
          map[i].function = (rl_command_func_t *)NULL;
          rval = 1;
        }
    }
  return rval;
}

static int
rl_unbind_command_in_map (const char *command, Keymap map)
{
  rl_command_func_t *func;

  func = rl_named_function (command);
  if (func == 0)
    return 0;
  return (rl_unbind_function_in_map (func, map));
}
#endif /* (RL_READLINE_VERSION < 0x0202) */

#if (RL_VERSION_MAJOR < 4)
/* documented by Readline 4.0 but already implemented since 2.0 or 2.1. */
extern void rl_extend_line_buffer (int);
extern char **rl_funmap_names (void);
extern int rl_add_funmap_entry (CONST char *, rl_command_func_t *);
extern void rl_prep_terminal (int);
extern void rl_deprep_terminal (void);
extern int rl_execute_next (int);

/* features introduced by GNU Readline 4.0 */
/* dummy variable/function definition */
static int rl_erase_empty_line = 0;
static rl_hook_func_t *rl_pre_input_hook;
static int rl_catch_signals = 1;
static int rl_catch_sigwinch = 1;
static rl_compdisp_func_t *rl_completion_display_matches_hook;

static void rl_display_match_list(){}
static void rl_cleanup_after_signal(){}
static void rl_free_line_state(){}
static void rl_reset_after_signal(){}
static void rl_resize_terminal(){}

/*
 * Before GNU Readline Library Version 4.0, rl_save_prompt() was
 * _rl_save_prompt and rl_restore_prompt() was _rl_restore_prompt().
 */
extern void _rl_save_prompt (void);
extern void _rl_restore_prompt (void);
static void rl_save_prompt() { _rl_save_prompt(); }
static void rl_restore_prompt() { _rl_restore_prompt(); }
#endif /* (RL_VERSION_MAJOR < 4) */

#if (RL_READLINE_VERSION < 0x0401)
/* features introduced by GNU Readline 4.1 */
static int rl_already_prompted = 0;
static int rl_num_chars_to_read = 0;
static int rl_gnu_readline_p = 1;
static int rl_on_new_line_with_prompt(){ return 0; }
#endif /* (RL_READLINE_VERSION < 0x0401) */

#if (RL_READLINE_VERSION < 0x0402)
/* documented by 4.2 but implemented since 2.1 */
extern int rl_explicit_arg;
extern int rl_numeric_arg;
extern int rl_editing_mode;

/* features introduced by GNU Readline 4.2 */
static int rl_set_prompt(){ return 0; }
static int rl_clear_pending_input(){ return 0; }
static int rl_set_keyboard_input_timeout(){ return 0; }
static int rl_alphabetic(){ return 0; }
static int rl_set_paren_blink_timeout(){ return 0; }
static void rl_set_screen_size(int row, int col){}
static void rl_get_screen_size(int *row, int *col){
  *row = *col = 0;
}

static char *rl_executing_macro = NULL; /* was _rl_executing_macro */
static int rl_readline_state = 2; /* RL_STATE_INITIALIZED */
static rl_icppfunc_t *rl_directory_rewrite_hook = NULL;
static char *history_word_delimiters = " \t\n;&()|<>";

/* documented by 4.2a but implemented since 2.1 */
extern char *rl_get_termcap (const char *);

/* features introduced by GNU Readline 4.2a */
static int rl_readline_version = RL_READLINE_VERSION;

/* Provide backwards-compatible entry points for old function names
   which are rename from readline-4.2. */
static void
rl_free_undo_list ()
{
  free_undo_list ();
}

static int
rl_crlf ()
{
  return crlf ();
}

static void
rl_tty_set_default_bindings (Keymap keymap)
{
#if (RL_VERSION_MAJOR >= 4)
  rltty_set_default_bindings (keymap);
#endif /* (RL_VERSION_MAJOR >= 4) */
}

static int
rl_ding ()
{
  return ding ();
}

static char **
rl_completion_matches (char *s, rl_compentry_func_t *f)
{
  return completion_matches (s, f);
}

static char *
rl_username_completion_function (const char *s, int i)
{
  return username_completion_function ((char *)s, i);
}

static char *
rl_filename_completion_function (const char *s, int i)
{
  return filename_completion_function ((char *)s, i);
}
#endif /* (RL_READLINE_VERSION >= 0x0402) */

#if (RL_READLINE_VERSION < 0x0403)
/* features introduced by GNU Readline 4.3 */
static int rl_completion_suppress_append = 0;
static int rl_completion_mark_symlink_dirs = 0;
static void rl_replace_line(){}
static int rl_completion_mode(){ return 0; }

/* documented by 6.0 but implemented since 4.3 */
struct readline_state { };
static int rl_save_state(struct readline_state *sp){ return 0; }
static int rl_restore_state(struct readline_state *sp){ return 0; }
#endif /* (RL_READLINE_VERSION < 0x0403) */

typedef struct readline_state readline_state_t; /* for typemap */

#if (RL_VERSION_MAJOR < 5)
/* features introduced by GNU Readline 5.0 */
static rl_cpvfunc_t *rl_completion_word_break_hook = NULL;
static int rl_completion_quote_character = 0;
static int rl_completion_suppress_quote = 0;
static int rl_completion_found_quote = 0;
static int history_write_timestamps = 0;
static int rl_bind_key_if_unbound_in_map(){ return 0; }
static int rl_bind_keyseq_in_map(){ return 0; }
static int rl_bind_keyseq_if_unbound_in_map(){ return 0; }
static void rl_tty_unset_default_bindings(){}
static void add_history_time(){}
static time_t history_get_time(){ return 0; }
#endif /* (RL_VERSION_MAJOR < 5) */

#if (RL_READLINE_VERSION < 0x0501)
/* features introduced by GNU Readline 5.1 */
static int rl_prefer_env_winsize = 0;
static t_utf8 rl_variable_value(CONST char * v){ return NULL; }
static void rl_reset_screen_size(){}
#endif /* (RL_READLINE_VERSION < 0x0501) */

#if (RL_VERSION_MAJOR < 6)
/* documented by 6.0 but implemented since 2.1 */
extern char *rl_display_prompt;
/* features introduced by GNU Readline 6.0 */
static int rl_sort_completion_matches = 1;
static int rl_completion_invoking_key = 0;
static void rl_echo_signal_char(int sig){}
#endif /* (RL_VERSION_MAJOR < 6) */

#if (RL_READLINE_VERSION < 0x0601)
/* features introduced by GNU Readline 6.1 */
static rl_dequote_func_t *rl_filename_rewrite_hook;

/* Convenience function that discards, then frees, MAP. */
static void
rl_free_keymap (Keymap map)
{
  rl_discard_keymap (map);
  xfree ((char *)map);
}
#endif /* (RL_READLINE_VERSION < 0x0601) */

/* No feature to be handled by this module is introduced by GNU Readline 6.2 */

#if (RL_READLINE_VERSION < 0x0603)
/* documented by 6.3 but implemented since 2.1 */
extern int rl_key_sequence_length;
#if (RL_READLINE_VERSION > 0x0600)
/* externed by 6.3 but implemented since 6.1 */
extern void rl_free_keymap (Keymap);
#endif
/* features introduced by GNU Readline 6.3 */
static rl_hook_func_t *rl_signal_event_hook = NULL;
static rl_hook_func_t *rl_input_available_hook = NULL;
static int rl_executing_key = 0;
static char *rl_executing_keyseq = NULL;
static int rl_change_environment = 1;
static rl_icppfunc_t *rl_filename_stat_hook = NULL;

void rl_clear_history (void) {}
/*
  documented by 6.3 but implemented since 2.1
static HISTORY_STATE    *history_get_hitory_state();
static void     *history_set_history_state(HISTORY_STATE *state)
 */
#endif /* (RL_READLINE_VERSION < 0x0603) */

#if (RL_READLINE_VERSION < 0x0700)
/* features introduced by GNU Readline 7.0 */
static int rl_clear_visible_line(void) { return 0; }
static int rl_tty_set_echoing(int value) { return 0; }
static void rl_callback_sigcleanup (void) {}
static int rl_pending_signal(void) { return 0; }
static int rl_persistent_signal_handlers = 0;
#endif /* (RL_READLINE_VERSION < 0x0700) */

#if (RL_READLINE_VERSION == 0x0700)
/* not defined in readline.h */
extern int rl_tty_set_echoing (int);
#endif /* (RL_READLINE_VERSION == 0x0700) */

#if (RL_READLINE_VERSION < 0x0800)
/* features introduced by GNU Readline 8.0 */
static int rl_empty_keymap (Keymap keymap) { return 0; }
static int rl_set_keymap_name (const char *name, Keymap keymap) { return 0; }
static void rl_check_signals (void) {}
/* rl_function_of_keyseq_len() is not added intentionally */
static int history_quoting_state;
#endif /* (RL_READLINE_VERSION < 0x0800) */

#if (RL_READLINE_VERSION < 0x0801)
/* features introduced by GNU Readline 8.1 */
static void rl_activate_mark (void) {}
static void rl_deactivate_mark (void) {}
static void rl_keep_mark_active (void) {}
static int rl_mark_active_p (void) { return 0; }
#endif /* (RL_READLINE_VERSION < 0x0801) */

#if (RL_READLINE_VERSION < 0x0802)
/* features introduced by GNU Readline 8.2 */
static int rl_trim_arg_from_keyseq (const char *keyseq, size_t len, Keymap map) { return 0; }
static int rl_set_timeout (unsigned int secs, unsigned int usecs) { return 0; }
static int rl_clear_timeout (void) { return 0; }
static int rl_timeout_remaining (unsigned int *secs, unsigned int *usecs) { return 0; }
static int rl_eof_found = 0;
static rl_hook_func_t *rl_timeout_event_hook = NULL;
#endif /* (RL_READLINE_VERSION < 0x0802) */

#if (RL_READLINE_VERSION < 0x0803)
/* features introduced by GNU Readline 8.3 */
static void rl_print_keybinding (const char *name, Keymap kmap, int print_readonly) {}
static void rl_reparse_colors (void) {}
/* Functions for displaying key bindings. Currently only one. */
typedef void rl_macro_print_func_t (const char *, const char *, int, const char *); // 8.3
static rl_macro_print_func_t *rl_macro_display_hook = NULL;
static rl_dequote_func_t *rl_completion_rewrite_hook = NULL;
static int rl_full_quoting_desired = 0;
#endif /* (RL_READLINE_VERSION < 0x0803) */

/*
 * utility/dummy functions
 */
#if 0
/* Added in 2000.  Removed in 2022. */
/*
 * Using xfree() in GNU Readline Library causes problem with Solaris
 * 2.5.  It seems that the DLL mechanism of Solaris 2.5 links another
 * xfree() that does not do NULL argument check.
 * I choose this as default since some other OSs may have same problem.
 * usemymalloc=n is required.
 */
static void
xfree (string)
     PTR_T string;
{
  if (string)
    free (string);
}
#endif
static char *
dupstr(CONST char *s)           /* duplicate string */
{
  /*
   * Use xmalloc(), because allocated block will be freed in the GNU
   * Readline Library routine.
   * Don't make a macro, because the variable 's' is evaluated twice.
   */
  int len = strlen(s) + 1;
  char *d = xmalloc(len);
  Copy(s, d, len, char);        /* Is Copy() better than strcpy() in XS? */
  return d;
}

/*
 * for tputs XS routine
 */
static char *tputs_ptr;
static int
tputs_char(int c)
{
  return *tputs_ptr++ = c;
}

/*
 * return name of FUNCTION.
 * I asked Chet Ramey to add this function in readline/bind.c.  But he
 * did not, since he could not find any reasonable excuse.
 */
static const char *
rl_get_function_name (rl_command_func_t *function)
{
  register int i;

  rl_initialize_funmap ();

  for (i = 0; funmap[i]; i++)
    if (funmap[i]->function == function)
      return ((const char *)funmap[i]->name); /* cast is for oldies */
  return NULL;
}

/*
 * from readline-4.0:complete.c
 * Redefine here since the function defined as static in complete.c.
 * This function is used for default value for rl_filename_quoting_function.
 */
static char * rl_quote_filename (char *s, int rtype, char *qcp);

static char *
rl_quote_filename (char *s, int rtype, char *qcp)
{
  char *r;

  r = xmalloc (strlen (s) + 2);
  *r = *rl_completer_quote_characters;
  strcpy (r + 1, s);
  if (qcp)
    *qcp = *rl_completer_quote_characters;
  return r;
}

/*
 *      string variable table for _rl_store_str(), _rl_fetch_str()
 */

static struct str_vars {
  char **var;
  int accessed;
  int read_only;
} str_tbl[] = {
  /* When you change length of rl_line_buffer, you must call
     rl_extend_line_buffer().  See _rl_store_rl_line_buffer() */
  { &rl_line_buffer,                                    0, 0 }, /* 0 */
  { &rl_prompt,                                         0, 1 }, /* 1 */
  { (char **)&rl_library_version,                       0, 1 }, /* 2 */
  { (char **)&rl_terminal_name,                         0, 0 }, /* 3 */
  { (char **)&rl_readline_name,                         0, 0 }, /* 4 */

  { (char **)&rl_basic_word_break_characters,           0, 0 }, /* 5 */
  { (char **)&rl_basic_quote_characters,                0, 0 }, /* 6 */
  { (char **)&rl_completer_word_break_characters,       0, 0 }, /* 7 */
  { (char **)&rl_completer_quote_characters,            0, 0 }, /* 8 */
  { (char **)&rl_filename_quote_characters,             0, 0 }, /* 9 */
  { (char **)&rl_special_prefixes,                      0, 0 }, /* 10 */

  { &history_no_expand_chars,                           0, 0 }, /* 11 */
  { &history_search_delimiter_chars,                    0, 0 }, /* 12 */

  { &rl_executing_macro,                                0, 1 }, /* 13 */
  { &history_word_delimiters,                           0, 0 }, /* 14 */
  { &rl_display_prompt,                                 0, 0 }, /* 15 */
  { &rl_executing_keyseq,                               0, 1 }, /* 16 */
};

/*
 *      integer variable table for _rl_store_int(), _rl_fetch_int()
 */

static struct int_vars {
  int *var;
  int charp;
  int read_only;
  int ulong;
} int_tbl[] = {
  { &rl_point,                                  0, 0, 0},       /* 0 */
  { &rl_end,                                    0, 0, 0},       /* 1 */
  { &rl_mark,                                   0, 0, 0},       /* 2 */
  { &rl_done,                                   0, 0, 0},       /* 3 */
  { &rl_pending_input,                          0, 0, 0},       /* 4 */

  { &rl_completion_query_items,                 0, 0, 0},       /* 5 */
  { &rl_completion_append_character,            0, 0, 0},       /* 6 */
  { &rl_ignore_completion_duplicates,           0, 0, 0},       /* 7 */
  { &rl_filename_completion_desired,            0, 0, 0},       /* 8 */
  { &rl_filename_quoting_desired,               0, 0, 0},       /* 9 */
  { &rl_inhibit_completion,                     0, 0, 0},       /* 10 */

  { &history_base,                              0, 0, 0},       /* 11 */
  { &history_length,                            0, 0, 0},       /* 12 */
#if (RL_READLINE_VERSION >= 0x0402)
  { &history_max_entries,                       0, 1, 0},       /* 13 */
#else /* (RL_READLINE_VERSION < 0x0402) */
  { &max_input_history,                         0, 1, 0},       /* 13 */
#endif /* (RL_READLINE_VERSION < 0x0402) */
  { &history_write_timestamps,                  0, 0, 0},       /* 14 */
  { (int *)&history_expansion_char,             1, 0, 0},       /* 15 */
  { (int *)&history_subst_char,                 1, 0, 0},       /* 16 */
  { (int *)&history_comment_char,               1, 0, 0},       /* 17 */
  { &history_quotes_inhibit_expansion,          0, 0, 0},       /* 18 */
  { &rl_erase_empty_line,                       0, 0, 0},       /* 19 */
  { &rl_catch_signals,                          0, 0, 0},       /* 20 */
  { &rl_catch_sigwinch,                         0, 0, 0},       /* 21 */
  { &rl_already_prompted,                       0, 0, 0},       /* 22 */
  { &rl_num_chars_to_read,                      0, 0, 0},       /* 23 */
  { &rl_dispatching,                            0, 0, 0},       /* 24 */
  { &rl_gnu_readline_p,                         0, 1, 0},       /* 25 */
#if (RL_READLINE_VERSION >= 0x0700)
  /*
   * rl_readline_state becomes unsigned long on RL 7.0
   * It still holds 32bit value.
   */
  { (int *)&rl_readline_state,                  0, 0, 1},       /* 26 */
#else
  { &rl_readline_state,                         0, 0, 0},       /* 26 */
#endif
  { &rl_explicit_arg,                           0, 1, 0},       /* 27 */
  { &rl_numeric_arg,                            0, 1, 0},       /* 28 */
  { &rl_editing_mode,                           0, 1, 0},       /* 29 */
  { &rl_attempted_completion_over,              0, 0, 0},       /* 30 */
  { &rl_completion_type,                        0, 0, 0},       /* 31 */
  { &rl_readline_version,                       0, 1, 0},       /* 32 */
  { &rl_completion_suppress_append,             0, 0, 0},       /* 33 */
  { &rl_completion_quote_character,             0, 1, 0},       /* 34 */
  { &rl_completion_suppress_quote,              0, 0, 0},       /* 35 */
  { &rl_completion_found_quote,                 0, 1, 0},       /* 36 */
  { &rl_completion_mark_symlink_dirs,           0, 0, 0},       /* 37 */
  { &rl_prefer_env_winsize,                     0, 0, 0},       /* 38 */
  { &rl_sort_completion_matches,                0, 0, 0},       /* 39 */
  { &rl_completion_invoking_key,                0, 1, 0},       /* 40 */
  { &rl_executing_key,                          0, 1, 0},       /* 41 */
  { &rl_key_sequence_length,                    0, 1, 0},       /* 42 */
  { &rl_change_environment,                     0, 0, 0},       /* 43 */
  { &rl_persistent_signal_handlers,             0, 0, 0},       /* 44 */
  { &history_quoting_state,                     0, 0, 0},       /* 45 */
  { &utf8_mode,                                 0, 0, 0},       /* 46 */
  { &rl_eof_found,                              0, 0, 0},       /* 47 */
  { &rl_full_quoting_desired,                   0, 0, 0},       /* 48 */
};

/*
 *      function pointer variable table for _rl_store_function(),
 *      _rl_fetch_funtion()
 */
static int startup_hook_wrapper (void);
static int event_hook_wrapper (void);
static int getc_function_wrapper (PerlIO *);
static void redisplay_function_wrapper (void);
static char *completion_entry_function_wrapper (const char *, int);;
static char **attempted_completion_function_wrapper (char *, int, int);
static char *filename_quoting_function_wrapper PARAMS((char *text, int match_type,
                                                    char *quote_pointer));
static char *filename_dequoting_function_wrapper (char *text, int quote_char);
static int char_is_quoted_p_wrapper (char *text, int index);
static void ignore_some_completions_function_wrapper (char **matches);
static int directory_completion_hook_wrapper (char **textp);
static int history_inhibit_expansion_function_wrapper (char *str, int i);
static int pre_input_hook_wrapper (void);
static void completion_display_matches_hook_wrapper PARAMS((char **matches,
                                                         int len, int max));
static char *completion_word_break_hook_wrapper (void);
static int prep_term_function_wrapper (int meta_flag);
static int deprep_term_function_wrapper (void);
static int directory_rewrite_hook_wrapper (char **dirnamep);
static char *filename_rewrite_hook_wrapper (char *text, int quote_char);
static int signal_event_hook_wrapper (void);
static int input_available_hook_wrapper (void);
static int filename_stat_hook_wrapper (char **fnamep);
static int timeout_event_hook_wrapper (void);
static int macro_display_hook_wrapper (const char *, const char *, int, const char *);
static char *completion_rewrite_hook_wrapper (char *text, int quote_char);

enum { STARTUP_HOOK, EVENT_HOOK, GETC_FN, REDISPLAY_FN,
       CMP_ENT, ATMPT_COMP,
       FN_QUOTE, FN_DEQUOTE, CHAR_IS_QUOTEDP,
       IGNORE_COMP, DIR_COMP, HIST_INHIBIT_EXP,
       PRE_INPUT_HOOK, COMP_DISP_HOOK, COMP_WD_BRK_HOOK,
       PREP_TERM, DEPREP_TERM, DIR_REWRITE, FN_REWRITE,
       SIG_EVT, INP_AVL, FN_STAT, TIMEOUT_EVENT,
       FH_MACRO_DISPLAY_HOOK, FH_COMPLETION_REWRITE_HOOK,
};

typedef int XFunction (void);
static struct fn_vars {
  XFunction **rlfuncp;          /* GNU Readline Library variable */
  XFunction *defaultfn;         /* default function */
  XFunction *wrapper;           /* wrapper function */
  SV *callback;                 /* Perl function */
} fn_tbl[] = {
  { &rl_startup_hook,   NULL,   startup_hook_wrapper,   NULL }, /* 0 */
  { &rl_event_hook,     NULL,   event_hook_wrapper,     NULL }, /* 1 */
  {
    (XFunction **)&rl_getc_function,                            /* 2 */
    (XFunction *)rl_getc,
    (XFunction *)getc_function_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_redisplay_function,                       /* 3 */
    (XFunction *)rl_redisplay,
    (XFunction *)redisplay_function_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_completion_entry_function,                /* 4 */
    NULL,
    (XFunction *)completion_entry_function_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_attempted_completion_function,            /* 5 */
    NULL,
    (XFunction *)attempted_completion_function_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_filename_quoting_function,                /* 6 */
    (XFunction *)rl_quote_filename,
    (XFunction *)filename_quoting_function_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_filename_dequoting_function,              /* 7 */
    NULL,
    (XFunction *)filename_dequoting_function_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_char_is_quoted_p,                         /* 8 */
    NULL,
    (XFunction *)char_is_quoted_p_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_ignore_some_completions_function,         /* 9 */
    NULL,
    (XFunction *)ignore_some_completions_function_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_directory_completion_hook,                /* 10 */
    NULL,
    (XFunction *)directory_completion_hook_wrapper,
    NULL
  },
  {
    (XFunction **)&history_inhibit_expansion_function,          /* 11 */
    NULL,
    (XFunction *)history_inhibit_expansion_function_wrapper,
    NULL
  },
  { &rl_pre_input_hook, NULL,   pre_input_hook_wrapper, NULL }, /* 12 */
  {
    (XFunction **)&rl_completion_display_matches_hook,          /* 13 */
    NULL,
    (XFunction *)completion_display_matches_hook_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_completion_word_break_hook,               /* 14 */
    NULL,
    (XFunction *)completion_word_break_hook_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_prep_term_function,                       /* 15 */
    (XFunction *)rl_prep_terminal,
    (XFunction *)prep_term_function_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_deprep_term_function,                     /* 16 */
    (XFunction *)rl_deprep_terminal,
    (XFunction *)deprep_term_function_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_directory_rewrite_hook,                   /* 17 */
    NULL,
    (XFunction *)directory_rewrite_hook_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_filename_rewrite_hook,                    /* 18 */
    NULL,
    (XFunction *)filename_rewrite_hook_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_signal_event_hook,                        /* 19 */
    NULL,
    (XFunction *)signal_event_hook_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_input_available_hook,                     /* 20 */
    NULL,
    (XFunction *)input_available_hook_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_filename_stat_hook,                       /* 21 */
    NULL,
    (XFunction *)filename_stat_hook_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_timeout_event_hook,                       /* 22 */
    NULL,
    (XFunction *)timeout_event_hook_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_macro_display_hook,                       /* 23 */
    NULL,
    (XFunction *)macro_display_hook_wrapper,
    NULL
  },
  {
    (XFunction **)&rl_completion_rewrite_hook,                  /* 24 */
    NULL,
    (XFunction *)completion_rewrite_hook_wrapper,
    NULL
  },
};

/*
 * Perl function wrappers
 */

/*
 * common utility wrappers
 */
/* for rl_voidfunc_t : void fn(void) */
static int
voidfunc_wrapper(int type)
{
  dSP;
  int count;
  int ret;
  SV *svret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  count = call_sv(fn_tbl[type].callback, G_SCALAR);
  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:voidfunc_wrapper: Internal error\n");

  svret = POPs;
  ret = SvIOK(svret) ? SvIV(svret) : -1;
  PUTBACK;
  FREETMPS;
  LEAVE;
  return ret;
}

/* for rl_vintfunc_t : void fn(int) */
static int
vintfunc_wrapper(int type, int arg)
{
  dSP;
  int count;
  int ret;
  SV *svret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSViv(arg)));
  PUTBACK;
  count = call_sv(fn_tbl[type].callback, G_SCALAR);
  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:vintfunc_wrapper: Internal error\n");

  svret = POPs;
  ret = SvIOK(svret) ? SvIV(svret) : -1;
  PUTBACK;
  FREETMPS;
  LEAVE;
  return ret;
}

/* for rl_vcpfunc_t  : void fn(char *) */
#if 0
static int
vcpfunc_wrapper(int type, char *text)
{
  dSP;
  int count;
  int ret;
  SV *svret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  if (text) {
    XPUSHs(sv_2mortal(newSVpv(text, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  PUTBACK;

  count = call_sv(fn_tbl[type].callback, G_SCALAR);
  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:vcpfunc_wrapper: Internal error\n");

  svret = POPs;
  ret = SvIOK(svret) ? SvIV(svret) : -1;
  PUTBACK;
  FREETMPS;
  LEAVE;
  return ret;
}
#endif

/* for rl_vcppfunc_t : void fn(char **) */
#if 0
static int
vcppfunc_wrapper(int type, char **arg)
{
  dSP;
  int count;
  SV *sv;
  int ret;
  SV *svret;
  char *rstr;

  ENTER;
  SAVETMPS;

  if (arg && *arg) {
    sv = sv_2mortal(newSVpv(*arg, 0));
  } else {
    sv = &PL_sv_undef;
  }

  PUSHMARK(sp);
  XPUSHs(sv);
  PUTBACK;

  count = call_sv(fn_tbl[type].callback, G_SCALAR);

  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:vcppfunc_wrapper: Internal error\n");

  svret = POPs;
  ret = SvIOK(svret) ? SvIV(svret) : -1;

  rstr = SvPV(sv, PL_na);
  if (strcmp(*arg, rstr) != 0) {
    xfree(*arg);
    *arg = dupstr(rstr);
  }

  PUTBACK;
  FREETMPS;
  LEAVE;
  return ret;
}
#endif

/* for rl_hook_func_t, rl_ivoidfunc_t : int fn(void) */
static int
hook_func_wrapper(int type)
{
  dSP;
  int count;
  int ret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  count = call_sv(fn_tbl[type].callback, G_SCALAR);
  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:hook_func_wrapper: Internal error\n");

  ret = POPi;                   /* warns unless integer */
  PUTBACK;
  FREETMPS;
  LEAVE;
  return ret;
}

/* for rl_intfunc_t  : int fn(int) */
#if 0
static int
intfunc_wrapper(int type, int arg)
{
  dSP;
  int count;
  int ret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSViv(arg)));
  PUTBACK;
  count = call_sv(fn_tbl[type].callback, G_SCALAR);
  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:intfunc_wrapper: Internal error\n");

  ret = POPi;                   /* warns unless integer */
  PUTBACK;
  FREETMPS;
  LEAVE;
  return ret;
}
#endif

/* for rl_icpfunc_t : int fn(char *) */
#if 0
static int
icpfunc_wrapper(int type, char *text)
{
  dSP;
  int count;
  int ret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  if (text) {
    XPUSHs(sv_2mortal(newSVpv(text, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  PUTBACK;

  count = call_sv(fn_tbl[type].callback, G_SCALAR);

  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:icpfunc_wrapper: Internal error\n");

  ret = POPi;                   /* warns unless integer */
  PUTBACK;
  FREETMPS;
  LEAVE;
  return ret;
}
#endif

/* for rl_icppfunc_t : int fn(char **) */
static int
icppfunc_wrapper(int type, char **arg)
{
  dSP;
  int count;
  SV *sv;
  int ret;
  char *rstr;

  ENTER;
  SAVETMPS;

  if (arg && *arg) {
    sv = sv_2mortal(newSVpv(*arg, 0));
  } else {
    sv = &PL_sv_undef;
  }

  PUSHMARK(sp);
  XPUSHs(sv);
  PUTBACK;

  count = call_sv(fn_tbl[type].callback, G_SCALAR);

  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:icppfunc_wrapper: Internal error\n");

  ret = POPi;

  rstr = SvPV(sv, PL_na);
  if (strcmp(*arg, rstr) != 0) {
    xfree(*arg);
    *arg = dupstr(rstr);
  }

  PUTBACK;
  FREETMPS;
  LEAVE;
  return ret;
}

/* for rl_cpvfunc_t : (char *)fn(void) */
static char *
cpvfunc_wrapper(int type)
{
  dSP;
  int count;
  char *str;
  SV *svret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  count = call_sv(fn_tbl[type].callback, G_SCALAR);
  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:cpvfunc_wrapper: Internal error\n");

  svret = POPs;
  str = SvOK(svret) ? dupstr(SvPV(svret, PL_na)) : NULL;
  PUTBACK;
  FREETMPS;
  LEAVE;
  return str;
}

/* for rl_cpifunc_t   : (char *)fn(int) */
#if 0
static char *
cpifunc_wrapper(int type, int arg)
{
  dSP;
  int count;
  char *str;
  SV *svret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSViv(arg)));
  PUTBACK;
  count = call_sv(fn_tbl[type].callback, G_SCALAR);
  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:cpifunc_wrapper: Internal error\n");

  svret = POPs;
  str = SvOK(svret) ? dupstr(SvPV(svret, PL_na)) : NULL;
  PUTBACK;
  FREETMPS;
  LEAVE;
  return str;
}
#endif

/* for rl_cpcpfunc_t  : (char *)fn(char *) */
#if 0
static char *
cpcpfunc_wrapper(int type, char *text)
{
  dSP;
  int count;
  char *str;
  SV *svret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  if (text) {
    XPUSHs(sv_2mortal(newSVpv(text, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  PUTBACK;

  count = call_sv(fn_tbl[type].callback, G_SCALAR);
  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:cpcpfunc_wrapper: Internal error\n");

  svret = POPs;
  str = SvOK(svret) ? dupstr(SvPV(svret, PL_na)) : NULL;
  PUTBACK;
  FREETMPS;
  LEAVE;
  return str;
}
#endif

/* for rl_cpcppfunc_t : (char *)fn(char **) */
#if 0
static char *
cpcppfunc_wrapper(int type, char **arg)
{
  dSP;
  int count;
  SV *sv;
  char *str;
  SV *svret;
  char *rstr;

  ENTER;
  SAVETMPS;

  if (arg && *arg) {
    sv = sv_2mortal(newSVpv(*arg, 0));
  } else {
    sv = &PL_sv_undef;
  }

  PUSHMARK(sp);
  XPUSHs(sv);
  PUTBACK;

  count = call_sv(fn_tbl[type].callback, G_SCALAR);

  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:cpcppfunc_wrapper: Internal error\n");

  svret = POPs;
  str = SvOK(svret) ? dupstr(SvPV(svret, PL_na)) : NULL;

  rstr = SvPV(sv, PL_na);
  if (strcmp(*arg, rstr) != 0) {
    xfree(*arg);
    *arg = dupstr(rstr);
  }

  PUTBACK;
  FREETMPS;
  LEAVE;
  return str;
}
#endif

/*
 * for rl_icpintfunc_t : int fn(char *, int)
 */
static int
icpintfunc_wrapper(int type, char *text, int index)
{
  dSP;
  int count;
  int ret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  if (text) {
    XPUSHs(sv_2mortal_utf8(newSVpv(text, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  XPUSHs(sv_2mortal(newSViv(index)));
  PUTBACK;

  count = call_sv(fn_tbl[type].callback, G_SCALAR);

  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:icpintfunc_wrapper: Internal error\n");

  ret = POPi;                   /* warns unless integer */
  PUTBACK;
  FREETMPS;
  LEAVE;
  return ret;
}

/*
 * for rl_dequote_func_t : (char *)fn(char *, int)
 */
static char *
dequoting_function_wrapper(int type, char *text, int quote_char)
{
  dSP;
  int count;
  SV *replacement;
  char *str;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  if (text) {
    XPUSHs(sv_2mortal_utf8(newSVpv(text, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  XPUSHs(sv_2mortal(newSViv(quote_char)));
  PUTBACK;

  count = call_sv(fn_tbl[type].callback, G_SCALAR);

  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:dequoting_function_wrapper: Internal error\n");

  replacement = POPs;
  str = SvOK(replacement) ? dupstr(SvPV(replacement, PL_na)) : NULL;

  PUTBACK;
  FREETMPS;
  LEAVE;
  return str;
}

/*
 * Specific wrappers for each variable
 */
static int
startup_hook_wrapper()          { return voidfunc_wrapper(STARTUP_HOOK); }
static int
event_hook_wrapper()            { return voidfunc_wrapper(EVENT_HOOK); }

static int
getc_function_wrapper(PerlIO *fp)
{
  /*
   * 'PerlIO *fp' is ignored.  Use rl_instream instead in the getc_function.
   * How can I pass 'PerlIO *fp'?
   */
  return voidfunc_wrapper(GETC_FN);
}

static void
redisplay_function_wrapper()    { voidfunc_wrapper(REDISPLAY_FN); }

/*
 * call a perl function as rl_completion_entry_function
 * for rl_compentry_func_t : (char *)fn(const char *, int)
 */
static char *
completion_entry_function_wrapper(const char *text, int state)
{
  dSP;
  int count;
  SV *match;
  char *str;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  if (text) {
    XPUSHs(sv_2mortal_utf8(newSVpv(text, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  XPUSHs(sv_2mortal(newSViv(state)));
  PUTBACK;

  count = call_sv(fn_tbl[CMP_ENT].callback, G_SCALAR);

  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:completion_entry_function_wrapper: Internal error\n");

  match = POPs;
  str = SvOK(match) ? dupstr(SvPV(match, PL_na)) : NULL;

  PUTBACK;
  FREETMPS;
  LEAVE;
  return str;
}

/*
 * call a perl function as rl_attempted_completion_function
 * for rl_completion_func_t : (char **)fn(const char *, int, int)
 */

static char **
attempted_completion_function_wrapper(char *text, int start, int end)
{
  dSP;
  int count;
  char **matches;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  if (text) {
    XPUSHs(sv_2mortal_utf8(newSVpv(text, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  if (rl_line_buffer) {
    XPUSHs(sv_2mortal_utf8(newSVpv(rl_line_buffer, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  XPUSHs(sv_2mortal(newSViv(start)));
  XPUSHs(sv_2mortal(newSViv(end)));
  PUTBACK;

  count = call_sv(fn_tbl[ATMPT_COMP].callback, G_LIST);

  SPAGAIN;

  /* cf. ignore_some_completions_function_wrapper() */
  if (count > 0) {
    int i;
    int dopack = -1;

    /*
     * The returned array may contain some undef items.
     * Pack the array in such case.
     */
    matches = (char **)xmalloc (sizeof(char *) * (count + 1));
    matches[count] = NULL;
    for (i = count - 1; i >= 0; i--) {
      SV *v = POPs;
      if (SvOK(v)) {
        matches[i] = dupstr(SvPV(v, PL_na));
      } else {
        matches[i] = NULL;
        if (i != 0)
          dopack = i;           /* lowest index of hole */
      }
    }
    /* pack undef items */
    if (dopack > 0) {           /* don't pack matches[0] */
      int j = dopack;
      for (i = dopack; i < count; i++) {
        if (matches[i])
          matches[j++] = matches[i];
      }
      matches[count = j] = NULL;
    }
    if (count == 2) {   /* only one match */
      xfree(matches[0]);
      matches[0] = matches[1];
      matches[1] = NULL;
    } else if (count == 1 && !matches[0]) { /* in case of a list of undef */
      xfree(matches);
      matches = NULL;
    }
    if (count > 1 && matches[0] == NULL) { /* #132384 */
      warn("Gnu.xs:attempted_completion_function_wrapper: The 1st element is NULL.  Use rl_completion_matches() properly.");
      xfree(matches);
      matches = NULL;
    }
  } else {
    matches = NULL;
  }

  PUTBACK;
  FREETMPS;
  LEAVE;

  return matches;
}

/*
 * call a perl function as rl_filename_quoting_function
 * for rl_quote_func_t : (char *)fn(char *, int, char *)
 */

static char *
filename_quoting_function_wrapper(char *text, int match_type, char *quote_pointer)
{
  dSP;
  int count;
  SV *replacement;
  char *str;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  if (text) {
    XPUSHs(sv_2mortal_utf8(newSVpv(text, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  XPUSHs(sv_2mortal(newSViv(match_type)));
  if (quote_pointer) {
    XPUSHs(sv_2mortal(newSVpv(quote_pointer, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  PUTBACK;

  count = call_sv(fn_tbl[FN_QUOTE].callback, G_SCALAR);

  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:filename_quoting_function_wrapper: Internal error\n");

  replacement = POPs;
  str = SvOK(replacement) ? dupstr(SvPV(replacement, PL_na)) : NULL;

  PUTBACK;
  FREETMPS;
  LEAVE;
  return str;
}

static char *
filename_dequoting_function_wrapper(char *text, int quote_char)
{
  return dequoting_function_wrapper(FN_DEQUOTE, text, quote_char);
}

static int
char_is_quoted_p_wrapper(char *text, int index)
{
  return icpintfunc_wrapper(CHAR_IS_QUOTEDP, text, index);
}

/*
 * call a perl function as rl_ignore_some_completions_function
 * for rl_compignore_func_t : int fn(char **)
 */

static void
ignore_some_completions_function_wrapper(char **matches)
{
  dSP;
  int count, i, only_lcd;

  only_lcd = matches[1] == NULL;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);

  /* matches[0] is the maximal matching substring.  So it may NULL, even rest
   * of matches[] has values. */
  if (matches[0]) {
    XPUSHs(sv_2mortal_utf8(newSVpv(matches[0], 0)));
    /* xfree(matches[0]);*/
  } else {
    XPUSHs(&PL_sv_undef);
  }
  for (i = 1; matches[i]; i++) {
      XPUSHs(sv_2mortal_utf8(newSVpv(matches[i], 0)));
      xfree(matches[i]);
  }
  PUTBACK;

  count = call_sv(fn_tbl[IGNORE_COMP].callback, G_LIST);

  SPAGAIN;

  if (only_lcd) {
    if (count == 0) {           /* no match */
      xfree(matches[0]);
      matches[0] = NULL;
    } /* else only one match */
  } else if (count > 0) {
    int i;
    int dopack = -1;

    /*
     * The returned array may contain some undef items.
     * Pack the array in such case.
     */
    matches[count] = NULL;
    for (i = count - 1; i > 0; i--) { /* don't pop matches[0] */
      SV *v = POPs;
      if (SvOK(v)) {
        matches[i] = dupstr(SvPV(v, PL_na));
      } else {
        matches[i] = NULL;
        dopack = i;             /* lowest index of undef */
      }
    }
    /* pack undef items */
    if (dopack > 0) {           /* don't pack matches[0] */
      int j = dopack;
      for (i = dopack; i < count; i++) {
        if (matches[i])
          matches[j++] = matches[i];
      }
      matches[count = j] = NULL;
    }
    if (count == 1) {           /* no match */
      xfree(matches[0]);
      matches[0] = NULL;
    } else if (count == 2) {    /* only one match */
      xfree(matches[0]);
      matches[0] = matches[1];
      matches[1] = NULL;
    }
  } else {                      /* no match */
    xfree(matches[0]);
    matches[0] = NULL;
  }

  PUTBACK;
  FREETMPS;
  LEAVE;
}

static int
directory_completion_hook_wrapper(char **textp)
{
  return icppfunc_wrapper(DIR_COMP, textp);
}

static int
history_inhibit_expansion_function_wrapper(char *text, int index)
{
  return icpintfunc_wrapper(HIST_INHIBIT_EXP, text, index);
}

static int
pre_input_hook_wrapper() { return voidfunc_wrapper(PRE_INPUT_HOOK); }

#if (RL_VERSION_MAJOR >= 4)
/*
 * call a perl function as rl_completion_display_matches_hook
 * for rl_compdisp_func_t : void fn(char **, int, int)
 */

static void
completion_display_matches_hook_wrapper(char **matches, int len, int max)
{
  dSP;
  int i;
  AV *av_matches;

  /* copy C matches[] array into perl array */
  av_matches = newAV();

  /* matches[0] is the maximal matching substring.  So it may NULL, even rest
   * of matches[] has values. */
  if (matches[0]) {
    av_push(av_matches, sv_2mortal_utf8(newSVpv(matches[0], 0)));
  } else {
    av_push(av_matches, &PL_sv_undef);
  }

  for (i = 1; matches[i]; i++)
    if (matches[i]) {
      av_push(av_matches, sv_2mortal_utf8(newSVpv(matches[i], 0)));
    } else {
      av_push(av_matches, &PL_sv_undef);
    }

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newRV_inc((SV *)av_matches))); /* push reference of array */
  XPUSHs(sv_2mortal(newSViv(len)));
  XPUSHs(sv_2mortal(newSViv(max)));
  PUTBACK;

  call_sv(fn_tbl[COMP_DISP_HOOK].callback, G_DISCARD);
}
#else /* (RL_VERSION_MAJOR < 4) */
static void
completion_display_matches_hook_wrapper(char **matches, int len, int max)
{
  /* dummy */
}
#endif /* (RL_VERSION_MAJOR < 4) */

static char *
completion_word_break_hook_wrapper()
{
  return cpvfunc_wrapper(COMP_WD_BRK_HOOK);
}

static int
prep_term_function_wrapper(int meta_flag)
{
  return vintfunc_wrapper(PREP_TERM, meta_flag);
}

static int
deprep_term_function_wrapper() { return voidfunc_wrapper(DEPREP_TERM); }

static int
directory_rewrite_hook_wrapper(char **dirnamep)
{
  return icppfunc_wrapper(DIR_REWRITE, dirnamep);
}

static char *
filename_rewrite_hook_wrapper(char *text, int quote_char)
{
  return dequoting_function_wrapper(FN_REWRITE, text, quote_char);
}

static int
signal_event_hook_wrapper() { return hook_func_wrapper(SIG_EVT); }

static int
input_available_hook_wrapper() { return hook_func_wrapper(INP_AVL); }

static int
filename_stat_hook_wrapper(char **fnamep)
{
  return icppfunc_wrapper(FN_STAT, fnamep);
}

static int
timeout_event_hook_wrapper() { return hook_func_wrapper(TIMEOUT_EVENT); }

static int
macro_display_hook_wrapper(const char *keyname, const char *out, int print_readably, const char *prefix)
{
  dSP;
  int count;
  int ret;
  SV *svret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  if (keyname) {
    XPUSHs(sv_2mortal_utf8(newSVpv(keyname, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  if (out) {
    XPUSHs(sv_2mortal_utf8(newSVpv(out, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  XPUSHs(sv_2mortal(newSViv(print_readably)));
  if (prefix) {
    XPUSHs(sv_2mortal_utf8(newSVpv(prefix, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }

  PUTBACK;
  count = call_sv(fn_tbl[FH_MACRO_DISPLAY_HOOK].callback, G_SCALAR);
  SPAGAIN;

  if (count != 1)
    croak("Gnu.xs:macro_display_hook_wrapper: Internal error\n");

  svret = POPs;
  ret = SvIOK(svret) ? SvIV(svret) : -1;
  PUTBACK;
  FREETMPS;
  LEAVE;
  return ret;
}

static char *
completion_rewrite_hook_wrapper(char *text, int quote_char)
{
  return dequoting_function_wrapper(FH_COMPLETION_REWRITE_HOOK, text, quote_char);
}

/*
 *      If you need more custom functions, define more funntion_wrapper_xx()
 *      and add entry on fntbl[].
 */

static int function_wrapper (int count, int key, int id);

static int fw_00(int c, int k) { return function_wrapper(c, k,  0); }
static int fw_01(int c, int k) { return function_wrapper(c, k,  1); }
static int fw_02(int c, int k) { return function_wrapper(c, k,  2); }
static int fw_03(int c, int k) { return function_wrapper(c, k,  3); }
static int fw_04(int c, int k) { return function_wrapper(c, k,  4); }
static int fw_05(int c, int k) { return function_wrapper(c, k,  5); }
static int fw_06(int c, int k) { return function_wrapper(c, k,  6); }
static int fw_07(int c, int k) { return function_wrapper(c, k,  7); }
static int fw_08(int c, int k) { return function_wrapper(c, k,  8); }
static int fw_09(int c, int k) { return function_wrapper(c, k,  9); }
static int fw_10(int c, int k) { return function_wrapper(c, k, 10); }
static int fw_11(int c, int k) { return function_wrapper(c, k, 11); }
static int fw_12(int c, int k) { return function_wrapper(c, k, 12); }
static int fw_13(int c, int k) { return function_wrapper(c, k, 13); }
static int fw_14(int c, int k) { return function_wrapper(c, k, 14); }
static int fw_15(int c, int k) { return function_wrapper(c, k, 15); }

static struct fnnode {
  rl_command_func_t *wrapper;   /* C wrapper function */
  SV *pfn;                      /* Perl function */
} fntbl[] = {
  { fw_00,      NULL },
  { fw_01,      NULL },
  { fw_02,      NULL },
  { fw_03,      NULL },
  { fw_04,      NULL },
  { fw_05,      NULL },
  { fw_06,      NULL },
  { fw_07,      NULL },
  { fw_08,      NULL },
  { fw_09,      NULL },
  { fw_10,      NULL },
  { fw_11,      NULL },
  { fw_12,      NULL },
  { fw_13,      NULL },
  { fw_14,      NULL },
  { fw_15,      NULL },
};

static int
function_wrapper(int count, int key, int id)
{
  dSP;

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSViv(count)));
  XPUSHs(sv_2mortal(newSViv(key)));
  PUTBACK;

  call_sv(fntbl[id].pfn, G_DISCARD);

  return 0;
}

static SV *callback_handler_callback = NULL;

static void
callback_handler_wrapper(char *line)
{
  dSP;

  PUSHMARK(sp);
  if (line) {
    XPUSHs(sv_2mortal_utf8(newSVpv(line, 0)));
  } else {
    XPUSHs(&PL_sv_undef);
  }
  PUTBACK;

  call_sv(callback_handler_callback, G_DISCARD);
}

#if 0 /* 2016/06/07 worked but no advantage */
/* to keep PerlIO given by _rl_store_iostream() */
static PerlIO *perlio_in;
static PerlIO *perlio_out;

/* for rl_getc_function */
static int
trg_getc()
{
  return PerlIO_getc(perlio_in);
}
/* for rl_input_available_hook */
static int
trg_input_available()
{
  return PerlIO_get_cnt(perlio_in) > 0;
}
#endif


/*
 * make separate name space for low level XS functions and their methods
 */

#line 1832 "Gnu.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 1976 "Gnu.c"

XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_readline); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_readline)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "prompt= NULL");
    {
	t_utf8_free	RETVAL;
	CONST char *	prompt;

	if (items < 1)
	    prompt = NULL;
	else {
	    prompt = (CONST char *)SvPV_nolen(ST(0))
;
	}
#line 1839 "Gnu.xs"
        RETVAL = readline(prompt);
#line 1996 "Gnu.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL) {
	      sv_setpv(RETVALSV, RETVAL);
	      if (utf8_mode)
		sv_utf8_decode(RETVALSV);
	      xfree(RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_add_defun); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_add_defun)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "name, fn, key= -1");
    {
	rl_command_func_t *	RETVAL;
	CONST char *	name = (CONST char *)SvPV_nolen(ST(0))
;
	SV *	fn = ST(1)
;
	int	key;

	if (items < 3)
	    key = -1;
	else {
	    key = (int)SvIV(ST(2))
;
	}
#line 1853 "Gnu.xs"
        {
          int i;
          int nentry = sizeof(fntbl)/sizeof(struct fnnode);

          /* search an empty slot */
          for (i = 0; i < nentry; i++)
            if (! fntbl[i].pfn)
              break;

          if (i >= nentry) {
            warn("Gnu.xs:rl_add_defun: custom function table is full. The maximum number of custum function is %d.\n",
                 nentry);
            XSRETURN_UNDEF;
          }

          fntbl[i].pfn = newSVsv(fn);

          /* rl_add_defun() always returns 0. */
          rl_add_defun(dupstr(name), fntbl[i].wrapper, key);
          RETVAL = fntbl[i].wrapper;
        }
#line 2055 "Gnu.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "rl_command_func_tPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_make_bare_keymap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_make_bare_keymap)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	Keymap	RETVAL;

	RETVAL = rl_make_bare_keymap();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Keymap", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_copy_keymap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_copy_keymap)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "map");
    {
	Keymap	RETVAL;
	Keymap	map;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Keymap")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    map = INT2PTR(Keymap,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_copy_keymap",
			"map", "Keymap",
			refstr, ST(0)
		);
	}
;
#line 1888 "Gnu.xs"
        RETVAL = rl_copy_keymap(map);
#line 2113 "Gnu.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Keymap", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_make_keymap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_make_keymap)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	Keymap	RETVAL;

	RETVAL = rl_make_keymap();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Keymap", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_discard_keymap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_discard_keymap)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "map");
    {
	Keymap	RETVAL;
	Keymap	map;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Keymap")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    map = INT2PTR(Keymap,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_discard_keymap",
			"map", "Keymap",
			refstr, ST(0)
		);
	}
;
#line 1900 "Gnu.xs"
        rl_discard_keymap(map);
        RETVAL = map;
#line 2172 "Gnu.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Keymap", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_free_keymap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_free_keymap)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "map");
    {
	Keymap	map;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Keymap")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    map = INT2PTR(Keymap,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_free_keymap",
			"map", "Keymap",
			refstr, ST(0)
		);
	}
;
#line 1909 "Gnu.xs"
        rl_free_keymap(map);
#line 2208 "Gnu.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_empty_keymap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_empty_keymap)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "map");
    {
	int	RETVAL;
	dXSTARG;
	Keymap	map;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Keymap")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    map = INT2PTR(Keymap,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_empty_keymap",
			"map", "Keymap",
			refstr, ST(0)
		);
	}
;
#line 1915 "Gnu.xs"
        RETVAL = rl_empty_keymap(map);
#line 2240 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_keymap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_keymap)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	Keymap	RETVAL;

	RETVAL = rl_get_keymap();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Keymap", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_set_keymap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_set_keymap)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "map");
    {
	Keymap	RETVAL;
	Keymap	map;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Keymap")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    map = INT2PTR(Keymap,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_set_keymap",
			"map", "Keymap",
			refstr, ST(0)
		);
	}
;
#line 1927 "Gnu.xs"
        rl_set_keymap(map);
        RETVAL = map;
#line 2295 "Gnu.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Keymap", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_keymap_by_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_keymap_by_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	Keymap	RETVAL;
	CONST char *	name = (CONST char *)SvPV_nolen(ST(0))
;

	RETVAL = rl_get_keymap_by_name(name);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Keymap", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_keymap_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_keymap_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "map");
    {
	char *	RETVAL;
	dXSTARG;
	Keymap	map;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Keymap")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    map = INT2PTR(Keymap,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::rl_get_keymap_name",
			"map", "Keymap",
			refstr, ST(0)
		);
	}
;

	RETVAL = rl_get_keymap_name(map);
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_set_keymap_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_set_keymap_name)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "name, map");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	name = (CONST char *)SvPV_nolen(ST(0))
;
	Keymap	map;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Keymap")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    map = INT2PTR(Keymap,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_set_keymap_name",
			"map", "Keymap",
			refstr, ST(1)
		);
	}
;
#line 1945 "Gnu.xs"
        RETVAL = rl_set_keymap_name(name, map);
#line 2392 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_bind_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_bind_key)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "key, function, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	int	key = (int)SvIV(ST(0))
;
	rl_command_func_t *	function;
	Keymap	map;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "rl_command_func_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    function = INT2PTR(rl_command_func_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_bind_key",
			"function", "rl_command_func_tPtr",
			refstr, ST(1)
		);
	}
;

	if (items < 3)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(2)) && sv_derived_from(ST(2), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(2)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_bind_key",
			    "map", "Keymap",
			    refstr, ST(2)
		    );
	    }
;
	}
#line 1956 "Gnu.xs"
        RETVAL = rl_bind_key_in_map(key, function, map);
#line 2447 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_bind_key_if_unbound); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_bind_key_if_unbound)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "key, function, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	int	key = (int)SvIV(ST(0))
;
	rl_command_func_t *	function;
	Keymap	map;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "rl_command_func_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    function = INT2PTR(rl_command_func_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_bind_key_if_unbound",
			"function", "rl_command_func_tPtr",
			refstr, ST(1)
		);
	}
;

	if (items < 3)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(2)) && sv_derived_from(ST(2), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(2)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_bind_key_if_unbound",
			    "map", "Keymap",
			    refstr, ST(2)
		    );
	    }
;
	}
#line 1964 "Gnu.xs"
        RETVAL = rl_bind_key_if_unbound_in_map(key, function, map);
#line 2502 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_unbind_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_unbind_key)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "key, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	int	key = (int)SvIV(ST(0))
;
	Keymap	map;

	if (items < 2)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(1)) && sv_derived_from(ST(1), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(1)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_unbind_key",
			    "map", "Keymap",
			    refstr, ST(1)
		    );
	    }
;
	}
#line 1972 "Gnu.xs"
        RETVAL = rl_unbind_key_in_map(key, map);
#line 2542 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_unbind_function); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_unbind_function)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "function, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	rl_command_func_t *	function;
	Keymap	map;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "rl_command_func_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    function = INT2PTR(rl_command_func_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_unbind_function",
			"function", "rl_command_func_tPtr",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(1)) && sv_derived_from(ST(1), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(1)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_unbind_function",
			    "map", "Keymap",
			    refstr, ST(1)
		    );
	    }
;
	}
#line 1983 "Gnu.xs"
        RETVAL = rl_unbind_function_in_map(function, map);
#line 2595 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_unbind_command); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_unbind_command)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "command, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	command = (CONST char *)SvPV_nolen(ST(0))
;
	Keymap	map;

	if (items < 2)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(1)) && sv_derived_from(ST(1), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(1)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_unbind_command",
			    "map", "Keymap",
			    refstr, ST(1)
		    );
	    }
;
	}
#line 1991 "Gnu.xs"
        RETVAL = rl_unbind_command_in_map(command, map);
#line 2635 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_bind_keyseq); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_bind_keyseq)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "keyseq, function, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	keyseq = (CONST char *)SvPV_nolen(ST(0))
;
	rl_command_func_t *	function;
	Keymap	map;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "rl_command_func_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    function = INT2PTR(rl_command_func_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_bind_keyseq",
			"function", "rl_command_func_tPtr",
			refstr, ST(1)
		);
	}
;

	if (items < 3)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(2)) && sv_derived_from(ST(2), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(2)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_bind_keyseq",
			    "map", "Keymap",
			    refstr, ST(2)
		    );
	    }
;
	}
#line 1999 "Gnu.xs"
        RETVAL = rl_bind_keyseq_in_map(keyseq, function, map);
#line 2690 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_set_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_set_key)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "keyseq, function, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	keyseq = (CONST char *)SvPV_nolen(ST(0))
;
	rl_command_func_t *	function;
	Keymap	map;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "rl_command_func_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    function = INT2PTR(rl_command_func_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_set_key",
			"function", "rl_command_func_tPtr",
			refstr, ST(1)
		);
	}
;

	if (items < 3)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(2)) && sv_derived_from(ST(2), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(2)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_set_key",
			    "map", "Keymap",
			    refstr, ST(2)
		    );
	    }
;
	}
#line 2009 "Gnu.xs"
#if (RL_READLINE_VERSION >= 0x0402)
        RETVAL = rl_set_key(keyseq, function, map);
#else
        RETVAL = rl_generic_bind(ISFUNC, keyseq, (char *)function, map);
#endif
#line 2749 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_bind_keyseq_if_unbound); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_bind_keyseq_if_unbound)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "keyseq, function, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	keyseq = (CONST char *)SvPV_nolen(ST(0))
;
	rl_command_func_t *	function;
	Keymap	map;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "rl_command_func_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    function = INT2PTR(rl_command_func_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_bind_keyseq_if_unbound",
			"function", "rl_command_func_tPtr",
			refstr, ST(1)
		);
	}
;

	if (items < 3)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(2)) && sv_derived_from(ST(2), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(2)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_bind_keyseq_if_unbound",
			    "map", "Keymap",
			    refstr, ST(2)
		    );
	    }
;
	}
#line 2021 "Gnu.xs"
        RETVAL = rl_bind_keyseq_if_unbound_in_map(keyseq, function, map);
#line 2804 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_generic_bind_function); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_generic_bind_function)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "keyseq, function, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	keyseq = (CONST char *)SvPV_nolen(ST(0))
;
	rl_command_func_t *	function;
	Keymap	map;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "rl_command_func_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    function = INT2PTR(rl_command_func_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_generic_bind_function",
			"function", "rl_command_func_tPtr",
			refstr, ST(1)
		);
	}
;

	if (items < 3)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(2)) && sv_derived_from(ST(2), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(2)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_generic_bind_function",
			    "map", "Keymap",
			    refstr, ST(2)
		    );
	    }
;
	}
#line 2029 "Gnu.xs"
        RETVAL = rl_generic_bind(ISFUNC, keyseq, (char *)function, map);
#line 2859 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_generic_bind_keymap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_generic_bind_keymap)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "keyseq, keymap, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	keyseq = (CONST char *)SvPV_nolen(ST(0))
;
	Keymap	keymap;
	Keymap	map;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Keymap")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    keymap = INT2PTR(Keymap,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_generic_bind_keymap",
			"keymap", "Keymap",
			refstr, ST(1)
		);
	}
;

	if (items < 3)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(2)) && sv_derived_from(ST(2), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(2)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_generic_bind_keymap",
			    "map", "Keymap",
			    refstr, ST(2)
		    );
	    }
;
	}
#line 2037 "Gnu.xs"
        RETVAL = rl_generic_bind(ISKMAP, keyseq, (char *)keymap, map);
#line 2914 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_generic_bind_macro); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_generic_bind_macro)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "keyseq, macro, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	keyseq = (CONST char *)SvPV_nolen(ST(0))
;
	CONST char *	macro = (CONST char *)SvPV_nolen(ST(1))
;
	Keymap	map;

	if (items < 3)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(2)) && sv_derived_from(ST(2), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(2)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_generic_bind_macro",
			    "map", "Keymap",
			    refstr, ST(2)
		    );
	    }
;
	}
#line 2045 "Gnu.xs"
        RETVAL = rl_generic_bind(ISMACR, keyseq, dupstr(macro), map);
#line 2956 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_parse_and_bind); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_parse_and_bind)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "line");
    {
	CONST char *	line = (CONST char *)SvPV_nolen(ST(0))
;
#line 2053 "Gnu.xs"
        {
          char *s = dupstr(line);
          rl_parse_and_bind(s); /* Some NULs may be inserted in "s". */
          xfree(s);
        }
#line 2979 "Gnu.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_read_init_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_read_init_file)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "filename= NULL");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	filename;

	if (items < 1)
	    filename = NULL;
	else {
	    filename = (CONST char *)SvPV_nolen(ST(0))
;
	}

	RETVAL = rl_read_init_file(filename);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_call_function); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_call_function)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "function, count= 1, key= -1");
    {
	int	RETVAL;
	dXSTARG;
	rl_command_func_t *	function;
	int	count;
	int	key;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "rl_command_func_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    function = INT2PTR(rl_command_func_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_call_function",
			"function", "rl_command_func_tPtr",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    count = 1;
	else {
	    count = (int)SvIV(ST(1))
;
	}

	if (items < 3)
	    key = -1;
	else {
	    key = (int)SvIV(ST(2))
;
	}
#line 2070 "Gnu.xs"
        RETVAL = (*function)(count, key);
#line 3053 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_named_function); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_named_function)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	rl_command_func_t *	RETVAL;
	CONST char *	name = (CONST char *)SvPV_nolen(ST(0))
;

	RETVAL = rl_named_function(name);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "rl_command_func_tPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_function_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_function_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "function");
    {
	const char *	RETVAL;
	dXSTARG;
	rl_command_func_t *	function;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "rl_command_func_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    function = INT2PTR(rl_command_func_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::rl_get_function_name",
			"function", "rl_command_func_tPtr",
			refstr, ST(0)
		);
	}
;

	RETVAL = rl_get_function_name(function);
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_function_of_keyseq); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_function_of_keyseq)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "keyseq, map= rl_get_keymap()");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	keyseq = ST(0)
;
	Keymap	map;

	if (items < 2)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(1)) && sv_derived_from(ST(1), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(1)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_function_of_keyseq",
			    "map", "Keymap",
			    refstr, ST(1)
		    );
	    }
;
	}
#line 2087 "Gnu.xs"
        {
          int type;
          if (!SvOK(keyseq))
            return;
#if (RL_READLINE_VERSION < 0x0800)
          rl_command_func_t *p = rl_function_of_keyseq(SvPV_nolen(keyseq), map, &type);
#else
          rl_command_func_t *p = rl_function_of_keyseq_len(SvPV_nolen(keyseq), SvCUR(keyseq), map, &type);
#endif
          SV *sv;

          if (p) {
            sv = sv_newmortal();
            switch (type) {
            case ISFUNC:
              sv_setref_pv(sv, "rl_command_func_tPtr", (void*)p);
              break;
            case ISKMAP:
              sv_setref_pv(sv, "Keymap", (void*)p);
              break;
            case ISMACR:
              if (p) {
                sv_setpv(sv, (char *)p);
              }
              break;
            default:
              warn("Gnu.xs:rl_function_of_keyseq: illegal type `%d'\n", type);
              XSRETURN_EMPTY;   /* return NULL list */
            }
            EXTEND(sp, 2);
            PUSHs(sv);
            PUSHs(sv_2mortal(newSViv(type)));
          } else
            ;                   /* return NULL list */
        }
#line 3184 "Gnu.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_trim_arg_from_keyseq); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_trim_arg_from_keyseq)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "keyseq, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	SV *	keyseq = ST(0)
;
	Keymap	map;

	if (items < 2)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(1)) && sv_derived_from(ST(1), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(1)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_trim_arg_from_keyseq",
			    "map", "Keymap",
			    refstr, ST(1)
		    );
	    }
;
	}
#line 2127 "Gnu.xs"
        {
          if (!SvOK(keyseq))
            RETVAL = -1;
          else
            RETVAL = rl_trim_arg_from_keyseq(SvPV_nolen(keyseq), SvCUR(keyseq), map);
        }
#line 3228 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_invoking_keyseqs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_invoking_keyseqs)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "function, map= rl_get_keymap()");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	rl_command_func_t *	function;
	Keymap	map;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "rl_command_func_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    function = INT2PTR(rl_command_func_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_invoking_keyseqs",
			"function", "rl_command_func_tPtr",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(1)) && sv_derived_from(ST(1), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(1)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_invoking_keyseqs",
			    "map", "Keymap",
			    refstr, ST(1)
		    );
	    }
;
	}
#line 2140 "Gnu.xs"
        {
          char **keyseqs;

          keyseqs = rl_invoking_keyseqs_in_map(function, map);

          if (keyseqs) {
            int i, count;

            /* count number of entries */
            for (count = 0; keyseqs[count]; count++)
              ;

            EXTEND(sp, count);
            for (i = 0; i < count; i++) {
              PUSHs(sv_2mortal(newSVpv(keyseqs[i], 0)));
              xfree(keyseqs[i]);
            }
            xfree((char *)keyseqs);
          } else {
            /* return null list */
          }
        }
#line 3302 "Gnu.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_print_keybinding); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_print_keybinding)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "name, map= rl_get_keymap(), readable= 0");
    {
	const char *	name = (const char *)SvPV_nolen(ST(0))
;
	Keymap	map;
	int	readable;

	if (items < 2)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(1)) && sv_derived_from(ST(1), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(1)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_print_keybinding",
			    "map", "Keymap",
			    refstr, ST(1)
		    );
	    }
;
	}

	if (items < 3)
	    readable = 0;
	else {
	    readable = (int)SvIV(ST(2))
;
	}
#line 2167 "Gnu.xs"
        rl_print_keybinding(name, map, readable);
#line 3347 "Gnu.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_function_dumper); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_function_dumper)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "readable= 0");
    {
	int	readable;

	if (items < 1)
	    readable = 0;
	else {
	    readable = (int)SvIV(ST(0))
;
	}

	rl_function_dumper(readable);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_list_funmap_names); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_list_funmap_names)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_list_funmap_names();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_all_function_names); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_all_function_names)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2182 "Gnu.xs"
        {
          int i, count;
          /* count number of entries */
          for (count = 0; funmap[count]; count++)
            ;

          EXTEND(sp, count);
          for (i = 0; i < count; i++) {
            PUSHs(sv_2mortal(newSVpv(funmap[i]->name, 0)));
          }
        }
#line 3410 "Gnu.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_funmap_names); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_funmap_names)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2198 "Gnu.xs"
        {
          const char **funmap;

          /* don't free returned memory */
          funmap = (const char **)rl_funmap_names();/* cast is for oldies */

          if (funmap) {
            int i, count;

            /* count number of entries */
            for (count = 0; funmap[count]; count++)
              ;

            EXTEND(sp, count);
            for (i = 0; i < count; i++) {
              PUSHs(sv_2mortal(newSVpv(funmap[i], 0)));
            }
          } else {
            /* return null list */
          }
        }
#line 3448 "Gnu.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_add_funmap_entry); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_add_funmap_entry)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "name, function");
    {
	CONST char *	name = (CONST char *)SvPV_nolen(ST(0))
;
	rl_command_func_t *	function;
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "rl_command_func_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    function = INT2PTR(rl_command_func_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_add_funmap_entry",
			"function", "rl_command_func_tPtr",
			refstr, ST(1)
		);
	}
;
#line 2226 "Gnu.xs"
        RETVAL = rl_add_funmap_entry(name, function);
#line 3483 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_begin_undo_group); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_begin_undo_group)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_begin_undo_group();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_end_undo_group); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_end_undo_group)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_end_undo_group();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_add_undo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_add_undo)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "what, start, end, text");
    {
	int	what = (int)SvIV(ST(0))
;
	int	start = (int)SvIV(ST(1))
;
	int	end = (int)SvIV(ST(2))
;
	char *	text = (char *)SvPV_nolen(ST(3))
;
#line 2245 "Gnu.xs"
        /* rl_free_undo_list will free the duplicated memory */
        rl_add_undo((enum undo_code)what, start, end, dupstr(text));
#line 3545 "Gnu.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_free_undo_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_free_undo_list)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_free_undo_list();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_do_undo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_do_undo)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_do_undo();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_modifying); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_modifying)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 2)
       croak_xs_usage(cv,  "start= 0, end= rl_end");
    {
	int	RETVAL;
	dXSTARG;
	int	start;
	int	end;

	if (items < 1)
	    start = 0;
	else {
	    start = (int)SvIV(ST(0))
;
	}

	if (items < 2)
	    end = rl_end;
	else {
	    end = (int)SvIV(ST(1))
;
	}

	RETVAL = rl_modifying(start, end);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_redisplay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_redisplay)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_redisplay();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_forced_update_display); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_forced_update_display)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_forced_update_display();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_on_new_line); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_on_new_line)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_on_new_line();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_on_new_line_with_prompt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_on_new_line_with_prompt)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_on_new_line_with_prompt();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_clear_visible_line); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_clear_visible_line)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_clear_visible_line();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_reset_line_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_reset_line_state)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_reset_line_state();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_show_char); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_show_char)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "i");
    {
	int	RETVAL;
	dXSTARG;
	int	i = (int)SvIV(ST(0))
;

	RETVAL = rl_show_char(i);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_message); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_message)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "text");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	text = (CONST char *)SvPV_nolen(ST(0))
;
#line 2295 "Gnu.xs"
        /* We need "%s" to suppress warnings, "format string is not a string literal" */
        RETVAL = rl_message("%s", text);
#line 3755 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_crlf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_crlf)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_crlf();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_clear_message); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_clear_message)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_clear_message();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_save_prompt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_save_prompt)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_save_prompt();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_restore_prompt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_restore_prompt)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_restore_prompt();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_expand_prompt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_expand_prompt)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "prompt");
    {
	int	RETVAL;
	dXSTARG;
	char *	prompt = (char *)SvPV_nolen(ST(0))
;

	RETVAL = rl_expand_prompt(prompt);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_set_prompt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_set_prompt)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "prompt");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	prompt = (CONST char *)SvPV_nolen(ST(0))
;

	RETVAL = rl_set_prompt(prompt);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_insert_text); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_insert_text)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "text");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	text = (CONST char *)SvPV_nolen(ST(0))
;

	RETVAL = rl_insert_text(text);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_delete_text); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_delete_text)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 2)
       croak_xs_usage(cv,  "start= 0, end= rl_end");
    {
	int	RETVAL;
	dXSTARG;
	int	start;
	int	end;

	if (items < 1)
	    start = 0;
	else {
	    start = (int)SvIV(ST(0))
;
	}

	if (items < 2)
	    end = rl_end;
	else {
	    end = (int)SvIV(ST(1))
;
	}

	RETVAL = rl_delete_text(start, end);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_copy_text); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_copy_text)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 2)
       croak_xs_usage(cv,  "start= 0, end= rl_end");
    {
	t_utf8_free	RETVAL;
	int	start;
	int	end;

	if (items < 1)
	    start = 0;
	else {
	    start = (int)SvIV(ST(0))
;
	}

	if (items < 2)
	    end = rl_end;
	else {
	    end = (int)SvIV(ST(1))
;
	}

	RETVAL = rl_copy_text(start, end);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL) {
	      sv_setpv(RETVALSV, RETVAL);
	      if (utf8_mode)
		sv_utf8_decode(RETVALSV);
	      xfree(RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_kill_text); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_kill_text)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 2)
       croak_xs_usage(cv,  "start= 0, end= rl_end");
    {
	int	RETVAL;
	dXSTARG;
	int	start;
	int	end;

	if (items < 1)
	    start = 0;
	else {
	    start = (int)SvIV(ST(0))
;
	}

	if (items < 2)
	    end = rl_end;
	else {
	    end = (int)SvIV(ST(1))
;
	}

	RETVAL = rl_kill_text(start, end);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_push_macro_input); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_push_macro_input)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "macro");
    {
	CONST char *	macro = (CONST char *)SvPV_nolen(ST(0))
;
#line 2349 "Gnu.xs"
        rl_push_macro_input(dupstr(macro));
#line 4008 "Gnu.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_read_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_read_key)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_read_key();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_getc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_getc)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "stream");
    {
	int	RETVAL;
	dXSTARG;
	FILE *	stream = PerlIO_findFILE(IoIFP(sv_2io(ST(0))))
;

	RETVAL = rl_getc(stream);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_stuff_char); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_stuff_char)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "c");
    {
	int	RETVAL;
	dXSTARG;
	int	c = (int)SvIV(ST(0))
;

	RETVAL = rl_stuff_char(c);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_execute_next); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_execute_next)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "c");
    {
	int	RETVAL;
	dXSTARG;
	int	c = (int)SvIV(ST(0))
;

	RETVAL = rl_execute_next(c);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_clear_pending_input); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_clear_pending_input)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_clear_pending_input();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_set_keyboard_input_timeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_set_keyboard_input_timeout)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "usec");
    {
	int	RETVAL;
	dXSTARG;
	int	usec = (int)SvIV(ST(0))
;

	RETVAL = rl_set_keyboard_input_timeout(usec);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_set_timeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_set_timeout)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "secs, usecs");
    {
	int	RETVAL;
	dXSTARG;
	unsigned int	secs = (unsigned int)SvUV(ST(0))
;
	unsigned int	usecs = (unsigned int)SvUV(ST(1))
;

	RETVAL = rl_set_timeout(secs, usecs);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_clear_timeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_clear_timeout)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_clear_timeout();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_timeout_remaining); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_timeout_remaining)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2390 "Gnu.xs"
        {
          int ret;
          U8 gimme = GIMME_V; /* https://perldoc.perl.org/perlcall#Using-GIMME_V */
          if (gimme == G_LIST) {
            unsigned int secs, usecs;
            ret = rl_timeout_remaining(&secs, &usecs);
            EXTEND(sp, 3);
            PUSHs(sv_2mortal(newSViv(ret)));
            PUSHs(sv_2mortal(newSViv(secs)));
            PUSHs(sv_2mortal(newSViv(usecs)));
          } else if (gimme == G_SCALAR) {
            ret = rl_timeout_remaining(NULL, NULL);
            EXTEND(sp, 1);
            PUSHs(sv_2mortal(newSViv(ret)));
          } else {  /* G_VOID */
            XSRETURN(0);
          }
        }
#line 4198 "Gnu.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_prep_terminal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_prep_terminal)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "meta_flag");
    {
	int	meta_flag = (int)SvIV(ST(0))
;

	rl_prep_terminal(meta_flag);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_deprep_terminal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_deprep_terminal)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_deprep_terminal();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_tty_set_default_bindings); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_tty_set_default_bindings)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "kmap= rl_get_keymap()");
    {
	Keymap	kmap;

	if (items < 1)
	    kmap = rl_get_keymap();
	else {
	    if (SvROK(ST(0)) && sv_derived_from(ST(0), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		kmap = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_tty_set_default_bindings",
			    "kmap", "Keymap",
			    refstr, ST(0)
		    );
	    }
;
	}
#line 2425 "Gnu.xs"
        rl_tty_set_default_bindings(kmap);
#line 4263 "Gnu.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_tty_unset_default_bindings); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_tty_unset_default_bindings)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "kmap= rl_get_keymap()");
    {
	Keymap	kmap;

	if (items < 1)
	    kmap = rl_get_keymap();
	else {
	    if (SvROK(ST(0)) && sv_derived_from(ST(0), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		kmap = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_tty_unset_default_bindings",
			    "kmap", "Keymap",
			    refstr, ST(0)
		    );
	    }
;
	}
#line 2431 "Gnu.xs"
        rl_tty_unset_default_bindings(kmap);
#line 4297 "Gnu.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_tty_set_echoing); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_tty_set_echoing)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	int	RETVAL;
	dXSTARG;
	int	value = (int)SvIV(ST(0))
;

	RETVAL = rl_tty_set_echoing(value);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_reset_terminal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_reset_terminal)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "terminal_name= NULL");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	terminal_name;

	if (items < 1)
	    terminal_name = NULL;
	else {
	    terminal_name = (CONST char *)SvPV_nolen(ST(0))
;
	}

	RETVAL = rl_reset_terminal(terminal_name);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_save_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_save_state)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	readline_state_t *	RETVAL;
#line 2448 "Gnu.xs"
    {
      readline_state_t *state;
      Newx(state, 1, readline_state_t);
      rl_save_state(state);
      RETVAL = state;
    }
#line 4364 "Gnu.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "readline_state_tPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_restore_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_restore_state)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "state");
    {
	int	RETVAL;
	dXSTARG;
	readline_state_t *	state;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "readline_state_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    state = INT2PTR(readline_state_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::rl_restore_state",
			"state", "readline_state_tPtr",
			refstr, ST(0)
		);
	}
;

	RETVAL = rl_restore_state(state);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_readline_state_tPtr_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_readline_state_tPtr_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "state");
    {
	readline_state_t *	state;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    state = INT2PTR(readline_state_t *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"readline_state_tPtr::DESTROY",
			"state")
;
#line 2465 "Gnu.xs"
    {
      Safefree(state);
    }
#line 4431 "Gnu.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_replace_line); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_replace_line)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "text, clear_undo= 0");
    {
	CONST char *	text = (CONST char *)SvPV_nolen(ST(0))
;
	int	clear_undo;

	if (items < 2)
	    clear_undo = 0;
	else {
	    clear_undo = (int)SvIV(ST(1))
;
	}

	rl_replace_line(text, clear_undo);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_initialize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_initialize)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2480 "Gnu.xs"
    {
      RETVAL = rl_initialize();
      /*
       * Perl optionally maintains its own envirnment variable array
       * using its own memory management functions.  On the other hand
       * the GNU Readline Library sets variables, $LINES and $COLUMNS,
       * by using the C library function putenv() in
       * rl_initialize(). When Perl frees the memory for the variables
       * during the destruction (perl.c:perl_destruct()), it may cause
       * segmentation faults.
       *
       * CPAN ticket #37194
       *   https://rt.cpan.org/Public/Bug/Display.html?id=37194
       *
       * To solve the problem, make a copy of the whole environment
       * variable array which might be reallocated by rl_initialize().
       */
      /* from perl.c:perl_destruct() */
#if defined(USE_ENVIRON_ARRAY) && !defined(PERL_USE_SAFE_PUTENV) \
  && !defined(PERL_DARWIN)
# if ((PERL_VERSION > 8) || (PERL_VERSION == 8 && PERL_SUBVERSION >= 6))
      /* Perl 5.8.6 introduced PL_use_safe_putenv. */
      if (environ != PL_origenviron && !PL_use_safe_putenv
#  else
      if (environ != PL_origenviron
#  endif
#  ifdef USE_ITHREADS
          /* only main thread can free environ[0] contents */
          && PL_curinterp == aTHX
#  endif
          ) {
        int i, len;
        char *s;
        char **tmpenv;
        for (i = 0; environ[i]; i++)
          ;
        /*
         * We cannot use New*() which uses safemalloc() instead of
         * safesysmalloc().
         */
        tmpenv = (char **)safesysmalloc((i+1)*sizeof(char *));
        for (i = 0; environ[i]; i++) {
          len = strlen(environ[i]);
          s = (char*)safesysmalloc((len+1)*sizeof(char));
          Copy(environ[i], s, len+1, char);
          tmpenv[i] = s;
        }
        tmpenv[i] = NULL;
        environ = tmpenv;
      }
#endif
    }
#line 4523 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_ding); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_ding)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_ding();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_alphabetic); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_alphabetic)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "c");
    {
	int	RETVAL;
	dXSTARG;
	int	c = (int)SvIV(ST(0))
;

	RETVAL = rl_alphabetic(c);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_display_match_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_display_match_list)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "pmatches, plen= -1, pmax= -1");
    {
	SV *	pmatches = ST(0)
;
	int	plen;
	int	pmax;

	if (items < 2)
	    plen = -1;
	else {
	    plen = (int)SvIV(ST(1))
;
	}

	if (items < 3)
	    pmax = -1;
	else {
	    pmax = (int)SvIV(ST(2))
;
	}
#line 2547 "Gnu.xs"
        {
          unsigned int len, max, i;
          STRLEN l;
          char **matches;
          AV *av_matches;
          SV **pvp;

          if (SvTYPE(SvRV(pmatches)) != SVt_PVAV) {
            warn("Gnu.xs:_rl_display_match_list: the 1st arguments must be a reference to an array\n");
            return;
          }
          av_matches = (AV *)SvRV(ST(0));
          /* index zero contains a possible match and is not counted */
          if ((len = av_len(av_matches) + 1 - 1) == 0)
            return;
          matches = (char **)xmalloc (sizeof(char *) * (len + 2));
          max = 0;
          for (i = 0; i <= len; i++) {
            pvp = av_fetch(av_matches, i, 0);
            if (SvPOKp(*pvp)) {
              matches[i] = dupstr(SvPV(*pvp, l));
              if (l > max)
                max = l;
            }
          }
          matches[len + 1] = NULL;

          rl_display_match_list(matches,
                                plen < 0 ? len : plen,
                                pmax < 0 ? max : pmax);

          for (i = 1; i <= len; i++)
            xfree(matches[i]);
          xfree(matches);
        }
#line 4630 "Gnu.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_macro_bind); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_macro_bind)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "keyseq, macro, map= rl_get_keymap()");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	keyseq = (CONST char *)SvPV_nolen(ST(0))
;
	CONST char *	macro = (CONST char *)SvPV_nolen(ST(1))
;
	Keymap	map;

	if (items < 3)
	    map = rl_get_keymap();
	else {
	    if (SvROK(ST(2)) && sv_derived_from(ST(2), "Keymap")) {
		IV tmp = SvIV((SV*)SvRV(ST(2)));
		map = INT2PTR(Keymap,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Term::ReadLine::Gnu::XS::_rl_macro_bind",
			    "map", "Keymap",
			    refstr, ST(2)
		    );
	    }
;
	}
#line 2595 "Gnu.xs"
        RETVAL = rl_macro_bind(keyseq, macro, map);
#line 4670 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_macro_dumper); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_macro_dumper)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "readable= 0");
    {
	int	readable;

	if (items < 1)
	    readable = 0;
	else {
	    readable = (int)SvIV(ST(0))
;
	}

	rl_macro_dumper(readable);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_variable_bind); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_variable_bind)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "name, value");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	name = (CONST char *)SvPV_nolen(ST(0))
;
	CONST char *	value = (CONST char *)SvPV_nolen(ST(1))
;

	RETVAL = rl_variable_bind(name, value);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_variable_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_variable_value)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "variable");
    {
	t_utf8	RETVAL;
	CONST char *	variable = (CONST char *)SvPV_nolen(ST(0))
;

	RETVAL = rl_variable_value(variable);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL) {
	      sv_setpv(RETVALSV, RETVAL);
	      if (utf8_mode)
		sv_utf8_decode(RETVALSV);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_variable_dumper); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_variable_dumper)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "readable= 0");
    {
	int	readable;

	if (items < 1)
	    readable = 0;
	else {
	    readable = (int)SvIV(ST(0))
;
	}

	rl_variable_dumper(readable);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_set_paren_blink_timeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_set_paren_blink_timeout)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "usec");
    {
	int	RETVAL;
	dXSTARG;
	int	usec = (int)SvIV(ST(0))
;

	RETVAL = rl_set_paren_blink_timeout(usec);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_termcap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_termcap)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cap");
    {
	char *	RETVAL;
	dXSTARG;
	CONST char *	cap = (CONST char *)SvPV_nolen(ST(0))
;

	RETVAL = rl_get_termcap(cap);
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_reparse_colors); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_reparse_colors)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_reparse_colors();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_callback_handler_install); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_callback_handler_install)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "prompt, lhandler");
    {
	CONST char *	prompt = (CONST char *)SvPV_nolen(ST(0))
;
	SV *	lhandler = ST(1)
;
#line 2649 "Gnu.xs"
        {
          static char *cb_prompt = NULL;
          int len = strlen(prompt) + 1;

          /* The value of prompt may be used after return from this routine. */
          if (cb_prompt) {
            Safefree(cb_prompt);
          }
          New(0, cb_prompt, len, char);
          Copy(prompt, cb_prompt, len, char);

          /*
           * Don't remove braces. The definition of SvSetSV() of
           * Perl 5.003 has a problem.
           */
          if (callback_handler_callback) {
            SvSetSV(callback_handler_callback, lhandler);
          } else {
            callback_handler_callback = newSVsv(lhandler);
          }

          rl_callback_handler_install(cb_prompt, callback_handler_wrapper);
        }
#line 4861 "Gnu.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_callback_read_char); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_callback_read_char)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_callback_read_char();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_callback_sigcleanup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_callback_sigcleanup)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_callback_sigcleanup();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_callback_handler_remove); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_callback_handler_remove)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_callback_handler_remove();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_pending_signal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_pending_signal)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_pending_signal();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_cleanup_after_signal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_cleanup_after_signal)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_cleanup_after_signal();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_free_line_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_free_line_state)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_free_line_state();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_reset_after_signal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_reset_after_signal)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_reset_after_signal();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_check_signals); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_check_signals)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_check_signals();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_echo_signal_char); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_echo_signal_char)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sig");
    {
	int	sig = (int)SvIV(ST(0))
;

	rl_echo_signal_char(sig);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_resize_terminal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_resize_terminal)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_resize_terminal();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_set_screen_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_set_screen_size)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "rows, cols");
    {
	int	rows = (int)SvIV(ST(0))
;
	int	cols = (int)SvIV(ST(1))
;

	rl_set_screen_size(rows, cols);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_screen_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_get_screen_size)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2725 "Gnu.xs"
        {
          int rows, cols;
          rl_get_screen_size(&rows, &cols);
          EXTEND(sp, 2);
          PUSHs(sv_2mortal(newSViv(rows)));
          PUSHs(sv_2mortal(newSViv(cols)));
        }
#line 5048 "Gnu.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_reset_screen_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_reset_screen_size)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_reset_screen_size();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_set_signals); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_set_signals)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_set_signals();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_clear_signals); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_clear_signals)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_clear_signals();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_complete_internal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_complete_internal)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "what_to_do= TAB");
    {
	int	RETVAL;
	dXSTARG;
	int	what_to_do;

	if (items < 1)
	    what_to_do = TAB;
	else {
	    what_to_do = (int)SvIV(ST(0))
;
	}

	RETVAL = rl_complete_internal(what_to_do);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_completion_mode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__rl_completion_mode)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "function");
    {
	int	RETVAL;
	dXSTARG;
	rl_command_func_t *	function;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "rl_command_func_tPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    function = INT2PTR(rl_command_func_t *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::_rl_completion_mode",
			"function", "rl_command_func_tPtr",
			refstr, ST(0)
		);
	}
;
#line 2757 "Gnu.xs"
        RETVAL = rl_completion_mode(function);
#line 5157 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_completion_matches); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_completion_matches)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "text, fn= NULL");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	CONST char *	text = (CONST char *)SvPV_nolen(ST(0))
;
	SV *	fn;

	if (items < 2)
	    fn = NULL;
	else {
	    fn = ST(1)
;
	}
#line 2765 "Gnu.xs"
        {
          char **matches;

          if (SvTRUE(fn)) {
            /* use completion_entry_function temporarily */
            XFunction *rlfunc_save = *(fn_tbl[CMP_ENT].rlfuncp); /* ??? */
            SV *callback_save = fn_tbl[CMP_ENT].callback;
            fn_tbl[CMP_ENT].callback = newSVsv(fn);

            matches = rl_completion_matches(text,
                                            completion_entry_function_wrapper);

            SvREFCNT_dec(fn_tbl[CMP_ENT].callback);
            fn_tbl[CMP_ENT].callback = callback_save;
            *(fn_tbl[CMP_ENT].rlfuncp) = rlfunc_save; /* ??? */
          } else
            matches = rl_completion_matches(text, NULL);

          /*
           * Without the next line the Perl internal stack is broken
           * under some condition.  Perl bug or undocumented feature
           * !!!?
           */
          SPAGAIN; sp -= 2;

          if (matches) {
            int i, count;

            /* count number of entries */
            for (count = 0; matches[count]; count++)
              ;

            EXTEND(sp, count);
            for (i = 0; i < count; i++) {
              PUSHs(sv_2mortal_utf8(newSVpv(matches[i], 0)));
              xfree(matches[i]);
            }
            xfree((char *)matches);
          } else {
            /* return null list */
          }
        }
#line 5227 "Gnu.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_filename_completion_function); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_filename_completion_function)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "text, state");
    {
	t_utf8_free	RETVAL;
	CONST char *	text = (CONST char *)SvPV_nolen(ST(0))
;
	int	state = (int)SvIV(ST(1))
;

	RETVAL = rl_filename_completion_function(text, state);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL) {
	      sv_setpv(RETVALSV, RETVAL);
	      if (utf8_mode)
		sv_utf8_decode(RETVALSV);
	      xfree(RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_username_completion_function); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_username_completion_function)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "text, state");
    {
	t_utf8_free	RETVAL;
	CONST char *	text = (CONST char *)SvPV_nolen(ST(0))
;
	int	state = (int)SvIV(ST(1))
;

	RETVAL = rl_username_completion_function(text, state);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL) {
	      sv_setpv(RETVALSV, RETVAL);
	      if (utf8_mode)
		sv_utf8_decode(RETVALSV);
	      xfree(RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_using_history); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_using_history)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	using_history();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_get_history_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_get_history_state)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HISTORY_STATE *	RETVAL;

	RETVAL = history_get_history_state();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "HISTORY_STATEPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_set_history_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_set_history_state)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "state");
    {
	HISTORY_STATE *	state;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "HISTORY_STATEPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    state = INT2PTR(HISTORY_STATE *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Term::ReadLine::Gnu::XS::history_set_history_state",
			"state", "HISTORY_STATEPtr",
			refstr, ST(0)
		);
	}
;

	history_set_history_state(state);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_HISTORY_STATEPtr_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_HISTORY_STATEPtr_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "state");
    {
	HISTORY_STATE *	state;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    state = INT2PTR(HISTORY_STATE *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"HISTORY_STATEPtr::DESTROY",
			"state")
;
#line 2842 "Gnu.xs"
    {
      xfree(state);
    }
#line 5380 "Gnu.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_add_history); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_add_history)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "string");
    {
	CONST char *	string = (CONST char *)SvPV_nolen(ST(0))
;

	add_history(string);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_add_history_time); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_add_history_time)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "string");
    {
	CONST char *	string = (CONST char *)SvPV_nolen(ST(0))
;

	add_history_time(string);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_remove_history); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_remove_history)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "which");
    {
	HIST_ENTRY *	RETVAL;
	int	which = (int)SvIV(ST(0))
;

	RETVAL = remove_history(which);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL && RETVAL->line) {
	      sv_setpv(RETVALSV, RETVAL->line);
	      if (utf8_mode)
		sv_utf8_decode(RETVALSV);
	    }
	    ST(0) = RETVALSV;
	}
#line 2867 "Gnu.xs"
        if (RETVAL) {
          xfree(RETVAL->line);
#if (RL_VERSION_MAJOR >= 5)
          xfree(RETVAL->timestamp);
#endif /* (RL_VERSION_MAJOR >= 5) */
          xfree(RETVAL->data);
          xfree((char *)RETVAL);
        }
#line 5449 "Gnu.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_replace_history_entry); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_replace_history_entry)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "which, line");
    {
	HIST_ENTRY *	RETVAL;
	int	which = (int)SvIV(ST(0))
;
	CONST char *	line = (CONST char *)SvPV_nolen(ST(1))
;
#line 2885 "Gnu.xs"
        RETVAL = replace_history_entry(which, line, (char *)NULL);
#line 5469 "Gnu.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL && RETVAL->line) {
	      sv_setpv(RETVALSV, RETVAL->line);
	      if (utf8_mode)
		sv_utf8_decode(RETVALSV);
	    }
	    ST(0) = RETVALSV;
	}
#line 2889 "Gnu.xs"
        if (RETVAL) {
          xfree(RETVAL->line);
#if (RL_VERSION_MAJOR >= 5)
          xfree(RETVAL->timestamp);
#endif /* (RL_VERSION_MAJOR >= 5) */
          xfree(RETVAL->data);
          xfree((char *)RETVAL);
        }
#line 5489 "Gnu.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_clear_history); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_clear_history)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	clear_history();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_activate_mark); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_activate_mark)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_activate_mark();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_deactivate_mark); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_deactivate_mark)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_deactivate_mark();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_keep_mark_active); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_keep_mark_active)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	rl_keep_mark_active();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_mark_active_p); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_rl_mark_active_p)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = rl_mark_active_p();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_stifle_history); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_stifle_history)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "i");
    {
	int	RETVAL;
	dXSTARG;
	SV *	i = ST(0)
;
#line 2922 "Gnu.xs"
        {
          if (SvOK(i)) {
            int max = SvIV(i);
            stifle_history(max);
            RETVAL = max;
          } else {
            RETVAL = unstifle_history();
          }
        }
#line 5590 "Gnu.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_unstifle_history); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_unstifle_history)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = unstifle_history();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_is_stifled); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_is_stifled)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = history_is_stifled();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_where_history); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_where_history)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = where_history();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_current_history); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_current_history)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HIST_ENTRY *	RETVAL;

	RETVAL = current_history();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL && RETVAL->line) {
	      sv_setpv(RETVALSV, RETVAL->line);
	      if (utf8_mode)
		sv_utf8_decode(RETVALSV);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_get); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_get)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "offset");
    {
	HIST_ENTRY *	RETVAL;
	int	offset = (int)SvIV(ST(0))
;

	RETVAL = history_get(offset);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL && RETVAL->line) {
	      sv_setpv(RETVALSV, RETVAL->line);
	      if (utf8_mode)
		sv_utf8_decode(RETVALSV);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_get_time); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_get_time)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "offset");
    {
	time_t	RETVAL;
	dXSTARG;
	int	offset = (int)SvIV(ST(0))
;
#line 2966 "Gnu.xs"
        {
          HIST_ENTRY *he = history_get(offset);
          if (he)
            RETVAL = history_get_time(he);
          else
            RETVAL = 0;
        }
#line 5723 "Gnu.c"
	XSprePUSH;
	PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_total_bytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_total_bytes)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = history_total_bytes();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_set_pos); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_set_pos)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pos");
    {
	int	RETVAL;
	dXSTARG;
	int	pos = (int)SvIV(ST(0))
;

	RETVAL = history_set_pos(pos);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_previous_history); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_previous_history)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HIST_ENTRY *	RETVAL;

	RETVAL = previous_history();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL && RETVAL->line) {
	      sv_setpv(RETVALSV, RETVAL->line);
	      if (utf8_mode)
		sv_utf8_decode(RETVALSV);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_next_history); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_next_history)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HIST_ENTRY *	RETVAL;

	RETVAL = next_history();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL && RETVAL->line) {
	      sv_setpv(RETVALSV, RETVAL->line);
	      if (utf8_mode)
		sv_utf8_decode(RETVALSV);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_search); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_search)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "string, direction= -1");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	string = (CONST char *)SvPV_nolen(ST(0))
;
	int	direction;

	if (items < 2)
	    direction = -1;
	else {
	    direction = (int)SvIV(ST(1))
;
	}

	RETVAL = history_search(string, direction);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_search_prefix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_search_prefix)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "string, direction= -1");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	string = (CONST char *)SvPV_nolen(ST(0))
;
	int	direction;

	if (items < 2)
	    direction = -1;
	else {
	    direction = (int)SvIV(ST(1))
;
	}

	RETVAL = history_search_prefix(string, direction);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_search_pos); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_search_pos)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "string, direction= -1, pos= where_history()");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	string = (CONST char *)SvPV_nolen(ST(0))
;
	int	direction;
	int	pos;

	if (items < 2)
	    direction = -1;
	else {
	    direction = (int)SvIV(ST(1))
;
	}

	if (items < 3)
	    pos = where_history();
	else {
	    pos = (int)SvIV(ST(2))
;
	}

	RETVAL = history_search_pos(string, direction, pos);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_read_history_range); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_read_history_range)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 3)
       croak_xs_usage(cv,  "filename= NULL, from= 0, to= -1");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	filename;
	int	from;
	int	to;

	if (items < 1)
	    filename = NULL;
	else {
	    filename = (CONST char *)SvPV_nolen(ST(0))
;
	}

	if (items < 2)
	    from = 0;
	else {
	    from = (int)SvIV(ST(1))
;
	}

	if (items < 3)
	    to = -1;
	else {
	    to = (int)SvIV(ST(2))
;
	}

	RETVAL = read_history_range(filename, from, to);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_write_history); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_write_history)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "filename= NULL");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	filename;

	if (items < 1)
	    filename = NULL;
	else {
	    filename = (CONST char *)SvPV_nolen(ST(0))
;
	}

	RETVAL = write_history(filename);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_append_history); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_append_history)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "nelements, filename= NULL");
    {
	int	RETVAL;
	dXSTARG;
	int	nelements = (int)SvIV(ST(0))
;
	CONST char *	filename;

	if (items < 2)
	    filename = NULL;
	else {
	    filename = (CONST char *)SvPV_nolen(ST(1))
;
	}

	RETVAL = append_history(nelements, filename);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_truncate_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_truncate_file)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 2)
       croak_xs_usage(cv,  "filename= NULL, nlines= 0");
    {
	int	RETVAL;
	dXSTARG;
	CONST char *	filename;
	int	nlines;

	if (items < 1)
	    filename = NULL;
	else {
	    filename = (CONST char *)SvPV_nolen(ST(0))
;
	}

	if (items < 2)
	    nlines = 0;
	else {
	    nlines = (int)SvIV(ST(1))
;
	}

	RETVAL = history_truncate_file(filename, nlines);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_expand); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_expand)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "line");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	line = (char *)SvPV_nolen(ST(0))
;
#line 3038 "Gnu.xs"
        {
          char *expansion;
          int result;

          result = history_expand(line, &expansion);
          EXTEND(sp, 2);
          PUSHs(sv_2mortal(newSViv(result)));
          PUSHs(sv_2mortal_utf8(newSVpv(expansion, 0)));
          xfree(expansion);
        }
#line 6063 "Gnu.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS__get_history_event); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__get_history_event)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "string, cindex, qchar= 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	CONST char *	string = (CONST char *)SvPV_nolen(ST(0))
;
	int	cindex = (int)SvIV(ST(1))
;
	int	qchar;

	if (items < 3)
	    qchar = 0;
	else {
	    qchar = (int)SvIV(ST(2))
;
	}
#line 3053 "Gnu.xs"
        {
          char *text;

          text = get_history_event(string, &cindex, qchar);
          EXTEND(sp, 2);
          if (text) {           /* don't free `text' */
            PUSHs(sv_2mortal_utf8(newSVpv(text, 0)));
          } else {
            PUSHs(&PL_sv_undef);
          }
          PUSHs(sv_2mortal(newSViv(cindex)));
        }
#line 6104 "Gnu.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_tokenize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_history_tokenize)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "text");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	CONST char *	text = (CONST char *)SvPV_nolen(ST(0))
;
#line 3070 "Gnu.xs"
        {
          char **tokens;

          tokens = history_tokenize(text);
          if (tokens) {
            int i, count;

            /* count number of entries */
            for (count = 0; tokens[count]; count++)
              ;

            EXTEND(sp, count);
            for (i = 0; i < count; i++) {
              PUSHs(sv_2mortal_utf8(newSVpv(tokens[i], 0)));
              xfree(tokens[i]);
            }
            xfree((char *)tokens);
          } else {
            /* return null list */
          }
        }
#line 6144 "Gnu.c"
	PUTBACK;
	return;
    }
}

#define DALLAR '$'              /* define for xsubpp bug */

XS_EUPXS(XS_Term__ReadLine__Gnu__XS__history_arg_extract); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS__history_arg_extract)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "line, first= 0, last= DALLAR");
    {
	t_utf8_free	RETVAL;
	CONST char *	line = (CONST char *)SvPV_nolen(ST(0))
;
	int	first;
	int	last;

	if (items < 2)
	    first = 0;
	else {
	    first = (int)SvIV(ST(1))
;
	}

	if (items < 3)
	    last = DALLAR;
	else {
	    last = (int)SvIV(ST(2))
;
	}
#line 3098 "Gnu.xs"
        RETVAL = history_arg_extract(first, last, line);
#line 6180 "Gnu.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL) {
	      sv_setpv(RETVALSV, RETVAL);
	      if (utf8_mode)
		sv_utf8_decode(RETVALSV);
	      xfree(RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_store_str); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_store_str)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pstr, id");
    {
	CONST char *	pstr = (CONST char *)SvPV_nolen(ST(0))
;
	int	id = (int)SvIV(ST(1))
;
#line 3113 "Gnu.xs"
        {
          size_t len;

          ST(0) = sv_newmortal();
          if (id < 0 || id >= sizeof(str_tbl)/sizeof(struct str_vars)) {
            warn("Gnu.xs:_rl_store_str: Illegal `id' value: `%d'", id);
            XSRETURN_UNDEF;
          }

          if (str_tbl[id].read_only) {
            warn("Gnu.xs:_rl_store_str: store to read only variable");
            XSRETURN_UNDEF;
          }

          /*
           * Use xmalloc() and xfree() instead of New() and Safefree(),
           * because this block may be reallocated by the GNU Readline Library.
           */
          if (str_tbl[id].accessed && *str_tbl[id].var) {
            /*
             * First time a variable is used by this routine,
             * it may be a static area.  So it cannot be freed.
             */
            xfree(*str_tbl[id].var);
            *str_tbl[id].var = NULL;
          }
          str_tbl[id].accessed = 1;

          /*printf("%d: %s\n", id, pstr);*/
          len = strlen(pstr) + 1;
          *str_tbl[id].var = xmalloc(len);
          Copy(pstr, *str_tbl[id].var, len, char);

          /* return variable value */
          if (*str_tbl[id].var) {
            sv_setpv(ST(0), *str_tbl[id].var);
          }
        }
#line 6247 "Gnu.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_store_rl_line_buffer); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_store_rl_line_buffer)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pstr");
    {
	CONST char *	pstr = (CONST char *)SvPV_nolen(ST(0))
;
#line 3156 "Gnu.xs"
        {
          size_t len;

          ST(0) = sv_newmortal();
          if (pstr) {
            len = strlen(pstr);

            /*
             * Old manual did not document this function, but can be
             * used.
             */
            rl_extend_line_buffer(len + 1);

            Copy(pstr, rl_line_buffer, len + 1, char);
            /* rl_line_buffer is not NULL here */
            sv_setpv(ST(0), rl_line_buffer);

            /* fix rl_end and rl_point */
            rl_end = len;
            if (rl_point > len)
                    rl_point = len;
          }
        }
#line 6286 "Gnu.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_fetch_str); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_fetch_str)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "id");
    {
	int	id = (int)SvIV(ST(0))
;
#line 3184 "Gnu.xs"
        {
          ST(0) = sv_newmortal();
          if (id < 0 || id >= sizeof(str_tbl)/sizeof(struct str_vars)) {
            warn("Gnu.xs:_rl_fetch_str: Illegal `id' value: `%d'", id);
          } else {
            if (*(str_tbl[id].var)) {
              sv_setpv(ST(0), *(str_tbl[id].var));
              if (utf8_mode) {
                sv_utf8_decode(ST(0));
              }
            }
          }
        }
#line 6315 "Gnu.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_store_int); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_store_int)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pint, id");
    {
	int	pint = (int)SvIV(ST(0))
;
	int	id = (int)SvIV(ST(1))
;
#line 3202 "Gnu.xs"
        {
          ST(0) = sv_newmortal();
          if (id < 0 || id >= sizeof(int_tbl)/sizeof(struct int_vars)) {
            warn("Gnu.xs:_rl_store_int: Illegal `id' value: `%d'", id);
            XSRETURN_UNDEF;
          }

          if (int_tbl[id].read_only) {
            warn("Gnu.xs:_rl_store_int: store to read only variable");
            XSRETURN_UNDEF;
          }

          /* set C variable */
          if (int_tbl[id].charp)
            *((char *)(int_tbl[id].var)) = (char)pint;
          else if (int_tbl[id].ulong)
            *((unsigned long *)(int_tbl[id].var)) = (unsigned long)pint;
          else
            *(int_tbl[id].var) = pint;

          /* return variable value */
          sv_setiv(ST(0), pint);
        }
#line 6356 "Gnu.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_fetch_int); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_fetch_int)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "id");
    {
	int	id = (int)SvIV(ST(0))
;
#line 3230 "Gnu.xs"
        {
          ST(0) = sv_newmortal();
          if (id < 0 || id >= sizeof(int_tbl)/sizeof(struct int_vars)) {
            warn("Gnu.xs:_rl_fetch_int: Illegal `id' value: `%d'", id);
            /* return undef */
          } else {
              if (int_tbl[id].charp)
                  sv_setiv(ST(0),
                           (int)*((char *)(int_tbl[id].var)));
              else if (int_tbl[id].ulong)
                  sv_setiv(ST(0),
                           (int)*((unsigned long *)(int_tbl[id].var)));
              else
                  sv_setiv(ST(0),
                           *(int_tbl[id].var));
          }
        }
#line 6389 "Gnu.c"
    }
    XSRETURN(1);
}

#if 1   /* http://perldoc.perl.org/perlxs.html#Inserting-POD%2c-Comments-and-C-Preprocessor-Directives */
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_store_iostream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_store_iostream)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "stream, id");
    {
	FILE *	stream = PerlIO_findFILE(IoIFP(sv_2io(ST(0))))
;
	int	id = (int)SvIV(ST(1))
;
#line 3254 "Gnu.xs"
        {
          switch (id) {
          case 0:
            rl_instream = stream;
            break;
          case 1:
            rl_outstream = stream;
#ifdef __CYGWIN__
            {
              /* Cygwin b20.1 library converts NL to CR-NL
                 automatically.  But it does not do it on a file
                 stream made by Perl.  Set terminal attribute
                 explicitly */
                struct termios tio;
                tcgetattr(fileno(rl_outstream), &tio);
                tio.c_iflag |= ICRNL;
                tio.c_oflag |= ONLCR;
                tcsetattr(fileno(rl_outstream), TCSADRAIN, &tio);
            }
#endif /* __CYGWIN__ */
            break;
          default:
            warn("Gnu.xs:_rl_store_iostream: Illegal `id' value: `%d'", id);
            break;
          }
          PerlIO_debug("TRG:store_iostream id %d fd %d\n",
                       id, fileno(stream));
        }
#line 6438 "Gnu.c"
    }
    XSRETURN_EMPTY;
}

#else /* 2016/06/07 worked but no advantage */
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_store_iostream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_store_iostream)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "iop, id");
    {
	PerlIO *	iop = IoIFP(sv_2io(ST(0)))
;
	int	id = (int)SvIV(ST(1))
;
#line 3289 "Gnu.xs"
        {
          int fd = -1;
          switch (id) {
          case 0:
            perlio_in = iop;
            rl_instream = PerlIO_findFILE(iop);
            fd = fileno(rl_instream);
            break;
          case 1:
            perlio_out = iop;
            rl_outstream = PerlIO_findFILE(iop);
            fd = fileno(rl_outstream);
#ifdef __CYGWIN__
            {
              /* Cygwin b20.1 library converts NL to CR-NL
                 automatically.  But it does not do it on a file
                 stream made by Perl.  Set terminal attribute
                 explicitly */
                struct termios tio;
                tcgetattr(fd, &tio);
                tio.c_iflag |= ICRNL;
                tio.c_oflag |= ONLCR;
                tcsetattr(fd, TCSADRAIN, &tio);
            }
#endif /* __CYGWIN__ */
            break;
          default:
            warn("Gnu.xs:_rl_store_iostream: Illegal `id' value: `%d'", id);
            break;
          }
          PerlIO_debug("TRG:store_iostream id %d fd %d\n",
                       id, fd);
        }
#line 6492 "Gnu.c"
    }
    XSRETURN_EMPTY;
}

#endif
#if 0 /* not used since 1.26 */
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_fetch_iostream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_fetch_iostream)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "id");
    {
	PerlIO *	RETVAL;
	int	id = (int)SvIV(ST(0))
;
#line 3331 "Gnu.xs"
        {
          switch (id) {
          case 0:
            if (instreamPIO == NULL)
              RETVAL = instreamPIO = PerlIO_importFILE(rl_instream, NULL);
            else
              RETVAL = instreamPIO;
            break;
          case 1:
            if (outstreamPIO == NULL)
              RETVAL = outstreamPIO = PerlIO_importFILE(rl_outstream, NULL);
            else
              RETVAL = outstreamPIO;
            break;
          default:
            warn("Gnu.xs:_rl_fetch_iostream: Illegal `id' value: `%d'", id);
            XSRETURN_UNDEF;
            break;
          }
          PerlIO_debug("TRG:fetch_iostream id %d fd %d\n",
                       id, PerlIO_fileno(RETVAL));
        }
#line 6535 "Gnu.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		gv_init_pvn(gv, gv_stashpvs("Term::ReadLine::Gnu::Var",1),"__ANONIO__",10,0);
		if ( do_open(gv, "+<&", 3, FALSE, 0, 0, RETVAL) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_fetch_keymap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_fetch_keymap)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "id");
    {
	Keymap	RETVAL;
	int	id = (int)SvIV(ST(0))
;
#line 3362 "Gnu.xs"
        {
          switch (id) {
          case 0:
            RETVAL = rl_executing_keymap;
            break;
          case 1:
            RETVAL = rl_binding_keymap;
            break;
          default:
            warn("Gnu.xs:_rl_fetch_keymap: Illegal `id' value: `%d'", id);
            XSRETURN_UNDEF;
            break;
          }
        }
#line 6581 "Gnu.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Keymap", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_store_function); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_store_function)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "fn, id");
    {
	SV *	fn = ST(0)
;
	int	id = (int)SvIV(ST(1))
;
#line 3383 "Gnu.xs"
        {
          /*
           * If "fn" is undef, default value of the GNU Readline
           * Library is set.
           */
          ST(0) = sv_newmortal();
          if (id < 0 || id >= sizeof(fn_tbl)/sizeof(struct fn_vars)) {
            warn("Gnu.xs:_rl_store_function: Illegal `id' value: `%d'", id);
            XSRETURN_UNDEF;
          }

          if (SvTRUE(fn)) {
            /*
             * Don't remove braces. The definition of SvSetSV() of
             * Perl 5.003 has a problem.
             */
            if (fn_tbl[id].callback) {
              SvSetSV(fn_tbl[id].callback, fn);
            } else {
              fn_tbl[id].callback = newSVsv(fn);
            }
            *(fn_tbl[id].rlfuncp) = fn_tbl[id].wrapper;
          } else {
            if (fn_tbl[id].callback) {
              SvSetSV(fn_tbl[id].callback, &PL_sv_undef);
            }
            *(fn_tbl[id].rlfuncp) = fn_tbl[id].defaultfn;
          }

          /* return variable value */
          sv_setsv(ST(0), fn);
        }
#line 6637 "Gnu.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_fetch_function); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_fetch_function)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "id");
    {
	int	id = (int)SvIV(ST(0))
;
#line 3420 "Gnu.xs"
        {
          ST(0) = sv_newmortal();
          if (id < 0 || id >= sizeof(fn_tbl)/sizeof(struct fn_vars)) {
            warn("Gnu.xs:_rl_fetch_function: Illegal `id' value: `%d'", id);
            /* return undef */
          } else if (fn_tbl[id].callback && SvTRUE(fn_tbl[id].callback)) {
            sv_setsv(ST(0), fn_tbl[id].callback);
          }
        }
#line 6662 "Gnu.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_fetch_last_func); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__Var__rl_fetch_last_func)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	rl_command_func_t *	RETVAL;
#line 3434 "Gnu.xs"
        RETVAL = rl_last_func;
#line 6678 "Gnu.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "rl_command_func_tPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Term__ReadLine__Gnu__XS_tgetstr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Term__ReadLine__Gnu__XS_tgetstr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "id");
    {
	const char *	id = (const char *)SvPV_nolen(ST(0))
;
#line 3444 "Gnu.xs"
        ST(0) = sv_newmortal();
        if (id) {
          /*
           * The magic number `2032' is derived from bash
           * terminal.c:_rl_init_terminal_io().
           */
          char buffer[2032];
          char *bp = buffer;
          char *t;
          t = tgetstr(id, &bp); /* don't free returned string */
          if (t) {
            char buf[2032];
            /* call tputs() to apply padding information */
            tputs_ptr = buf;
            tputs(t, 1, tputs_char);
            *tputs_ptr = '\0';
            sv_setpv(ST(0), buf);
          }
        }
#line 6719 "Gnu.c"
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Term__ReadLine__Gnu); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Term__ReadLine__Gnu)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_readline", XS_Term__ReadLine__Gnu__XS_rl_readline, file, ";$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_add_defun", XS_Term__ReadLine__Gnu__XS_rl_add_defun, file, "$$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_make_bare_keymap", XS_Term__ReadLine__Gnu__XS_rl_make_bare_keymap, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_copy_keymap", XS_Term__ReadLine__Gnu__XS__rl_copy_keymap, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_make_keymap", XS_Term__ReadLine__Gnu__XS_rl_make_keymap, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_discard_keymap", XS_Term__ReadLine__Gnu__XS__rl_discard_keymap, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_free_keymap", XS_Term__ReadLine__Gnu__XS__rl_free_keymap, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_empty_keymap", XS_Term__ReadLine__Gnu__XS__rl_empty_keymap, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_get_keymap", XS_Term__ReadLine__Gnu__XS_rl_get_keymap, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_set_keymap", XS_Term__ReadLine__Gnu__XS__rl_set_keymap, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_get_keymap_by_name", XS_Term__ReadLine__Gnu__XS_rl_get_keymap_by_name, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_get_keymap_name", XS_Term__ReadLine__Gnu__XS_rl_get_keymap_name, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_set_keymap_name", XS_Term__ReadLine__Gnu__XS__rl_set_keymap_name, file, "$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_bind_key", XS_Term__ReadLine__Gnu__XS__rl_bind_key, file, "$$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_bind_key_if_unbound", XS_Term__ReadLine__Gnu__XS__rl_bind_key_if_unbound, file, "$$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_unbind_key", XS_Term__ReadLine__Gnu__XS__rl_unbind_key, file, "$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_unbind_function", XS_Term__ReadLine__Gnu__XS__rl_unbind_function, file, "$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_unbind_command", XS_Term__ReadLine__Gnu__XS__rl_unbind_command, file, "$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_bind_keyseq", XS_Term__ReadLine__Gnu__XS__rl_bind_keyseq, file, "$$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_set_key", XS_Term__ReadLine__Gnu__XS__rl_set_key, file, "$$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_bind_keyseq_if_unbound", XS_Term__ReadLine__Gnu__XS__rl_bind_keyseq_if_unbound, file, "$$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_generic_bind_function", XS_Term__ReadLine__Gnu__XS__rl_generic_bind_function, file, "$$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_generic_bind_keymap", XS_Term__ReadLine__Gnu__XS__rl_generic_bind_keymap, file, "$$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_generic_bind_macro", XS_Term__ReadLine__Gnu__XS__rl_generic_bind_macro, file, "$$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_parse_and_bind", XS_Term__ReadLine__Gnu__XS_rl_parse_and_bind, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_read_init_file", XS_Term__ReadLine__Gnu__XS_rl_read_init_file, file, ";$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_call_function", XS_Term__ReadLine__Gnu__XS__rl_call_function, file, "$;$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_named_function", XS_Term__ReadLine__Gnu__XS_rl_named_function, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_get_function_name", XS_Term__ReadLine__Gnu__XS_rl_get_function_name, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_function_of_keyseq", XS_Term__ReadLine__Gnu__XS__rl_function_of_keyseq, file, "$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_trim_arg_from_keyseq", XS_Term__ReadLine__Gnu__XS__rl_trim_arg_from_keyseq, file, "$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_invoking_keyseqs", XS_Term__ReadLine__Gnu__XS__rl_invoking_keyseqs, file, "$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_print_keybinding", XS_Term__ReadLine__Gnu__XS__rl_print_keybinding, file, "$;$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_function_dumper", XS_Term__ReadLine__Gnu__XS_rl_function_dumper, file, ";$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_list_funmap_names", XS_Term__ReadLine__Gnu__XS_rl_list_funmap_names, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_get_all_function_names", XS_Term__ReadLine__Gnu__XS_rl_get_all_function_names, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_funmap_names", XS_Term__ReadLine__Gnu__XS_rl_funmap_names, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_add_funmap_entry", XS_Term__ReadLine__Gnu__XS__rl_add_funmap_entry, file, "$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_begin_undo_group", XS_Term__ReadLine__Gnu__XS_rl_begin_undo_group, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_end_undo_group", XS_Term__ReadLine__Gnu__XS_rl_end_undo_group, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_add_undo", XS_Term__ReadLine__Gnu__XS_rl_add_undo, file, "$$$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_free_undo_list", XS_Term__ReadLine__Gnu__XS_rl_free_undo_list, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_do_undo", XS_Term__ReadLine__Gnu__XS_rl_do_undo, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_modifying", XS_Term__ReadLine__Gnu__XS_rl_modifying, file, ";$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_redisplay", XS_Term__ReadLine__Gnu__XS_rl_redisplay, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_forced_update_display", XS_Term__ReadLine__Gnu__XS_rl_forced_update_display, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_on_new_line", XS_Term__ReadLine__Gnu__XS_rl_on_new_line, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_on_new_line_with_prompt", XS_Term__ReadLine__Gnu__XS_rl_on_new_line_with_prompt, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_clear_visible_line", XS_Term__ReadLine__Gnu__XS_rl_clear_visible_line, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_reset_line_state", XS_Term__ReadLine__Gnu__XS_rl_reset_line_state, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_show_char", XS_Term__ReadLine__Gnu__XS_rl_show_char, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_message", XS_Term__ReadLine__Gnu__XS__rl_message, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_crlf", XS_Term__ReadLine__Gnu__XS_rl_crlf, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_clear_message", XS_Term__ReadLine__Gnu__XS_rl_clear_message, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_save_prompt", XS_Term__ReadLine__Gnu__XS_rl_save_prompt, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_restore_prompt", XS_Term__ReadLine__Gnu__XS_rl_restore_prompt, file, "");
        newXS_deffile("Term::ReadLine::Gnu::XS::rl_expand_prompt", XS_Term__ReadLine__Gnu__XS_rl_expand_prompt);
        newXS_deffile("Term::ReadLine::Gnu::XS::rl_set_prompt", XS_Term__ReadLine__Gnu__XS_rl_set_prompt);
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_insert_text", XS_Term__ReadLine__Gnu__XS_rl_insert_text, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_delete_text", XS_Term__ReadLine__Gnu__XS_rl_delete_text, file, ";$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_copy_text", XS_Term__ReadLine__Gnu__XS_rl_copy_text, file, ";$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_kill_text", XS_Term__ReadLine__Gnu__XS_rl_kill_text, file, ";$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_push_macro_input", XS_Term__ReadLine__Gnu__XS_rl_push_macro_input, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_read_key", XS_Term__ReadLine__Gnu__XS_rl_read_key, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_getc", XS_Term__ReadLine__Gnu__XS_rl_getc, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_stuff_char", XS_Term__ReadLine__Gnu__XS_rl_stuff_char, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_execute_next", XS_Term__ReadLine__Gnu__XS_rl_execute_next, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_clear_pending_input", XS_Term__ReadLine__Gnu__XS_rl_clear_pending_input, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_set_keyboard_input_timeout", XS_Term__ReadLine__Gnu__XS_rl_set_keyboard_input_timeout, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_set_timeout", XS_Term__ReadLine__Gnu__XS_rl_set_timeout, file, "$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_clear_timeout", XS_Term__ReadLine__Gnu__XS_rl_clear_timeout, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_timeout_remaining", XS_Term__ReadLine__Gnu__XS_rl_timeout_remaining, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_prep_terminal", XS_Term__ReadLine__Gnu__XS_rl_prep_terminal, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_deprep_terminal", XS_Term__ReadLine__Gnu__XS_rl_deprep_terminal, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_tty_set_default_bindings", XS_Term__ReadLine__Gnu__XS__rl_tty_set_default_bindings, file, ";$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_tty_unset_default_bindings", XS_Term__ReadLine__Gnu__XS__rl_tty_unset_default_bindings, file, ";$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_tty_set_echoing", XS_Term__ReadLine__Gnu__XS_rl_tty_set_echoing, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_reset_terminal", XS_Term__ReadLine__Gnu__XS_rl_reset_terminal, file, ";$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_save_state", XS_Term__ReadLine__Gnu__XS_rl_save_state, file, "");
        newXS_deffile("Term::ReadLine::Gnu::XS::rl_restore_state", XS_Term__ReadLine__Gnu__XS_rl_restore_state);
        newXS_deffile("readline_state_tPtr::DESTROY", XS_readline_state_tPtr_DESTROY);
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_replace_line", XS_Term__ReadLine__Gnu__XS_rl_replace_line, file, "$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_initialize", XS_Term__ReadLine__Gnu__XS_rl_initialize, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_ding", XS_Term__ReadLine__Gnu__XS_rl_ding, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_alphabetic", XS_Term__ReadLine__Gnu__XS_rl_alphabetic, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_display_match_list", XS_Term__ReadLine__Gnu__XS_rl_display_match_list, file, "$;$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_macro_bind", XS_Term__ReadLine__Gnu__XS__rl_macro_bind, file, "$$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_macro_dumper", XS_Term__ReadLine__Gnu__XS_rl_macro_dumper, file, ";$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_variable_bind", XS_Term__ReadLine__Gnu__XS_rl_variable_bind, file, "$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_variable_value", XS_Term__ReadLine__Gnu__XS_rl_variable_value, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_variable_dumper", XS_Term__ReadLine__Gnu__XS_rl_variable_dumper, file, ";$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_set_paren_blink_timeout", XS_Term__ReadLine__Gnu__XS_rl_set_paren_blink_timeout, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_get_termcap", XS_Term__ReadLine__Gnu__XS_rl_get_termcap, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_reparse_colors", XS_Term__ReadLine__Gnu__XS_rl_reparse_colors, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_callback_handler_install", XS_Term__ReadLine__Gnu__XS_rl_callback_handler_install, file, "$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_callback_read_char", XS_Term__ReadLine__Gnu__XS_rl_callback_read_char, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_callback_sigcleanup", XS_Term__ReadLine__Gnu__XS_rl_callback_sigcleanup, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_callback_handler_remove", XS_Term__ReadLine__Gnu__XS_rl_callback_handler_remove, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_pending_signal", XS_Term__ReadLine__Gnu__XS_rl_pending_signal, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_cleanup_after_signal", XS_Term__ReadLine__Gnu__XS_rl_cleanup_after_signal, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_free_line_state", XS_Term__ReadLine__Gnu__XS_rl_free_line_state, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_reset_after_signal", XS_Term__ReadLine__Gnu__XS_rl_reset_after_signal, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_check_signals", XS_Term__ReadLine__Gnu__XS_rl_check_signals, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_echo_signal_char", XS_Term__ReadLine__Gnu__XS_rl_echo_signal_char, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_resize_terminal", XS_Term__ReadLine__Gnu__XS_rl_resize_terminal, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_set_screen_size", XS_Term__ReadLine__Gnu__XS_rl_set_screen_size, file, "$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_get_screen_size", XS_Term__ReadLine__Gnu__XS_rl_get_screen_size, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_reset_screen_size", XS_Term__ReadLine__Gnu__XS_rl_reset_screen_size, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_set_signals", XS_Term__ReadLine__Gnu__XS_rl_set_signals, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_clear_signals", XS_Term__ReadLine__Gnu__XS_rl_clear_signals, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_complete_internal", XS_Term__ReadLine__Gnu__XS_rl_complete_internal, file, ";$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_rl_completion_mode", XS_Term__ReadLine__Gnu__XS__rl_completion_mode, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_completion_matches", XS_Term__ReadLine__Gnu__XS_rl_completion_matches, file, "$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_filename_completion_function", XS_Term__ReadLine__Gnu__XS_rl_filename_completion_function, file, "$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_username_completion_function", XS_Term__ReadLine__Gnu__XS_rl_username_completion_function, file, "$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::using_history", XS_Term__ReadLine__Gnu__XS_using_history, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::history_get_history_state", XS_Term__ReadLine__Gnu__XS_history_get_history_state, file, "");
        newXS_deffile("Term::ReadLine::Gnu::XS::history_set_history_state", XS_Term__ReadLine__Gnu__XS_history_set_history_state);
        newXS_deffile("HISTORY_STATEPtr::DESTROY", XS_HISTORY_STATEPtr_DESTROY);
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::add_history", XS_Term__ReadLine__Gnu__XS_add_history, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::add_history_time", XS_Term__ReadLine__Gnu__XS_add_history_time, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::remove_history", XS_Term__ReadLine__Gnu__XS_remove_history, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::replace_history_entry", XS_Term__ReadLine__Gnu__XS_replace_history_entry, file, "$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::clear_history", XS_Term__ReadLine__Gnu__XS_clear_history, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_activate_mark", XS_Term__ReadLine__Gnu__XS_rl_activate_mark, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_deactivate_mark", XS_Term__ReadLine__Gnu__XS_rl_deactivate_mark, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_keep_mark_active", XS_Term__ReadLine__Gnu__XS_rl_keep_mark_active, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::rl_mark_active_p", XS_Term__ReadLine__Gnu__XS_rl_mark_active_p, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::stifle_history", XS_Term__ReadLine__Gnu__XS_stifle_history, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::unstifle_history", XS_Term__ReadLine__Gnu__XS_unstifle_history, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::history_is_stifled", XS_Term__ReadLine__Gnu__XS_history_is_stifled, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::where_history", XS_Term__ReadLine__Gnu__XS_where_history, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::current_history", XS_Term__ReadLine__Gnu__XS_current_history, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::history_get", XS_Term__ReadLine__Gnu__XS_history_get, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::history_get_time", XS_Term__ReadLine__Gnu__XS_history_get_time, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::history_total_bytes", XS_Term__ReadLine__Gnu__XS_history_total_bytes, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::history_set_pos", XS_Term__ReadLine__Gnu__XS_history_set_pos, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::previous_history", XS_Term__ReadLine__Gnu__XS_previous_history, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::next_history", XS_Term__ReadLine__Gnu__XS_next_history, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::history_search", XS_Term__ReadLine__Gnu__XS_history_search, file, "$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::history_search_prefix", XS_Term__ReadLine__Gnu__XS_history_search_prefix, file, "$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::history_search_pos", XS_Term__ReadLine__Gnu__XS_history_search_pos, file, "$;$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::read_history_range", XS_Term__ReadLine__Gnu__XS_read_history_range, file, ";$$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::write_history", XS_Term__ReadLine__Gnu__XS_write_history, file, ";$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::append_history", XS_Term__ReadLine__Gnu__XS_append_history, file, "$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::history_truncate_file", XS_Term__ReadLine__Gnu__XS_history_truncate_file, file, ";$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::history_expand", XS_Term__ReadLine__Gnu__XS_history_expand, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_get_history_event", XS_Term__ReadLine__Gnu__XS__get_history_event, file, "$$;$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::history_tokenize", XS_Term__ReadLine__Gnu__XS_history_tokenize, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::_history_arg_extract", XS_Term__ReadLine__Gnu__XS__history_arg_extract, file, "$;$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::Var::_rl_store_str", XS_Term__ReadLine__Gnu__Var__rl_store_str, file, "$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::Var::_rl_store_rl_line_buffer", XS_Term__ReadLine__Gnu__Var__rl_store_rl_line_buffer, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::Var::_rl_fetch_str", XS_Term__ReadLine__Gnu__Var__rl_fetch_str, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::Var::_rl_store_int", XS_Term__ReadLine__Gnu__Var__rl_store_int, file, "$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::Var::_rl_fetch_int", XS_Term__ReadLine__Gnu__Var__rl_fetch_int, file, "$");
#if XSubPPtmpAAAA
        (void)newXSproto_portable("Term::ReadLine::Gnu::Var::_rl_store_iostream", XS_Term__ReadLine__Gnu__Var__rl_store_iostream, file, "$$");
#endif
#if XSubPPtmpAAAB
        (void)newXSproto_portable("Term::ReadLine::Gnu::Var::_rl_store_iostream", XS_Term__ReadLine__Gnu__Var__rl_store_iostream, file, "$$");
#endif
#if XSubPPtmpAAAC
        (void)newXSproto_portable("Term::ReadLine::Gnu::Var::_rl_fetch_iostream", XS_Term__ReadLine__Gnu__Var__rl_fetch_iostream, file, "$");
#endif
        (void)newXSproto_portable("Term::ReadLine::Gnu::Var::_rl_fetch_keymap", XS_Term__ReadLine__Gnu__Var__rl_fetch_keymap, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::Var::_rl_store_function", XS_Term__ReadLine__Gnu__Var__rl_store_function, file, "$$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::Var::_rl_fetch_function", XS_Term__ReadLine__Gnu__Var__rl_fetch_function, file, "$");
        (void)newXSproto_portable("Term::ReadLine::Gnu::Var::_rl_fetch_last_func", XS_Term__ReadLine__Gnu__Var__rl_fetch_last_func, file, "");
        (void)newXSproto_portable("Term::ReadLine::Gnu::XS::tgetstr", XS_Term__ReadLine__Gnu__XS_tgetstr, file, "$");

    /* Initialisation Section */

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#line 6930 "Gnu.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
