/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of SHA1.xs. Do not edit this file, edit SHA1.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "SHA1.xs"
#ifdef __cplusplus
extern "C" {
#endif
#define PERL_NO_GET_CONTEXT     /* we want efficiency */
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

#ifndef PERL_VERSION
#    include <patchlevel.h>
#    if !(defined(PERL_VERSION) || (SUBVERSION > 0 && defined(PATCHLEVEL)))
#        include <could_not_find_Perl_patchlevel.h>
#    endif
#    define PERL_REVISION       5
#    define PERL_VERSION        PATCHLEVEL
#    define PERL_SUBVERSION     SUBVERSION
#endif

#if PERL_VERSION <= 4 && !defined(PL_dowarn)
   #define PL_dowarn dowarn
#endif

#ifdef G_WARN_ON
   #define DOWARN (PL_dowarn & G_WARN_ON)
#else
   #define DOWARN PL_dowarn
#endif

#ifdef SvPVbyte
   #if PERL_REVISION == 5 && PERL_VERSION < 7
       /* SvPVbyte does not work in perl-5.6.1, borrowed version for 5.7.3 */
       #undef SvPVbyte
       #define SvPVbyte(sv, lp) \
          ((SvFLAGS(sv) & (SVf_POK|SVf_UTF8)) == (SVf_POK) \
           ? ((lp = SvCUR(sv)), SvPVX(sv)) : my_sv_2pvbyte(aTHX_ sv, &lp))

       static char *
       my_sv_2pvbyte(pTHX_ register SV *sv, STRLEN *lp)
       {
           sv_utf8_downgrade(sv,0);
           return SvPV(sv,*lp);
       }
   #endif
#else
   #define SvPVbyte SvPV
#endif

#ifndef dTHX
   #define pTHX_
   #define aTHX_
#endif

/* NIST Secure Hash Algorithm */
/* heavily modified by Uwe Hollerbach <uh@alumni.caltech edu> */
/* from Peter C. Gutmann's implementation as found in */
/* Applied Cryptography by Bruce Schneier */
/* Further modifications to include the "UNRAVEL" stuff, below */

/* This code is in the public domain */

/* Useful defines & typedefs */

#if defined(U64TYPE) && (defined(USE_64_BIT_INT) || ((BYTEORDER != 0x1234) && (BYTEORDER != 0x4321)))
typedef U64TYPE ULONGx;
# if BYTEORDER == 0x1234
#   undef BYTEORDER
#   define BYTEORDER 0x12345678
# elif BYTEORDER == 0x4321
#   undef BYTEORDER
#   define BYTEORDER 0x87654321   
# endif
#else
typedef unsigned long ULONGx;     /* 32-or-more-bit quantity */
#endif

#define SHA_BLOCKSIZE		64
#define SHA_DIGESTSIZE		20

typedef struct {
    ULONGx digest[5];		/* message digest */
    ULONGx count_lo, count_hi;	/* 64-bit bit count */
    U8 data[SHA_BLOCKSIZE];	/* SHA data buffer */
    int local;			/* unprocessed amount in data */
} SHA_INFO;


/* UNRAVEL should be fastest & biggest */
/* UNROLL_LOOPS should be just as big, but slightly slower */
/* both undefined should be smallest and slowest */

#define SHA_VERSION 1
#define UNRAVEL
/* #define UNROLL_LOOPS */

/* SHA f()-functions */
#define f1(x,y,z)	((x & y) | (~x & z))
#define f2(x,y,z)	(x ^ y ^ z)
#define f3(x,y,z)	((x & y) | (x & z) | (y & z))
#define f4(x,y,z)	(x ^ y ^ z)

/* SHA constants */
#define CONST1		0x5a827999L
#define CONST2		0x6ed9eba1L
#define CONST3		0x8f1bbcdcL
#define CONST4		0xca62c1d6L

/* truncate to 32 bits -- should be a null op on 32-bit machines */
#define T32(x)	((x) & 0xffffffffL)

/* 32-bit rotate */
#define R32(x,n)	T32(((x << n) | (x >> (32 - n))))

/* the generic case, for when the overall rotation is not unraveled */
#define FG(n)	\
    T = T32(R32(A,5) + f##n(B,C,D) + E + *WP++ + CONST##n);	\
    E = D; D = C; C = R32(B,30); B = A; A = T

/* specific cases, for when the overall rotation is unraveled */
#define FA(n)	\
    T = T32(R32(A,5) + f##n(B,C,D) + E + *WP++ + CONST##n); B = R32(B,30)

#define FB(n)	\
    E = T32(R32(T,5) + f##n(A,B,C) + D + *WP++ + CONST##n); A = R32(A,30)

#define FC(n)	\
    D = T32(R32(E,5) + f##n(T,A,B) + C + *WP++ + CONST##n); T = R32(T,30)

#define FD(n)	\
    C = T32(R32(D,5) + f##n(E,T,A) + B + *WP++ + CONST##n); E = R32(E,30)

#define FE(n)	\
    B = T32(R32(C,5) + f##n(D,E,T) + A + *WP++ + CONST##n); D = R32(D,30)

#define FT(n)	\
    A = T32(R32(B,5) + f##n(C,D,E) + T + *WP++ + CONST##n); C = R32(C,30)


static void sha_transform(SHA_INFO *sha_info)
{
    int i;
    U8 *dp;
    ULONGx T, A, B, C, D, E, W[80], *WP;

    dp = sha_info->data;

/*
the following makes sure that at least one code block below is
traversed or an error is reported, without the necessity for nested
preprocessor if/else/endif blocks, which are a great pain in the
nether regions of the anatomy...
*/
#undef SWAP_DONE

#if BYTEORDER == 0x1234
#define SWAP_DONE
    /* assert(sizeof(ULONGx) == 4); */
    for (i = 0; i < 16; ++i) {
	T = *((ULONGx *) dp);
	dp += 4;
	W[i] =  ((T << 24) & 0xff000000) | ((T <<  8) & 0x00ff0000) |
		((T >>  8) & 0x0000ff00) | ((T >> 24) & 0x000000ff);
    }
#endif

#if BYTEORDER == 0x4321
#define SWAP_DONE
    /* assert(sizeof(ULONGx) == 4); */
    for (i = 0; i < 16; ++i) {
	T = *((ULONGx *) dp);
	dp += 4;
	W[i] = T32(T);
    }
#endif

#if BYTEORDER == 0x12345678
#define SWAP_DONE
    /* assert(sizeof(ULONGx) == 8); */
    for (i = 0; i < 16; i += 2) {
	T = *((ULONGx *) dp);
	dp += 8;
	W[i] =  ((T << 24) & 0xff000000) | ((T <<  8) & 0x00ff0000) |
		((T >>  8) & 0x0000ff00) | ((T >> 24) & 0x000000ff);
	T >>= 32;
	W[i+1] = ((T << 24) & 0xff000000) | ((T <<  8) & 0x00ff0000) |
		 ((T >>  8) & 0x0000ff00) | ((T >> 24) & 0x000000ff);
    }
#endif

#if BYTEORDER == 0x87654321
#define SWAP_DONE
    /* assert(sizeof(ULONGx) == 8); */
    for (i = 0; i < 16; i += 2) {
	T = *((ULONGx *) dp);
	dp += 8;
	W[i] = T32(T >> 32);
	W[i+1] = T32(T);
    }
#endif

#ifndef SWAP_DONE
#error Unknown byte order -- you need to add code here
#endif /* SWAP_DONE */

    for (i = 16; i < 80; ++i) {
	W[i] = W[i-3] ^ W[i-8] ^ W[i-14] ^ W[i-16];
#if (SHA_VERSION == 1)
	W[i] = R32(W[i], 1);
#endif /* SHA_VERSION */
    }
    A = sha_info->digest[0];
    B = sha_info->digest[1];
    C = sha_info->digest[2];
    D = sha_info->digest[3];
    E = sha_info->digest[4];
    WP = W;
#ifdef UNRAVEL
    FA(1); FB(1); FC(1); FD(1); FE(1); FT(1); FA(1); FB(1); FC(1); FD(1);
    FE(1); FT(1); FA(1); FB(1); FC(1); FD(1); FE(1); FT(1); FA(1); FB(1);
    FC(2); FD(2); FE(2); FT(2); FA(2); FB(2); FC(2); FD(2); FE(2); FT(2);
    FA(2); FB(2); FC(2); FD(2); FE(2); FT(2); FA(2); FB(2); FC(2); FD(2);
    FE(3); FT(3); FA(3); FB(3); FC(3); FD(3); FE(3); FT(3); FA(3); FB(3);
    FC(3); FD(3); FE(3); FT(3); FA(3); FB(3); FC(3); FD(3); FE(3); FT(3);
    FA(4); FB(4); FC(4); FD(4); FE(4); FT(4); FA(4); FB(4); FC(4); FD(4);
    FE(4); FT(4); FA(4); FB(4); FC(4); FD(4); FE(4); FT(4); FA(4); FB(4);
    sha_info->digest[0] = T32(sha_info->digest[0] + E);
    sha_info->digest[1] = T32(sha_info->digest[1] + T);
    sha_info->digest[2] = T32(sha_info->digest[2] + A);
    sha_info->digest[3] = T32(sha_info->digest[3] + B);
    sha_info->digest[4] = T32(sha_info->digest[4] + C);
#else /* !UNRAVEL */
#ifdef UNROLL_LOOPS
    FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1);
    FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1); FG(1);
    FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2);
    FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2); FG(2);
    FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3);
    FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3); FG(3);
    FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4);
    FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4); FG(4);
#else /* !UNROLL_LOOPS */
    for (i =  0; i < 20; ++i) { FG(1); }
    for (i = 20; i < 40; ++i) { FG(2); }
    for (i = 40; i < 60; ++i) { FG(3); }
    for (i = 60; i < 80; ++i) { FG(4); }
#endif /* !UNROLL_LOOPS */
    sha_info->digest[0] = T32(sha_info->digest[0] + A);
    sha_info->digest[1] = T32(sha_info->digest[1] + B);
    sha_info->digest[2] = T32(sha_info->digest[2] + C);
    sha_info->digest[3] = T32(sha_info->digest[3] + D);
    sha_info->digest[4] = T32(sha_info->digest[4] + E);
#endif /* !UNRAVEL */
}

/* initialize the SHA digest */

static void sha_init(SHA_INFO *sha_info)
{
    sha_info->digest[0] = 0x67452301L;
    sha_info->digest[1] = 0xefcdab89L;
    sha_info->digest[2] = 0x98badcfeL;
    sha_info->digest[3] = 0x10325476L;
    sha_info->digest[4] = 0xc3d2e1f0L;
    sha_info->count_lo = 0L;
    sha_info->count_hi = 0L;
    sha_info->local = 0;
}

/* update the SHA digest */

static void sha_update(SHA_INFO *sha_info, U8 *buffer, int count)
{
    int i;
    ULONGx clo;

    clo = T32(sha_info->count_lo + ((ULONGx) count << 3));
    if (clo < sha_info->count_lo) {
	++sha_info->count_hi;
    }
    sha_info->count_lo = clo;
    sha_info->count_hi += (ULONGx) count >> 29;
    if (sha_info->local) {
	i = SHA_BLOCKSIZE - sha_info->local;
	if (i > count) {
	    i = count;
	}
	memcpy(((U8 *) sha_info->data) + sha_info->local, buffer, i);
	count -= i;
	buffer += i;
	sha_info->local += i;
	if (sha_info->local == SHA_BLOCKSIZE) {
	    sha_transform(sha_info);
	} else {
	    return;
	}
    }
    while (count >= SHA_BLOCKSIZE) {
	memcpy(sha_info->data, buffer, SHA_BLOCKSIZE);
	buffer += SHA_BLOCKSIZE;
	count -= SHA_BLOCKSIZE;
	sha_transform(sha_info);
    }
    memcpy(sha_info->data, buffer, count);
    sha_info->local = count;
}


static void sha_transform_and_copy(unsigned char digest[20], SHA_INFO *sha_info)
{
    sha_transform(sha_info);
    digest[ 0] = (unsigned char) ((sha_info->digest[0] >> 24) & 0xff);
    digest[ 1] = (unsigned char) ((sha_info->digest[0] >> 16) & 0xff);
    digest[ 2] = (unsigned char) ((sha_info->digest[0] >>  8) & 0xff);
    digest[ 3] = (unsigned char) ((sha_info->digest[0]      ) & 0xff);
    digest[ 4] = (unsigned char) ((sha_info->digest[1] >> 24) & 0xff);
    digest[ 5] = (unsigned char) ((sha_info->digest[1] >> 16) & 0xff);
    digest[ 6] = (unsigned char) ((sha_info->digest[1] >>  8) & 0xff);
    digest[ 7] = (unsigned char) ((sha_info->digest[1]      ) & 0xff);
    digest[ 8] = (unsigned char) ((sha_info->digest[2] >> 24) & 0xff);
    digest[ 9] = (unsigned char) ((sha_info->digest[2] >> 16) & 0xff);
    digest[10] = (unsigned char) ((sha_info->digest[2] >>  8) & 0xff);
    digest[11] = (unsigned char) ((sha_info->digest[2]      ) & 0xff);
    digest[12] = (unsigned char) ((sha_info->digest[3] >> 24) & 0xff);
    digest[13] = (unsigned char) ((sha_info->digest[3] >> 16) & 0xff);
    digest[14] = (unsigned char) ((sha_info->digest[3] >>  8) & 0xff);
    digest[15] = (unsigned char) ((sha_info->digest[3]      ) & 0xff);
    digest[16] = (unsigned char) ((sha_info->digest[4] >> 24) & 0xff);
    digest[17] = (unsigned char) ((sha_info->digest[4] >> 16) & 0xff);
    digest[18] = (unsigned char) ((sha_info->digest[4] >>  8) & 0xff);
    digest[19] = (unsigned char) ((sha_info->digest[4]      ) & 0xff);
}

/* finish computing the SHA digest */
static void sha_final(unsigned char digest[20], SHA_INFO *sha_info)
{
    int count;
    ULONGx lo_bit_count, hi_bit_count;

    lo_bit_count = sha_info->count_lo;
    hi_bit_count = sha_info->count_hi;
    count = (int) ((lo_bit_count >> 3) & 0x3f);
    ((U8 *) sha_info->data)[count++] = 0x80;
    if (count > SHA_BLOCKSIZE - 8) {
	memset(((U8 *) sha_info->data) + count, 0, SHA_BLOCKSIZE - count);
	sha_transform(sha_info);
	memset((U8 *) sha_info->data, 0, SHA_BLOCKSIZE - 8);
    } else {
	memset(((U8 *) sha_info->data) + count, 0,
	    SHA_BLOCKSIZE - 8 - count);
    }
    sha_info->data[56] = (U8)((hi_bit_count >> 24) & 0xff);
    sha_info->data[57] = (U8)((hi_bit_count >> 16) & 0xff);
    sha_info->data[58] = (U8)((hi_bit_count >>  8) & 0xff);
    sha_info->data[59] = (U8)((hi_bit_count >>  0) & 0xff);
    sha_info->data[60] = (U8)((lo_bit_count >> 24) & 0xff);
    sha_info->data[61] = (U8)((lo_bit_count >> 16) & 0xff);
    sha_info->data[62] = (U8)((lo_bit_count >>  8) & 0xff);
    sha_info->data[63] = (U8)((lo_bit_count >>  0) & 0xff);
    sha_transform_and_copy(digest, sha_info);
}





/*----------------------------------------------------------------*/
#ifndef INT2PTR
#define INT2PTR(any,d)	(any)(d)
#endif

static SHA_INFO* get_sha_info(pTHX_ SV* sv)
{
    if (sv_derived_from(sv, "Digest::SHA1"))
	return INT2PTR(SHA_INFO*, SvIV(SvRV(sv)));
    croak("Not a reference to a Digest::SHA1 object");
    return (SHA_INFO*)0; /* some compilers insist on a return value */
}


static char* hex_20(const unsigned char* from, char* to)
{
    static const char *hexdigits = "0123456789abcdef";
    const unsigned char *end = from + 20;
    char *d = to;

    while (from < end) {
	*d++ = hexdigits[(*from >> 4)];
	*d++ = hexdigits[(*from & 0x0F)];
	from++;
    }
    *d = '\0';
    return to;
}

static char* base64_20(const unsigned char* from, char* to)
{
    static const char* base64 =
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    const unsigned char *end = from + 20;
    unsigned char c1, c2, c3;
    char *d = to;

    while (1) {
	c1 = *from++;
	c2 = *from++;
	*d++ = base64[c1>>2];
	*d++ = base64[((c1 & 0x3) << 4) | ((c2 & 0xF0) >> 4)];
	if (from == end) {
	    *d++ = base64[(c2 & 0xF) << 2];
	    break;
	}
	c3 = *from++;
	*d++ = base64[((c2 & 0xF) << 2) | ((c3 & 0xC0) >>6)];
	*d++ = base64[c3 & 0x3F];
    }
    *d = '\0';
    return to;
}

/* Formats */
#define F_BIN 0
#define F_HEX 1
#define F_B64 2

static SV* make_mortal_sv(pTHX_ const unsigned char *src, int type)
{
    STRLEN len;
    char result[41];
    char *ret;
    
    switch (type) {
    case F_BIN:
	ret = (char*)src;
	len = 20;
	break;
    case F_HEX:
	ret = hex_20(src, result);
	len = 40;
	break;
    case F_B64:
	ret = base64_20(src, result);
	len = 27;
	break;
    default:
	croak("Bad convertion type (%d)", type);
	break;
    }
    return sv_2mortal(newSVpv(ret,len));
}


/********************************************************************/

typedef PerlIO* InputStream;

#line 468 "SHA1.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 612 "SHA1.c"

XS_EUPXS(XS_Digest__SHA1_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Digest__SHA1_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "xclass");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	xclass = ST(0)
;
#line 466 "SHA1.xs"
	SHA_INFO* context;
#line 627 "SHA1.c"
#line 468 "SHA1.xs"
	if (!SvROK(xclass)) {
	    STRLEN my_na;
	    char *sclass = SvPV(xclass, my_na);
	    New(55, context, 1, SHA_INFO);
	    ST(0) = sv_newmortal();
	    sv_setref_pv(ST(0), sclass, (void*)context);
	    SvREADONLY_on(SvRV(ST(0)));
	} else {
	    context = get_sha_info(aTHX_ xclass);
	}
	sha_init(context);
	XSRETURN(1);
#line 641 "SHA1.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Digest__SHA1_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Digest__SHA1_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	self = ST(0)
;
#line 485 "SHA1.xs"
        SHA_INFO* cont = get_sha_info(aTHX_ self);
        const char *myname = sv_reftype(SvRV(self),TRUE);
        SHA_INFO* context;
#line 663 "SHA1.c"
#line 489 "SHA1.xs"
        New(55, context, 1, SHA_INFO);
        ST(0) = sv_newmortal();
        sv_setref_pv(ST(0), myname , (void*)context);
        SvREADONLY_on(SvRV(ST(0)));
        memcpy(context,cont,sizeof(SHA_INFO));
        XSRETURN(1);
#line 671 "SHA1.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Digest__SHA1_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Digest__SHA1_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "context");
    {
	SHA_INFO*	context = get_sha_info(aTHX_ ST(0))
;
#line 500 "SHA1.xs"
        Safefree(context);
#line 689 "SHA1.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Digest__SHA1_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Digest__SHA1_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	self = ST(0)
;
#line 506 "SHA1.xs"
	SHA_INFO* context = get_sha_info(aTHX_ self);
	int i;
	unsigned char *data;
	STRLEN len;
#line 711 "SHA1.c"
#line 511 "SHA1.xs"
	for (i = 1; i < items; i++) {
	    data = (unsigned char *)(SvPVbyte(ST(i), len));
	    sha_update(context, data, len);
	}
	XSRETURN(1);  /* self */
#line 718 "SHA1.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Digest__SHA1_addfile); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Digest__SHA1_addfile)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, fh");
    {
	SV*	self = ST(0)
;
	InputStream	fh = IoIFP(sv_2io(ST(1)))
;
#line 522 "SHA1.xs"
	SHA_INFO* context = get_sha_info(aTHX_ self);
	unsigned char buffer[4096];
	int  n;
#line 740 "SHA1.c"
#line 526 "SHA1.xs"
        if (fh) {
	    /* Process blocks until EOF or error */
            while ( (n = PerlIO_read(fh, buffer, sizeof(buffer))) > 0) {
		sha_update(context, buffer, n);
	    }
	    if (PerlIO_error(fh)) {
		croak("Reading from filehandle failed");
	    }
        }
        else {
	    croak("No filehandle passed");
        }

	XSRETURN(1);  /* self */
#line 756 "SHA1.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Digest__SHA1_digest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Digest__SHA1_digest)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "context");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SHA_INFO*	context = get_sha_info(aTHX_ ST(0))
;
#line 549 "SHA1.xs"
	unsigned char digeststr[20];
#line 776 "SHA1.c"
#line 551 "SHA1.xs"
        sha_final(digeststr, context);
	sha_init(context);  /* In case it is reused */
        ST(0) = make_mortal_sv(aTHX_ digeststr, ix);
        XSRETURN(1);
#line 782 "SHA1.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Digest__SHA1_sha1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Digest__SHA1_sha1)
{
    dVAR; dXSARGS;
    dXSI32;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 563 "SHA1.xs"
	SHA_INFO ctx;
	int i;
	unsigned char *data;
        STRLEN len;
	unsigned char digeststr[20];
#line 805 "SHA1.c"
#line 569 "SHA1.xs"
	sha_init(&ctx);

	if (DOWARN) {
            const char *msg = 0;
	    if (items == 1) {
		if (SvROK(ST(0))) {
                    SV* sv = SvRV(ST(0));
		    if (SvOBJECT(sv) && strEQ(HvNAME(SvSTASH(sv)), "Digest::SHA1"))
		        msg = "probably called as method";
		    else
			msg = "called with reference argument";
		}
	    }
	    else if (items > 1) {
		data = (unsigned char *)SvPVbyte(ST(0), len);
		if (len == 12 && memEQ("Digest::SHA1", data, 12)) {
		    msg = "probably called as class method";
		}
	    }
	    if (msg) {
		const char *f = (ix == F_BIN) ? "sha1" :
                                (ix == F_HEX) ? "sha1_hex" : "sha1_base64";
	        warn("&Digest::SHA1::%s function %s", f, msg);
	    }
	}

	for (i = 0; i < items; i++) {
	    data = (unsigned char *)(SvPVbyte(ST(i), len));
	    sha_update(&ctx, data, len);
	}
	sha_final(digeststr, &ctx);
        ST(0) = make_mortal_sv(aTHX_ digeststr, ix);
        XSRETURN(1);
#line 840 "SHA1.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Digest__SHA1_sha1_transform); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Digest__SHA1_sha1_transform)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	data = ST(0)
;
#line 607 "SHA1.xs"
        SHA_INFO ctx;
        unsigned char *data_pv;
        unsigned char test[64];
        STRLEN len;
        unsigned char digeststr[20];
#line 864 "SHA1.c"
#line 613 "SHA1.xs"
        sha_init(&ctx);

        memset (test, 0, 64);
        data_pv = (unsigned char *)(SvPVbyte(data, len));
        memcpy (test, data_pv, len);
	memcpy ((&ctx)->data, test, 64);
        sha_transform_and_copy(digeststr, &ctx);
        ST(0) = sv_2mortal(newSVpv((char*)digeststr, 20));
        XSRETURN(1);
#line 875 "SHA1.c"
	PUTBACK;
	return;
    }
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Digest__SHA1); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Digest__SHA1)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Digest::SHA1::new", XS_Digest__SHA1_new);
        newXS_deffile("Digest::SHA1::clone", XS_Digest__SHA1_clone);
        newXS_deffile("Digest::SHA1::DESTROY", XS_Digest__SHA1_DESTROY);
        newXS_deffile("Digest::SHA1::add", XS_Digest__SHA1_add);
        newXS_deffile("Digest::SHA1::addfile", XS_Digest__SHA1_addfile);
        cv = newXS_deffile("Digest::SHA1::b64digest", XS_Digest__SHA1_digest);
        XSANY.any_i32 = F_B64;
        cv = newXS_deffile("Digest::SHA1::digest", XS_Digest__SHA1_digest);
        XSANY.any_i32 = F_BIN;
        cv = newXS_deffile("Digest::SHA1::hexdigest", XS_Digest__SHA1_digest);
        XSANY.any_i32 = F_HEX;
        cv = newXS_deffile("Digest::SHA1::sha1", XS_Digest__SHA1_sha1);
        XSANY.any_i32 = F_BIN;
        cv = newXS_deffile("Digest::SHA1::sha1_base64", XS_Digest__SHA1_sha1);
        XSANY.any_i32 = F_B64;
        cv = newXS_deffile("Digest::SHA1::sha1_hex", XS_Digest__SHA1_sha1);
        XSANY.any_i32 = F_HEX;
        newXS_deffile("Digest::SHA1::sha1_transform", XS_Digest__SHA1_sha1_transform);
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
