/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.jmakepdfx;

import com.dickimawbooks.jmakepdfx.FileField;
import com.dickimawbooks.jmakepdfx.Jmakepdfx;
import com.dickimawbooks.jmakepdfx.JpdfxProperties;
import com.dickimawbooks.jmakepdfx.JpdfxResources;
import com.dickimawbooks.jmakepdfx.NonNegativeLongPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PropertiesDialog
extends JDialog
implements ActionListener {
    private Jmakepdfx app;
    private JpdfxProperties properties;
    private JFileChooser fileChooser;
    private JRadioButton homeButton;
    private JRadioButton lastButton;
    private JRadioButton customButton;
    private FileField customField;
    private FileField gsField;
    private FileField pdfField;
    private FileField iccField;
    private NonNegativeLongPanel timeoutPanel;
    private JButton fetchButton;

    public PropertiesDialog(Jmakepdfx jmakepdfx) {
        super(jmakepdfx, Jmakepdfx.getLabel("properties.title"), true);
        this.app = jmakepdfx;
        this.properties = this.app.getProperties();
        String string = this.properties.getDefaultDirectory();
        if (string == null) {
            string = ".";
        }
        File file = new File(string);
        String string2 = this.properties.getDefaultDirectorySetting();
        if (string2 == null) {
            string2 = "home";
        }
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createLoweredBevelBorder());
        box.setAlignmentX(0.0f);
        box.setAlignmentY(0.5f);
        Box box2 = Box.createVerticalBox();
        box2.setAlignmentX(0.0f);
        box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Jmakepdfx.getLabel("properties.startup")));
        box.add(box2);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.homeButton = new JRadioButton(Jmakepdfx.getLabel("properties.home"));
        this.homeButton.setActionCommand("disablecustom");
        this.homeButton.addActionListener(this);
        this.homeButton.setMnemonic(Jmakepdfx.getMnemonic("properties.home"));
        this.homeButton.setAlignmentX(0.0f);
        this.homeButton.setAlignmentY(0.5f);
        buttonGroup.add(this.homeButton);
        box2.add(this.homeButton);
        this.lastButton = new JRadioButton(Jmakepdfx.getLabel("properties.last"));
        this.lastButton.setActionCommand("disablecustom");
        this.lastButton.setMnemonic(Jmakepdfx.getMnemonic("properties.last"));
        this.lastButton.addActionListener(this);
        this.lastButton.setAlignmentX(0.0f);
        this.lastButton.setAlignmentY(0.5f);
        buttonGroup.add(this.lastButton);
        box2.add(this.lastButton);
        Box box3 = Box.createHorizontalBox();
        box3.setAlignmentX(0.0f);
        box3.setAlignmentY(0.0f);
        this.customButton = new JRadioButton(Jmakepdfx.getLabel("properties.custom"));
        this.customButton.setMnemonic(Jmakepdfx.getMnemonic("properties.custom"));
        this.customButton.setActionCommand("enablecustom");
        this.customButton.addActionListener(this);
        this.customButton.setAlignmentX(0.0f);
        this.customButton.setAlignmentY(0.5f);
        this.customButton.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        buttonGroup.add(this.customButton);
        box3.add(this.customButton);
        this.fileChooser = new JFileChooser();
        this.customField = new FileField((Container)this, this.fileChooser, 1);
        box3.add(this.customField);
        if (string2.equals("home")) {
            this.homeButton.setSelected(true);
            this.customField.setEnabled(false);
        } else if (string2.equals("last")) {
            this.homeButton.setSelected(true);
            this.customField.setEnabled(false);
        } else if (string2.equals("custom")) {
            this.customButton.setSelected(true);
            this.customField.setFileName(file.getAbsolutePath());
        }
        Dimension dimension = this.customField.getPreferredSize();
        dimension.width = (int)this.customField.getMaximumSize().getWidth();
        this.customField.setMaximumSize(dimension);
        box2.add(box3);
        box.add(new Box.Filler(new Dimension(0, 0), new Dimension(1, 20), new Dimension(1, Integer.MAX_VALUE)));
        box3 = Box.createHorizontalBox();
        box3.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel(Jmakepdfx.getLabel("properties.path.gs"));
        jLabel.setAlignmentY(0.5f);
        jLabel.setDisplayedMnemonic(Jmakepdfx.getMnemonic("properties.path.gs"));
        box3.add(jLabel);
        this.gsField = new FileField((Container)this, this.properties.getGSApp(), this.fileChooser);
        jLabel.setLabelFor(this.gsField.getTextField());
        box3.add(this.gsField);
        box.add(box3);
        box3 = Box.createHorizontalBox();
        box3.setAlignmentX(0.0f);
        JLabel jLabel2 = new JLabel(Jmakepdfx.getLabel("properties.path.pdfviewer"));
        jLabel2.setAlignmentY(0.5f);
        jLabel2.setDisplayedMnemonic(Jmakepdfx.getMnemonic("properties.path.pdfviewer"));
        box3.add(jLabel2);
        this.pdfField = new FileField((Container)this, this.properties.getPDFViewer(), this.fileChooser);
        jLabel2.setLabelFor(this.pdfField.getTextField());
        box3.add(this.pdfField);
        box.add(box3);
        box.add(new Box.Filler(new Dimension(0, 0), new Dimension(1, 20), new Dimension(1, Integer.MAX_VALUE)));
        Box box4 = Box.createVerticalBox();
        box4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "ICC"));
        box4.setAlignmentX(0.0f);
        box.add(box4);
        box3 = Box.createHorizontalBox();
        box3.setAlignmentX(0.0f);
        JLabel jLabel3 = new JLabel(Jmakepdfx.getLabel("properties.path.icc"));
        jLabel3.setAlignmentY(0.5f);
        jLabel3.setDisplayedMnemonic(Jmakepdfx.getMnemonic("properties.path.icc"));
        box3.add(jLabel3);
        this.iccField = new FileField((Container)this, this.properties.getICCFile(), this.fileChooser);
        jLabel3.setLabelFor(this.iccField.getTextField());
        box3.add(this.iccField);
        box4.add(box3);
        box4.add(new Box.Filler(new Dimension(0, 0), new Dimension(1, 20), new Dimension(1, Integer.MAX_VALUE)));
        box3 = Box.createHorizontalBox();
        box3.setAlignmentX(0.0f);
        JTextArea jTextArea = new JTextArea(Jmakepdfx.getLabel("properties.fetch_icc.info"));
        jTextArea.setAlignmentX(0.0f);
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        box3.add(jTextArea);
        this.fetchButton = new JButton(Jmakepdfx.getLabel("properties.fetch_icc"));
        this.fetchButton.setMnemonic(Jmakepdfx.getMnemonic("properties.fetch_icc"));
        this.fetchButton.setActionCommand("fetchicc");
        this.fetchButton.addActionListener(this);
        box3.add(this.fetchButton);
        box4.add(box3);
        box.add(new Box.Filler(new Dimension(0, 0), new Dimension(1, 20), new Dimension(1, Integer.MAX_VALUE)));
        this.timeoutPanel = new NonNegativeLongPanel("properties.timeout", this.properties.getMaxProcessTime() / 60000L);
        this.timeoutPanel.setAlignmentX(0.0f);
        this.timeoutPanel.add(new JLabel(Jmakepdfx.getLabel("properties.timeout.minutes")));
        this.timeoutPanel.add(new Box.Filler(new Dimension(0, 0), new Dimension(40, 1), new Dimension(Integer.MAX_VALUE, 1)));
        box.add(this.timeoutPanel);
        box.add(new Box.Filler(new Dimension(0, 0), new Dimension(1, 20), new Dimension(1, Integer.MAX_VALUE)));
        Dimension dimension2 = box.getPreferredSize();
        dimension2.width += 30;
        dimension2.height += 30;
        box.setPreferredSize(dimension2);
        this.getContentPane().add((Component)new JScrollPane(box), "Center");
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "South");
        jPanel.add(JpdfxResources.createOkayButton(this));
        jPanel.add(JpdfxResources.createCancelButton(this));
        JButton jButton = new JButton(Jmakepdfx.getLabel("button.help"));
        jButton.setMnemonic(Jmakepdfx.getMnemonic("button.help"));
        this.app.enableHelpOnButton(jButton, "sec:settings");
        jPanel.add(jButton);
        this.pack();
        this.setLocationRelativeTo(this.app);
    }

    public void display() {
        this.gsField.setFileName(this.properties.getGSApp());
        this.pdfField.setFileName(this.properties.getPDFViewer());
        this.iccField.setFileName(this.properties.getICCFile());
        this.timeoutPanel.setValue(this.properties.getMaxProcessTime() / 60000L);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("disablecustom")) {
            this.customField.setEnabled(false);
        } else if (string.equals("enablecustom")) {
            this.customField.setEnabled(true);
            this.customField.requestFocusInWindow();
        } else if (string.equals("cancel")) {
            this.setVisible(false);
        } else if (string.equals("fetchicc")) {
            try {
                File file = this.app.fetchICCFile();
                if (file != null) {
                    this.iccField.setFileName(file.getAbsolutePath());
                }
            }
            catch (Exception exception) {
                this.app.error(exception);
            }
        } else if (string.equals("okay")) {
            this.properties.setGSApp(this.gsField.getFileName());
            this.properties.setPDFViewer(this.pdfField.getFileName());
            this.properties.setICCFile(this.iccField.getFileName());
            this.properties.setMaxProcessTime(this.timeoutPanel.getValue() * 60000L);
            if (this.homeButton.isSelected()) {
                this.properties.setDefaultHomeDir();
            } else if (this.lastButton.isSelected()) {
                this.properties.setDefaultLastDir();
            } else {
                String string2 = this.customField.getFileName();
                if (string2.equals("")) {
                    JpdfxResources.error((Component)this, Jmakepdfx.getLabel("error.prop.missing.custom"));
                    return;
                }
                File file = new File(string2);
                if (!file.isDirectory()) {
                    JpdfxResources.error((Component)this, Jmakepdfx.getLabelWithValue("error.dir.not", string2));
                }
                this.properties.setDefaultCustomDir(string2);
            }
            this.setVisible(false);
        }
    }
}

