// dvidoc.h : interface of the CDviDoc class			-*- C++ -*-
// Time-stamp: "97/01/03 18:20:13 mik"
//
// Copyright (C) 1996, 97
//	Christian Schenk  <cschenk@berlin.snafu.de>
//
// This file is part of MiKTeX.
//
// MiKTeX is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// MiKTeX is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with MiKTeX; if not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
/////////////////////////////////////////////////////////////////////////////

#include "dvi.h"

class CDviDoc : public CDocument
{
protected: // create from serialization only
	CDviDoc();
	DECLARE_DYNCREATE(CDviDoc)

// Attributes
public:
	void newmode(const char *, long);
	BOOL isprintcontext();
	const dvi_page *curdvipage ();
	int pageno ();
	const CSize &pagesize ();
	void nextpage ();
	void prevpage ();
	void gotopage (int pageno);
	int pagecount ();
	void switchcontext (int);
	BOOL prepareprinting (const CDC *);

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDviDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CDviDoc();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	dvi *dvifile;
	dvi_integer curpageidx;

public:
	static long pagexshift;
	static long pageyshift;
    static long displayshrinkfactor;
    static CString displaymode;
    static long displayres;
    static long printerres;
    static CString printermode;

// Generated message map functions
protected:
	//{{AFX_MSG(CDviDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	int context;
};

/////////////////////////////////////////////////////////////////////////////

