/* Portions Copyright (C) 2001 artofcode LLC.
   Portions Copyright (C) 1996, 2001 Artifex Software Inc.
   Portions Copyright (C) 1988, 2000 Aladdin Enterprises.
   This software is based in part on the work of the Independent JPEG Group.
   All Rights Reserved.

   This software is distributed under license and may not be copied, modified
   or distributed except as expressly authorized under the terms of that
   license.  Refer to licensing information at http://www.artifex.com/ or
   contact Artifex Software, Inc., 101 Lucas Valley Road #110,
   San Rafael, CA  94903, (415)492-9861, for further information. */
/*$Id: plsymbol.c,v 1.16 2003/06/25 06:48:33 henrys Exp $ */

/* plsymbol.c */
/* Built-in PCL symbol sets */

#include "stdpre.h"
#include "plsymbol.h"

/* Define the MSL code for unmapped characters. */
#define ffff 0xffff

/* Define a macro for generating the header for built-in symbol sets. */
#define map_number(n, l) ((n) * 32 + (l) - '@')
#define map_header(n, l, vocab, t, cc0, cc1, cc2, cc3, cc4, cc5, cc6, cc7, mapping_type)\
  {0, 18}, {map_number(n, l) >> 8, map_number(n, l) & 0xff},\
  (vocab) * 2 + 1, t, {0, 0}, {0, 255},\
  {cc0, cc1, cc2, cc3, cc4, cc5, cc6, ((cc7) & 0xf8) | (vocab)},\
  (mapping_type)

/*
 * This file may exist in many different source formats over time.
 * To help convert between formats, if this file is compiled with the
 * -dMAIN switch, it will include a 'main' program that will write out
 * the data in directly usable format.
 */
#ifdef MAIN
#include <stdio.h>
#undef printf
int
main(int argc, char *argv[])
{    const pl_symbol_map_t **ppmap = pl_built_in_symbol_maps;

     for ( ; *ppmap; ++ppmap )
       { const pl_symbol_map_t *pmap = *ppmap;
	 uint id = (pmap->id[0] << 8) + pmap->id[1];
	 int n = id >> 5;
	 int l = (id & 31) + '@';
	 uint i;

	 printf("\n/**** %d%c ****/", n, l);
	 for ( i = 0; i < 256; ++i )
	   { if ( !(i & 7) )
	    { if ( !(i & 15) )
		printf("\n/* 0x%02x */\n   ", i);
	      else
		fputs("\n   ", stdout);
	    }
	     printf(" 0x%04x", (uint)pmap->codes[i]);
	  if ( i != 255 )
	    putchar(',');
	   }
	 puts("\n");
       }
     return 0;
}
#endif                   /* MAIN */

/* Define common symbol set elements. */

/***************************************
 * ASCII and national variant mappings *
 ***************************************/
/* ISO ASCII */
private const pl_symbol_map_t map_0U_unicode = {
  map_header(0, 'U', plgv_Unicode, 1, 0, 0, 0, 0, 0xc0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
/* 0x60 */
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x2592,
/* 0x80 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xb0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xc0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xd0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xe0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xf0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
  }
};
/* United Kingdom */
private const pl_symbol_map_t map_1E_unicode = {
  map_header(1, 'E', plgv_Unicode, 1, 0, 0, 0, 0, 0xc0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x02c6, 0x005f,
/* 0x60 */
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x00af, 0x2592,
/* 0x80 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xb0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xc0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xd0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xe0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xf0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
  }
};
/* French */
private const pl_symbol_map_t map_1F_unicode = {
  map_header(1, 'F', plgv_Unicode, 1, 0, 0, 0, 0, 0xc0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x00e0, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00b0, 0x00e7, 0x00a7, 0x005e, 0x005f,
/* 0x60 */
    0x00b5, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e9, 0x00f9, 0x00e8, 0x00a8, 0x2592,
/* 0x80 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xb0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xc0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xd0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xe0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xf0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
  }
};
/* German */
private const pl_symbol_map_t map_1G_unicode = {
  map_header(1, 'G', plgv_Unicode, 1, 0, 0, 0, 0, 0xc0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x00a7, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00c4, 0x00d6, 0x00dc, 0x005e, 0x005f,
/* 0x60 */
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e4, 0x00f6, 0x00fc, 0x00df, 0x2592,
/* 0x80 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xb0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xc0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xd0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xe0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xf0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
  }
};
/* Italian */
private const pl_symbol_map_t map_0I_unicode = {
  map_header(0, 'I', plgv_Unicode, 1, 0, 0, 0, 0, 0xc0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x00a7, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00b0, 0x00e7, 0x00e9, 0x02c6, 0x005f,
/* 0x60 */
    0x00f9, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e0, 0x00f2, 0x00e8, 0x00ec, 0x2592,
/* 0x80 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xb0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xc0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xd0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xe0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xf0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
  }
};
/* Swedish for names */
private const pl_symbol_map_t map_0S_unicode = {
  map_header(0, 'S', plgv_Unicode, 1, 0, 0, 0, 0, 0xc0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x0023, 0x00a4, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x00c9, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00c4, 0x00d6, 0x00c5, 0x00dc, 0x005f,
/* 0x60 */
    0x00e9, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e4, 0x00f6, 0x00e5, 0x00fc, 0x2592,
/* 0x80 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xb0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xc0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xd0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xe0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xf0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
  }
};
/* Spanish */
private const pl_symbol_map_t map_2S_unicode = {
  map_header(2, 'S', plgv_Unicode, 1, 0, 0, 0, 0, 0xc0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x00a7, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00a1, 0x00d1, 0x00bf, 0x005e, 0x005f,
/* 0x60 */
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00b0, 0x00f1, 0x00e7, 0x02dc, 0x2592,
/* 0x80 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xb0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xc0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xd0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xe0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xf0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
  }
};
/* Norwegian version 1 */
private const pl_symbol_map_t map_0D_unicode = {
  map_header(0, 'D', plgv_Unicode, 1, 0, 0, 0, 0, 0xc0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00c6, 0x00d8, 0x00c5, 0x02c6, 0x005f,
/* 0x60 */
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e6, 0x00f8, 0x00e5, 0x00af, 0x2592,
/* 0x80 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xb0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xc0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xd0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xe0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xf0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
  }
};

/***************************
 * Roman-8 Unicode mapping *
 ***************************/
private const pl_symbol_map_t map_8U_unicode = {
  map_header(8, 'U', plgv_Unicode, 1, 0, 0, 0, 0, 0xc0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
/* 0x60 */
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x2592,
/* 0x80 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0x00a0, 0x00c0, 0x00c2, 0x00c8, 0x00ca, 0x00cb, 0x00ce, 0x00cf,
    0x00b4, 0x0060, 0x02c6, 0x00a8, 0x02dc, 0x00d9, 0x00db, 0x00a3,
/* 0xb0 */
    0x00af, 0x00dd, 0x00fd, 0x00b0, 0x00c7, 0x00e7, 0x00d1, 0x00f1,
    0x00a1, 0x00bf, 0x00a4, 0x00a3, 0x00a5, 0x00a7, 0x0192, 0x00a2,
/* 0xc0 */
    0x00e2, 0x00ea, 0x00f4, 0x00fb, 0x00e1, 0x00e9, 0x00f3, 0x00fa,
    0x00e0, 0x00e8, 0x00f2, 0x00f9, 0x00e4, 0x00eb, 0x00f6, 0x00fc,
/* 0xd0 */
    0x00c5, 0x00ee, 0x00d8, 0x00c6, 0x00e5, 0x00ed, 0x00f8, 0x00e6,
    0x00c4, 0x00ec, 0x00d6, 0x00dc, 0x00c9, 0x00ef, 0x00df, 0x00d4,
/* 0xe0 */
    0x00c1, 0x00c3, 0x00e3, 0x0110, 0x00f0, 0x00cd, 0x00cc, 0x00d3,
    0x00d2, 0x00d5, 0x00f5, 0x0160, 0x0161, 0x00da, 0x0178, 0x00ff,
/* 0xf0 */
    0x00de, 0x00fe, 0x00b7, 0x00b5, 0x00b6, 0x00be, 0x2014, 0x00bc,
    0x00bd, 0x00aa, 0x00ba, 0x00ab, 0x25aa, 0x00bb, 0x00b1, 0xffff
  }
};

/***************************
 * Desktop Unicode mapping *
 ***************************/
private const pl_symbol_map_t map_7J_unicode = {
  map_header(7, 'J', plgv_Unicode, 1, 0, 0, 0, 0, 0xc0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
    0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
/* 0x10 */
    0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
    0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x2019,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
/* 0x60 */
    0x2018, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x2592,
/* 0x80 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0x0001, 0x00b6, 0x00a7, 0x2020, 0x2021, 0x00a9, 0x00ae, 0x2122,
    0x2105, 0x00a2, 0x2013, 0x2014, 0x2026, 0xf001, 0xf002, 0xffff,
/* 0xb0 */
    0x201c, 0x201d, 0x00b5, 0x2030, 0x2022, 0x25cf, 0x25e6, 0x25cb,
    0x25aa, 0x25a0, 0x25ab, 0x25a1, 0x0027, 0x00ac, 0x00a6, 0x2017,
/* 0xc0 */
    0x2212, 0x00b1, 0x00d7, 0x00f7, 0x00b0, 0x2032, 0x2033, 0x00bc,
    0x00bd, 0x00be, 0x00b9, 0x00b2, 0x00b3, 0x2215, 0xffff, 0xffff,
/* 0xd0 */
    0x2039, 0x203a, 0x00ab, 0x00bb, 0x201a, 0x201e, 0x2219, 0x00a1,
    0x00bf, 0x20A7, 0x2113, 0x00a3, 0x00a5, 0x00a4, 0x0192, 0x00df,
/* 0xe0 */
    0x00aa, 0x00ba, 0x00e6, 0x00c6, 0x00f0, 0x00d0, 0x0133, 0x0132,
    0x0142, 0x0141, 0x0153, 0x0152, 0x00f8, 0x00d8, 0x00fe, 0x00de,
/* 0xf0 */
    0x00b4, 0x0060, 0x02c6, 0x00a8, 0x02dc, 0x02c7, 0x02d8, 0x02dd,
    0x02da, 0x02d9, 0x02c9, 0x00b8, 0x02db, 0x00b7, 0x0131, 0xffff
  }
};

/**************************************
 * ISO 8859/1 Latin 1 Unicode mapping *
 **************************************/
private const pl_symbol_map_t map_0N_unicode = {
  map_header(0, 'N', plgv_Unicode, 1, 0, 0, 0, 0, 0xc4, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x02c6, 0x005f,
/* 0x60 */
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x02dc, 0x2592,
/* 0x80 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
    0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x02c9,
/* 0xb0 */
    0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
    0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
/* 0xc0 */
    0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
    0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
/* 0xd0 */
    0x0110, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7,
    0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df,
/* 0xe0 */
    0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
    0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
/* 0xf0 */
    0x0111, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7,
    0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff
  }
};

/***************************************
 * Windows 3.1 Latin 1 Unicode mapping *
 ***************************************/
/*
 * This is identical to the ISO 8859/1 Latin 1 mapping, except that
 * it has added characters in positions 0x80 - 0x9f.
 */
private const pl_symbol_map_t map_19U_unicode = {
  map_header(19, 'U', plgv_Unicode, 2, 0, 0, 0, 0, 0xc6, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
/* 0x60 */
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x2592,
/* 0x80 */
    0x20ac, 0xffff, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021,
    0x02c6, 0x2030, 0x0160, 0x2039, 0x0152, 0xffff, 0x017d, 0xffff,
/* 0x90 */
    0xffff, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014,
    0x02dc, 0x2122, 0x0161, 0x203a, 0x0153, 0xffff, 0x017e, 0x0178,
/* 0xa0 */
    0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
    0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x02c9,
/* 0xb0 */
    0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
    0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
/* 0xc0 */
    0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
    0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
/* 0xd0 */
    0x0110, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7,
    0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df,
/* 0xe0 */
    0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
    0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
/* 0xf0 */
    0x0111, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7,
    0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff,
  }
};

/**************************************
 * PC-8 Code Page 437 Unicode mapping *
 **************************************/
/*
 * Codes 0x00-0x1f are shared with other PC mappings;
 * codes 0x80-0xaf are (almost) shared with the PC-850 Multilingual map.
 */
private const pl_symbol_map_t map_10U_unicode = {
  map_header(10, 'U', plgv_Unicode, 2, 0, 0, 0, 0, 0xc2, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0x263a, 0x263b, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022,
    0x25d8, 0x25cb, 0x25d9, 0x2642, 0x2640, 0x266a, 0x266b, 0x263c,
/* 0x10 */
    0x25ba, 0x25c4, 0x2195, 0x203c, 0x00b6, 0x00a7, 0x25ac, 0x21a8,
    0x2191, 0x2193, 0x2192, 0x2190, 0x221f, 0x2194, 0x25b2, 0x25bC,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
/* 0x60 */
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x2302,
/* 0x80 */
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7,
    0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x00ec, 0x00c4, 0x00c5,
/* 0x90 */
    0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00f2, 0x00fb, 0x00f9,
    0x00ff, 0x00d6, 0x00dc, 0x00a2, 0x00a3, 0x00a5, 0x20a7, 0x0192,
/* 0xa0 */
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x00aa, 0x00ba,
    0x00bf, 0x2310, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb,
/*0xb0*/
   0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556,
   0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510,
/*0xc0*/
   0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f,
   0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567,
/*0xd0*/
   0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256b,
   0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580,
/*0xe0*/
   0x03b1, 0x00df, 0x0393, 0x03c0, 0x2211, 0x03c3, 0x00b5, 0x03c4,
   0x03a6, 0x0398, 0x03a9, 0x03b4, 0x221e, 0x03c6, 0x03b5, 0x2229,
/*0xf0*/
   0x2261, 0x00b1, 0x2265, 0x2264, 0x2320, 0x2321, 0x2248, 0x0301,
   0x2219, 0x2219, 0x2027, 0x221a, 0x006e, 0x00b2, 0x25a0, 0x00a0
  }
};

/***************************************
 * PC-850 Multilingual Unicode mapping *
 ***************************************/
private const pl_symbol_map_t map_12U_unicode = {
  map_header(12, 'U', plgv_Unicode, 2, 0, 0, 0, 0, 0xe6, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0x263a, 0x263b, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022,
    0x25d8, 0x25cb, 0x25d9, 0x2642, 0x2640, 0x266a, 0x266b, 0x263c,
/* 0x10 */
    0x25ba, 0x25c4, 0x2195, 0x203c, 0x00b6, 0x00a7, 0x25ac, 0x21a8,
    0x2191, 0x2193, 0x2192, 0x2190, 0x221f, 0x2194, 0x25b2, 0x25bc,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
/* 0x60 */
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x2302,
/* 0x80 */
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7,
    0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x00ec, 0x00c4, 0x00c5,
/* 0x90 */
    0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00f2, 0x00fb, 0x00f9,
    0x00ff, 0x00d6, 0x00dc, 0x00f8, 0x00a3, 0x00d8, 0x00d7, 0x0192,
/* 0xa0 */
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x00aa, 0x00ba,
    0x00bf, 0x00ae, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb,
/*0xb0*/
   0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00c1, 0x00c2, 0x00c0,
   0x00a9, 0x2563, 0x2551, 0x2557, 0x255d, 0x00a2, 0x00a5, 0x2510,
/*0xc0*/
   0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x00e3, 0x00c3,
   0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x00a4,
/*0xd0*/
   0x00f0, 0x0110, 0x00c9, 0x00cb, 0x00c8, 0x0131, 0x00cd, 0x00ce,
   0x00cf, 0x2518, 0x250c, 0x2588, 0x2584, 0x00a6, 0x00cc, 0x2580,
/*0xe0*/
   0x00d3, 0x00df, 0x00d4, 0x00d2, 0x00f5, 0x00d5, 0x00b5, 0x00fe,
   0x00de, 0x00da, 0x00db, 0x00d9, 0x00fd, 0x00dd, 0x00af, 0x00b4,
/*0xf0*/
   0x00ad, 0x00b1, 0x2017, 0x00be, 0x00b6, 0x00a7, 0x00f7, 0x00b8,
   0x00b0, 0x00a8, 0x00b7, 0x00b9, 0x00b3, 0x00b2, 0x25aa, 0x00a0
  }
};

/********************************
 * PS Text (TS) Unicode mapping *
 ********************************/
private const pl_symbol_map_t map_10J_unicode = {
  map_header(10, 'J', plgv_Unicode, 1, 0, 0, 0, 0, 0xc0, 0x80, 0, 0, PLGV_U2M_MAPPING),
  {
/*0x00*/
  0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
  0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
/*0x01*/
   0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
   0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
/*0x02*/
   0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x2019,
   0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/*0x30*/
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/*0x40*/
   0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
   0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/*0x50*/
   0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
   0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
/*0x60*/
   0x2018, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
   0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/*0x70*/
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x0097,
/*0x80*/
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0x90*/
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xa0*/
   0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x002f, 0x00a5, 0x0192, 0x00a7,
   0x00a4, 0x0027, 0x201c, 0x00ab, 0x2039, 0x203a, 0xf001, 0xf002,
/*0xb0*/
   0xffff, 0x2013, 0x2020, 0x2021, 0x00b7, 0xffff, 0x00b6, 0x2022,
   0x002c, 0x201e, 0x201d, 0x00bb, 0x2026, 0x2030, 0xffff, 0x00bf,
/*0xc0*/
   0xffff, 0x0060, 0x2032, 0x02c6, 0x02dc, 0x02c9, 0x02d8, 0x02d9,
    0x00a8, 0xffff, 0x02d9, 0x00b8, 0xffff, 0x02dd, 0x02db, 0x02c7,
/*0xd0*/
    0x2014, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xe0*/
    0xffff, 0x00c6, 0xffff, 0x0061, 0xffff, 0xffff, 0xffff, 0xffff,
    0x0141, 0x00d8, 0x0152, 0x2070, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xf0*/
    0xffff, 0x00e6, 0xffff, 0xffff, 0xffff, 0x0131, 0xffff, 0xffff,
    0x0142, 0x00f8, 0x0153, 0x00df, 0xffff, 0xffff, 0xffff, 0xffff
  }
};

/********************************
 * MC Text (MC) Unicode mapping *
 ********************************/
private const pl_symbol_map_t map_12J_unicode = {
  map_header(12, 'J', plgv_Unicode, 1, 0, 0, 0, 0, 0xc1, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/*0x00*/
   0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
   0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
/*0x10*/
    0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
    0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
/*0x20*/
   0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
   0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/*0x30*/
   0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
   0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/*0x40*/
   0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
   0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/*0x50*/
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
/*0x60*/
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/*0x70*/
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0xffff,
/*0x80*/
   0x00c4, 0x00c5, 0x00c7, 0x00c9, 0x00d1, 0x00d6, 0x00dc, 0x00e1,
   0x00e0, 0x00e2, 0x00e4, 0x00e3, 0x00e5, 0x00e7, 0x00e9, 0x00e8,
/*0x90*/
    0x00ea, 0x00eb, 0x00ed, 0x00ec, 0x00ee, 0x00ef, 0x00f1, 0x00f3,
    0x00f3, 0x00f4, 0x00f6, 0x00f5, 0x00fa, 0x00f9, 0x00fb, 0x00fc,
/*0xa0*/
    0x2020, 0x00b0, 0x00a2, 0x00a3, 0x00a7, 0x2022, 0x00b6, 0x00df,
    0x00ae, 0x00a9, 0x2122, 0x2032, 0x00a8, 0x2260, 0x00c6, 0x00d8,
/*0xb0*/
    0x221e, 0x00b1, 0x2264, 0x2265, 0x00a5, 0x00b5, 0x2202, 0x2211,
    0x220f, 0x03c0, 0x222b, 0x0061, 0x2070, 0x03a9, 0x00e6, 0x00f8,
/*0xc0*/
   0x00bf, 0x00a1, 0x00ac, 0x221a, 0x0192, 0x2248, 0x2206, 0x00ab,
    0x00bb, 0x2026, 0x00a0, 0x00c0, 0x00c3, 0x00d5, 0x0152, 0x0153,
/*0xd0*/
   0x2212, 0x2014, 0x201c, 0x201d, 0x2018, 0x2019, 0x00f7, 0x25c7,
    0x00ff, 0x0178, 0x002f, 0x20ac, 0x2039, 0x203a, 0xf001, 0xf002,
/*0xe0*/
    0x2021, 0x00b7, 0x002c, 0x201e, 0x2030, 0x00c2, 0x00c9, 0x00c1,
     0x00cb, 0x00c8, 0x00cd, 0x00ce, 0x00cf, 0x00cc, 0x00d3, 0x00d4,
/*0xf0*/
    0xffff, 0x00d2, 0x00da, 0x00db, 0x00d9, 0x0131, 0x02c9, 0x02dc,
    0x02c9, 0x02d8, 0x02d9, 0x02da, 0x00b8, 0x02dd, 0x02db, 0x02c7
  }
};

/***********************************************
 * PC-8 Danish/Norweigian (PD) Unicode mapping *
 ***********************************************/
private const pl_symbol_map_t map_11U_unicode = {
  map_header(11, 'U', plgv_Unicode, 2, 0, 0, 0, 0, 0xc0, 0x40, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0x263a, 0x263b, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022,
    0x25d8, 0x25cb, 0x25d9, 0x2642, 0x2640, 0x266a, 0x266b, 0x263c,
/* 0x10 */
    0x25ba, 0x25c4, 0x2195, 0x203c, 0x00b6, 0x00a7, 0x25ac, 0x21a8,
    0x2191, 0x2193, 0x2192, 0x2190, 0x221f, 0x2194, 0x25b2, 0x25bC,
/*0x20*/
   0xffff, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
   0x0028, 0x0029, 0x002a, 0x253c, 0x002c, 0x002d, 0x002e, 0x002f,
/*0x30*/
   0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
   0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/*0x40*/
   0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
   0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/*0x50*/
   0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
   0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x02c6, 0x005f,
/*0x60*/
   0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
   0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/*0x70*/
   0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
   0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x2302,
/*0x80*/
   0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7,
   0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x00ec, 0x00c4, 0x00c5,
/*0x90*/
   0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00f2, 0x00fb, 0x00f9,
   0x00ff, 0x00d6, 0x00dc, 0x00f8, 0x00a3, 0x00d8, 0x013f, 0x0140,
/*0xa0*/
   0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x00f5, 0x00d5,
   0x00bf, 0x00e3, 0x00c3, 0x2113, 0x0149, 0x00a1, 0x00b3, 0x00a4,
/*0xb0*/
   0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556,
   0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510,
/*0xc0*/
   0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f,
   0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567,
/*0xd0*/
    0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x2565,
    0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580,
/*0xe0*/
   0x03b1, 0x00df, 0x0393, 0x03c0, 0x2211, 0x03c3, 0x00b5, 0x03c4,
   0x03a6, 0x0398, 0x03a9, 0x03b4, 0x221e, 0x00f8, 0x03b5, 0x2229,
/*0xf0*/
   0x2261, 0x00b1, 0x2265, 0x2264, 0x2320, 0x2321, 0x2248, 0x0301,
   0x2219, 0x2219, 0x2027, 0x221a, 0x006e, 0x00b2, 0x25a0, 0x00a0
  }
};

/******************************
 * Legal (LG) Unicode mapping *
 ******************************/
private const pl_symbol_map_t map_1U_unicode = {
  map_header(1, 'U', plgv_Unicode, 1, 0, 0, 0, 0, 0xc0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/*0x00*/
   0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
   0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x001e, 0x000f,
/*0x10*/
    0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
    0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
/*0x20*/
   0x0020, 0x0021, 0x2033, 0x0023, 0x0024, 0x0025, 0x0026, 0x2032,
   0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/*0x30*/
   0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
   0x0038, 0x0039, 0x003a, 0x003b, 0x2017, 0x003d, 0x00a2, 0x003f,
/*0x40*/
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/*0x50*/
   0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
   0x0058, 0x0059, 0x005a, 0x005b, 0x00ae, 0x005d, 0x00a9, 0x005f,
/*0x60*/
   0x00b0, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
   0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/*0x70*/
   0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
   0x0078, 0x0079, 0x007a, 0x00a7, 0x00b6, 0x2022, 0x2122, 0x2592,
/*0x80*/
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0x90*/
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xa0*/
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xb0*/
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xc0*/
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xd0*/
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xe0*/
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xf0*/
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
  }
};

/***************************************
 * Windows 3.0 Latin 1 Unicode mapping *
 ***************************************/
/*
 * This is identical to the ISO 8859/1 Latin 1 mapping, except that
 * it has added characters in positions 0x91 - 0x92.
 */
private const pl_symbol_map_t map_9U_unicode = {
  map_header(9, 'U', plgv_Unicode, 2, 0, 0, 0, 0, 0xcc, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
/* 0x60 */
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x2592,
/* 0x80 */
    0x20ac, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0x2018, 0x2019, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
    0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x203e,
/* 0xb0 */
    0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
    0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
/* 0xc0 */
    0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
    0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
/* 0xd0 */
    0x0110, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7,
    0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df,
/* 0xe0 */
    0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
    0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
/* 0xf0 */
    0x0111, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7,
    0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff
  }
};

/*********************************************
 * Microsoft Publishing (PB) Unicode mapping *
 *********************************************/
private const pl_symbol_map_t map_6J_unicode = {
  map_header(6, 'J', plgv_Unicode, 2, 0, 0, 0, 0, 0xc8, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x10 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0x20*/
   0x0020, 0x00b9, 0x201d, 0x00b3, 0x2074, 0x2075, 0x2077, 0x2019,
   0x2079, 0x2070, 0x2078, 0x2020, 0x002c, 0x2013, 0x2026, 0x002f,
/*0x30*/
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff, 0x201e, 0x2021, 0xffff, 0xffff,
/*0x40*/
  0x00b2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0x013d, 0x2014, 0x2013, 0x0152,
/*0x50*/
    0xffff, 0xffff, 0x211e, 0x0160, 0x2122, 0xffff, 0xffff, 0xffff,
    0xffff, 0x0178, 0x017d, 0xffff, 0xffff, 0xffff, 0x2076, 0x2017,
/*0x60*/
    0x2018, 0xffff, 0xffff, 0x2105, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x2113, 0xffff, 0xffff, 0x0153,
/*0x70*/
  0xffff, 0xffff, 0xffff, 0x0161, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0x017e, 0xffff, 0xffff, 0xffff, 0x201c, 0xffff,
/*0x80*/
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0x90*/
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x20a7, 0x0192,
/*0xa0*/
    0xffff, 0x2032, 0x2033, 0x005e, 0x007E, 0xffff, 0xffff, 0xffff,
    0xffff, 0xfb01, 0xfb02, 0xfb00, 0xfb03, 0xfb04, 0x2039, 0x203a,
/*0xb0*/
   0x00b0, 0x2219, 0x2022, 0xeffa, 0x25e6, 0x25cb, 0xeffd, 0x25aa,
   0x25a0, 0xeffb, 0x25ab, 0x25a1, 0xeffc, 0x2030, 0x25c6, 0x25c7,
/*0xc0*/
   0xffff, 0x0060, 0x00b4, 0x02c6, 0x02dc, 0x02c9, 0x02c7, 0x02d9,
   0x00a8, 0xffff, 0x02da, 0x00b8, 0xffff, 0x2033, 0x02db, 0x02c7,
/*0xd0*/
   0xffff, 0x0060, 0x00b4, 0x02c6, 0x02dc, 0x02c9, 0x02c7, 0x02d9,
   0x00a8, 0xffff, 0x02da, 0x00b8, 0xffff, 0x2033, 0x02db, 0x02c7,
/*0xe0*/
   0x03a9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x0132, 0x013f,
   0x0141, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x0149,
/*0xf0*/
   0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x0131, 0x0133, 0x0140,
   0x0142, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
  }
};

/**********************************
 * PC-852 Latin 2 Unicode mapping *
 **********************************/
private const pl_symbol_map_t map_17U_unicode = {
  map_header(17, 'U', plgv_Unicode, 2, 0, 0, 0, 0, 0xe4, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0xffff, 0x263a, 0x263b, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022,
    0x25d8, 0x25cb, 0x25d9, 0x2642, 0x2640, 0x266a, 0x266b, 0x263c,
/* 0x10 */
    0x25ba, 0x25c4, 0x2195, 0x203c, 0x00b6, 0x00a7, 0x25ac, 0x21a8,
    0x2191, 0x2193, 0x2192, 0x2190, 0x221f, 0x2194, 0x25b2, 0x25bc,
/* 0x20 */
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/* 0x30 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/* 0x40 */
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/* 0x50 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
/* 0x60 */
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/* 0x70 */
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x2302,
/* 0x80 */
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x016f, 0x0107, 0x00e7,
    0x0142, 0x00eb, 0x0150, 0x0151, 0x00ee, 0x0179, 0x00c4, 0x0106,
/* 0x90 */
    0x00c9, 0x0139, 0x013a, 0x00f4, 0x00f6, 0x013d, 0x013e, 0x015a,
    0x015b, 0x00d6, 0x00dc, 0x0164, 0x0165, 0x0141, 0x00d7, 0x010d,
/* 0xa0 */
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x0104, 0x0105, 0x017d, 0x017e,
    0x0118, 0x0119, 0xffff, 0x017a, 0x010c, 0x015f, 0x00ab, 0x00bb,
/*0xb0*/
   0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00c1, 0x00c2, 0x011a,
   0x015e, 0x2563, 0x2551, 0x2557, 0x255d, 0x017b, 0x017c, 0x2510,
/*0xc0*/
   0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x0102, 0x0103,
   0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x00a4,
/*0xd0*/
   0x0111, 0x0110, 0x010e, 0x00cb, 0x010f, 0x0147, 0x00cd, 0x00ce,
   0x011b, 0x2518, 0x250c, 0x2588, 0x2584, 0x0162, 0x016e, 0x2580,
/*0xe0*/
   0x00d3, 0x00df, 0x00d4, 0x0143, 0x0144, 0x0148, 0x0160, 0x0161,
   0x0154, 0x00da, 0x0155, 0x0170, 0x00fd, 0x00dd, 0x0163, 0x00b4,
/*0xf0*/
   0x00ad, 0x02dd, 0x02db, 0x02c7, 0x02d8, 0x00a7, 0x00f7, 0x00b8,
   0x00b0, 0x00a8, 0x00b7, 0x0171, 0x0158, 0x0159, 0x25aa, 0x00a0
  }
};


/************************************
 * PC-Turkish  (PT) Unicode mapping *
 ************************************/
private const pl_symbol_map_t map_9T_unicode = {
  map_header(9, 'T', plgv_Unicode, 2, 0, 0, 0, 0, 0xd0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/*0x00*/
0xffff, 0x263a, 0x263b, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022,
0x25d8, 0x25cb, 0x25d9, 0x2642, 0x2640, 0x266a, 0x266b, 0x263c,
/*0x10*/
0x25ba, 0x25c4, 0x2195, 0x203c, 0x00b6, 0x00a7, 0x25ac, 0x21a8,
0x2191, 0x2193, 0x2192, 0x2190, 0x221f, 0x2194, 0x25b2, 0x25bC,
/*0x20*/
0xffff, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
0x0028, 0x0029, 0x002a, 0x253c, 0x002c, 0x002d, 0x002e, 0x002f,
/*0x30*/
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/*0x40*/
0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/*0x50*/
0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d,  0x02c6, 0x005f,
/*0x60*/
0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/*0x70*/
0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x2302,
/*0x80*/
0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7,
0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x0131, 0x00c4, 0x00c5,
/*0x90*/
0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00f2, 0x00fb, 0x00f9,
0x0130, 0x00d6, 0x00dc, 0x00a2, 0x00a3, 0x00a5, 0x015e, 0x15f,
/*0xa0*/
0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x011e, 0x011f,
0x00bf, 0x2310, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb,
/*0xb0*/
0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556,
0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510,
/*0xc0*/
0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f,
0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567,
/*0xd0*/
0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256b,
0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580,
/*0xe0*/
0x03b1, 0x00df, 0x0393, 0x03c0, 0x2211, 0x03c3, 0x00b5, 0x03c4,
0x03a6, 0x0398, 0x03a9, 0x03b4, 0x221e, 0x00f8, 0x03b5, 0x2229,
/*0xf0*/
0x2261, 0x00b1, 0x2265, 0x2264, 0x2320, 0x2321, 0x2248, 0x0301,
0x2219, 0x2219, 0x2027, 0x221a, 0x006e, 0x00b2, 0x25a0, 0x00a0
  }
};

/*******************************************
 * ISO 8859/2 Latin 2 (E2) Unicode mapping *
 *******************************************/
private const pl_symbol_map_t map_2N_unicode = {
  map_header(2, 'N', plgv_Unicode, 1, 0, 0, 0, 0, 0xe0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/*0x00*/
0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
/*0x10*/
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
/*0x20*/
0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e,  0x002f,
/*0x30*/
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/*0x40*/
0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/*0x50*/
0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x02c6, 0x005f,
/*0x60*/
0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/*0x70*/
0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x02dc, 0x2592,
/*0x80*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0x90*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xa0*/
0x00a0, 0x0104, 0x02d8, 0x0141, 0x00a4, 0x013d, 0x015a, 0x00a7,
0x00a8, 0x0160, 0x015e, 0x0164, 0x0179, 0x00ad, 0x017d, 0x017b,
/*0xb0*/
0x00b0, 0x0105, 0x02db, 0x0142, 0x00b4, 0x013e, 0x015b, 0x02c7,
0x00b8, 0x0161, 0x015f, 0x0165, 0x017a, 0x02dd, 0x017e, 0x017c,
/*0xc0*/
0x0154, 0x00c1, 0x00c2, 0x0102, 0x00c4, 0x0139, 0x0106, 0x00c7,
0x010c, 0x00c9, 0x0118, 0x00cb, 0x0114, 0x00cd, 0x00ce, 0x010e,
/*0xd0*/
0x00d0, 0x0143, 0x0147, 0x00de, 0x00d4, 0x0150, 0x00d6, 0x00d7,
0x0158, 0x016e, 0x00da, 0x0170, 0x00dc, 0x00dd, 0x0162, 0x00df,
/*0xe0*/
0x0155, 0x00e1, 0x00e2, 0x0103, 0x00e4, 0x013a, 0x0107, 0x00e7,
0x010d, 0x00e9, 0x0119, 0x00eb, 0x011b, 0x00ed, 0x00ee, 0x010f,
/*0xf0*/
0x0111, 0x0144, 0x0148, 0x00f3, 0x00f4, 0x0151, 0x00f6, 0x00f7,
0x0159, 0x016f, 0x00fa, 0x0171, 0x00fc, 0x00fd, 0x0163, 0x00b7
  }
};

/********************************************
 * Windows 3.1 Latin 2 (WE) Unicode mapping *
 ********************************************/
private const pl_symbol_map_t map_9E_unicode = {
  map_header(9, 'E', plgv_Unicode, 2, 0, 0, 0, 0, 0xe0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/*0x00*/
0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
/*0x10*/
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
/*0x20*/
0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/*0x30*/
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/*0x40*/
0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/*0x50*/
0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x02c6, 0x005f,
/*0x60*/
0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/*0x70*/
0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x023c, 0x0097,
/*0x80*/
0x20ac, 0xffff, 0x002c, 0xffff, 0x201e, 0x2026, 0x2020, 0x2021,
0xffff, 0x2030, 0x0160, 0x2039, 0x015a, 0x0164, 0x017d, 0x0179,
/*0x90*/
0xffff, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014,
0xffff, 0x2122, 0x0161, 0x203a, 0x015b, 0x0165, 0x017e, 0x017a,
/*0xa0*/
0x00a0, 0x02c7, 0x02c6, 0x0141, 0x00a4, 0x0104, 0x00a6, 0x00a7,
0x00a8, 0x00a9, 0x015e, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x017b,
/*0xb0*/
0x00b0, 0x00b1, 0x02db, 0x0142, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
0x00b8, 0x0105, 0x015f, 0x00bb, 0x013d, 0x02dd, 0x013e, 0x017c,
/*0xc0*/
0x0154, 0x00c1, 0x00c2, 0x0102, 0x00c4, 0x0139, 0x0106, 0x00c7,
0x010c, 0x00c9, 0x0118, 0x00cb, 0x011a, 0x00cd, 0x00ce, 0x010e,
/*0xd0*/
0x00d0, 0x0143, 0x0147, 0x00d3, 0x00d4, 0x0150, 0x00d6, 0x00d7,
0x0158, 0x016e, 0x00da, 0x0170, 0x00dc, 0x00dd, 0x0162, 0x00df,
/*0xe0*/
0x0155, 0x00e1, 0x00e2, 0x0103, 0x00e4, 0x013a, 0x0107, 0x00e7,
0x010d, 0x00e9, 0x0119, 0x00eb, 0x011b, 0x00ed, 0x00ee, 0x010f,
/*0xf0*/
0x0111, 0x0144, 0x0148, 0x00f3, 0x00f4, 0x0151, 0x00f6, 0x00f7,
0x0159, 0x016f, 0x00fa, 0x0171, 0x00fc, 0x00fd, 0x0163, 0x00b7,
  }
};

/*******************************************
 * ISO 8859/9 Latin 5 (E5) Unicode mapping *
 *******************************************/
private const pl_symbol_map_t map_5N_unicode = {
  map_header(5, 'N', plgv_Unicode, 1, 0, 0, 0, 0, 0xd0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/*0x00*/
0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
/*0x10*/
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e,  0x001f,
/*0x20*/
0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/*0x30*/
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/*0x40*/
0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/*0x50*/
0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
/*0x60*/
0x0060, 0x0061, 0x0062, 0x0063, 0x0063, 0x0065, 0x0066, 0x0067,
0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/*0x70*/
0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x02dc, 0x2592,
/*0x80*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0x90*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xa0*/
0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
0x00a8, 0x00a9, 0x0061, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af,
/*0xb0*/
0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
0x00b8, 0x00b9, 0x2070, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
/*0xc0*/
0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
/*0xd0*/
0x011e, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7,
0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x0130, 0x015e, 0x00df,
/*0xe0*/
0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
/*0xf0*/
0x011f, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7,
0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x0131, 0x015f, 0x00ff
  }
};

/********************************************
 * Windows 3.1 Latin 5 (WT) Unicode mapping *
 ********************************************/
private const pl_symbol_map_t map_5T_unicode = {
  map_header(5, 'T', plgv_Unicode, 2, 0, 0, 0, 0, 0xd0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/*0x00*/
0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
/*0x10*/
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
/*0x20*/
0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
/*0x30*/
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/*0x40*/
0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
/*0x50*/
0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x02c6, 0x005f,
/*0x60*/
0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
/*0x70*/
0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x2592,
/*0x80*/
0x20ac, 0xffff, 0x002c, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021,
0x02c6, 0x2030, 0x0160, 0x2039, 0x0152, 0xffff, 0xffff, 0xffff,
 /*0x90*/
0xffff, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014,
0x02dc, 0x2122, 0x0161, 0x203a, 0x0153, 0xffff, 0xffff, 0x0178,
/*0xa0*/
0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
0x00a8, 0x00a9, 0x0061, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af,
/*0xb0*/
0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
0x00b8, 0x00b9, 0x2070, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
/*0xc0*/
0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
/*0xd0*/
0x011e, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7,
0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x0130, 0x015e, 0x00df,
/*0xe0*/
0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7,
0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef,
/*0xf0*/
0x011f, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7,
0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x0131, 0x015f, 0x00ff
  }
};

/*******************************
 * Math-8 (M8) Unicode mapping *
 *******************************/
private const pl_symbol_map_t map_8M_unicode = {
  map_header(8, 'M', plgv_Unicode, 1, 0, 0, 0, 4, 0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/*0x00*/
0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
/*0x10*/
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
/*0x20*/
0x0020, 0x221a, 0x2033, 0x00b0, 0x221e, 0x00f7, 0x221d, 0x2032,
0x0028, 0x0029, 0x00d7, 0x002b, 0x002c, 0x2212, 0x002e, 0x2215,
/*0x30*/
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
0x0038, 0x0039, 0x212f, 0xefec, 0x003c, 0x003d, 0x003e, 0x2243,
/*0x40*/
0x2234, 0x0041, 0x0042, 0x0393, 0x2206, 0x0045, 0x005a, 0x0048,
0x0398, 0x0049, 0x004b, 0x039b, 0x004d, 0x004e, 0x039e, 0x004f,
/*0x50*/
0x03a0, 0x0050, 0x03a3, 0x0054, 0x03a5, 0x03a6, 0x0058, 0x03a8,
0x03a9, 0x2207, 0x2202, 0x03c2, 0x2264, 0x2260, 0x2265, 0x005f,
/*0x60*/
0x2235, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7,
0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf,
/*0x70*/
0x03c0, 0x03c1, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8,
0x03c9, 0x03d1, 0x03d5, 0x03d6, 0x2243, 0x2261, 0x2262, 0x2592,
/*0x80*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0x90*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xa0*/
0xffff, 0x2191, 0x2192, 0x2193, 0x2190, 0x21d1, 0x21d2, 0x21d3,
0x21d0, 0x2195, 0x2194, 0x21d5, 0x21d4, 0x21c4, 0x21c6, 0xefe9,
/*0xb0*/
0xefea, 0x2200, 0x2203, 0x22a4, 0x22a5, 0x222a, 0x2229, 0x2208,
0x220b, 0x2209, 0x2282, 0x2283, 0x2284, 0x2285, 0x2286, 0x2287,
/*0xc0*/
0x2295, 0x2299, 0x2297, 0x2296, 0x2298, 0x2227, 0x2228, 0x22bb,
0x00ac, 0x25e6, 0x2219, 0x2022, 0x25cf, 0x25cb, 0x2020, 0x2021,
/*0xd0*/
0x00c5, 0x22a3, 0x22a2, 0x221f, 0x220d, 0x222b, 0x222e, 0x2220,
0x2205, 0x2135, 0x2136, 0x2137, 0x212d, 0x2111, 0x211c, 0x2128,
/*0xe0*/
0xefe7, 0xefe6, 0xefe3, 0xefe2, 0xefe1, 0x2320, 0xefd4, 0x2321,
0xefd3, 0x2225, 0xefd2, 0xefd1, 0xefe8, 0xefcb, 0x002a, 0x2245,
/*0xf0*/
0xefe5, 0xefe4, 0xefe0, 0xefdf, 0xefde, 0xefdd, 0x2502, 0xefdc,
0xefd0, 0xefcf, 0xefce, 0xefcd, 0xefcc, 0x2213, 0x00b1, 0xffff
  }
};

/*******************************
 * PI Font(PI) Unicode mapping *
 *******************************/
private const pl_symbol_map_t map_15U_unicode = {
  map_header(15, 'U', plgv_Unicode, 1, 0, 0, 0, 4, 0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/*0x00*/
0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
/*0x10*/
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
/*0x20*/
0x0020, 0xffff, 0x201e, 0x201a, 0x201c, 0x201d, 0x02bb, 0x02bc,
0x2329, 0x232a, 0x2122, 0x2120, 0x00ae, 0x00a9, 0x0623, 0xffff,
/*0x30*/
0x02c9, 0x02d8, 0x02c7, 0x02d9, 0x2127, 0x2198, 0x2199, 0x2196,
0x25b5, 0x25b9, 0x25bf, 0x25c3, 0x0633, 0x00a7, 0x0634, 0x00b6,
/*0x40*/
0x2237, 0x0636, 0xffff, 0xffff, 0xffff, 0xffff, 0x0637, 0xffff,
0x210f, 0xffff, 0xffff, 0xffff, 0x2112, 0x2113, 0xffff, 0xffff,
/*0x50*/
0x0640, 0x2118, 0x211e, 0x2211, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0x301a, 0x2225, 0x301b, 0x2039, 0x203a,
/*0x60*/
0x250c, 0x2514, 0x256d, 0x2570, 0x2086, 0x251c, 0x2500, 0x0243,
0x222a, 0x2229, 0x2553, 0x2559, 0x25a1, 0x25c7, 0xffff, 0xffff,
/*0x70*/
0x2510, 0x2518, 0x256e, 0x256f, 0x252c, 0x2524, 0x2534, 0x2223,
0x0657, 0x0658, 0x2556, 0x255c, 0x25ad, 0x25c6, 0xffff, 0x0097,
/*0x80*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0x90*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xa0*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xb0*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xc0*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xd0*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xe0*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xf0*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
  }
};

/********************************
 * PS Math (MS) Unicode mapping *
 ********************************/
private const pl_symbol_map_t map_5M_unicode = {
  map_header(5, 'M', plgv_Unicode, 1, 0, 0, 0, 4, 0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/*0x00*/
0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
/*0x10*/
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
/*0x20*/
0x0020, 0x0021, 0x2200, 0x0023, 0x2203, 0x0025, 0x0026, 0x220d,
0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x2212, 0x002e, 0x2215,
/*0x30*/
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/*0x40*/
0x2245, 0x0041, 0x0042, 0x0058, 0x2206, 0x0045, 0x03a6, 0x0393,
0x0048, 0x0049, 0x03d1, 0x004b, 0x039b, 0x004d, 0x004e, 0x004f,
/*0x50*/
0x220f, 0x0398, 0x0050, 0x2211, 0x0054, 0x0059, 0x03c2, 0x03a9,
0x039e, 0x03a8, 0x005a, 0x005b, 0x2234, 0x005d, 0x22a5, 0x005f,
/*0x60*/
0x00af, 0x03b1, 0x03b2, 0x03c7, 0x03b4, 0x03b5, 0x03c6, 0x03b3,
0x03b7, 0x0131, 0x03d5, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03bf,
/*0x70*/
0x03c0, 0x03b8, 0x03c1, 0x03c3, 0x03c4, 0x03c5, 0x0548, 0x03c9,
0x03be, 0x03c8, 0x03b6, 0x007b, 0x007c, 0x007d, 0x007e, 0xffff,
/*0x80*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0x90*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xa0*/
0xffff, 0x03a5, 0x2032, 0x2264, 0x2215, 0x221e, 0x0192, 0x2663,
0x2666, 0x2665, 0x2660, 0x2194, 0x2190, 0x2191, 0x2192, 0x2193,
/*0xb0*/
0x00b0, 0x00b1, 0x2033, 0x2265, 0x00d7, 0x221d, 0x2202, 0x2022,
0x00f7, 0x2260, 0x2261, 0x2243, 0x2026, 0x007c, 0x2014, 0x21b5,
/*0xc0*/
0x2135, 0x2111, 0x211c, 0x2118, 0x2297, 0x2295, 0x2205, 0x2229,
0x222a, 0x2283, 0x2287, 0x2284, 0x2282, 0x2286, 0x2208, 0x2209,
/*0xd0*/
0x2220, 0x2207, 0xefdb, 0xefda, 0xefd9, 0x220f, 0x221a, 0x002e,
0x00ac, 0x2227, 0x2228, 0x21d4, 0x21d0, 0x21d1, 0x21d2, 0x21d3,
/*0xe0*/
0x25c7, 0x2329, 0xefd8, 0xefd7, 0xefd6, 0x2211, 0xefe3, 0xefdd,
0xefe1, 0xefe7, 0x2502, 0xefe6, 0xefe3, 0xefe2, 0xefe1, 0xefdd,
/*0xf0*/
0x00a4, 0x232a, 0x222b, 0x2320, 0xefdd, 0x2321, 0xefe0, 0xefdd,
0xefde, 0xefe5, 0x2502, 0xefe4, 0xefe0, 0xefdf, 0xefde, 0xffff
  }
};

/************************************
 * Symbol Font (AS) Unicode mapping *
 ************************************/
private const pl_symbol_map_t map_19M_unicode = {
  map_header(19, 'M', plgv_Unicode, 1, 0, 0, 0, 4, 0, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/*0x00*/
0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
/*0x10*/
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
/*0x20*/
0x0020, 0x0021, 0x2200, 0x0023, 0x2203, 0x0025, 0x0026, 0x220d,
0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x2212, 0x002e, 0x2215,
/*0x30*/
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
/*0x40*/
0x2245, 0x0391, 0x0392, 0x0058, 0x2206, 0x0395, 0x03a6, 0x0393,
0x0397, 0x0399, 0x0546, 0x039a, 0x039b, 0x039c, 0x039d, 0x039f,
/*0x50*/
0x220f, 0x0398, 0x03a1, 0x2211, 0x03a4, 0x0059, 0x03da, 0x03a9,
0x039e, 0x03ab, 0x005a, 0x005b, 0x2234, 0x005d, 0x22a5, 0x208b,
/*0x60*/
0xffff, 0x03b1, 0x03b2, 0x03c7, 0x03b4, 0x0503, 0x03c6, 0x03b3,
0x03b7, 0x03b9, 0x03d5, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03bf,
/*0x70*/
0x03c0, 0x03b8, 0x03c1, 0x03c3, 0x03c4, 0x03c5, 0x0548, 0x03c9,
0x03be, 0x03cb, 0x03b6, 0x007b, 0x007c, 0x007d, 0x007e, 0xffff,
/*0x80*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0x90*/
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/*0xa0*/
0xffff, 0x03d2, 0x2032, 0x2264, 0x2215, 0x221e, 0x00a3, 0x2663,
0x2666, 0x2764, 0x2660, 0x2194, 0x2190, 0x2191, 0x2192, 0x2193,
/*0xb0*/
0x00b0, 0x00b1, 0x2133, 0x2265, 0x00d7, 0x221d, 0x2202, 0x2022,
0x00f7, 0x2260, 0x2261, 0x2243, 0x2026, 0xffff, 0x2014, 0x21b5,
/*0xc0*/
0x2135, 0x0595, 0x211c, 0x2118, 0x2297, 0x2295, 0x2205, 0x2229,
0x222a, 0x2283, 0x2287, 0x2284, 0x2282, 0x2286, 0x2208, 0x2209,
/*0xd0*/
0x0606, 0x2207, 0x00ae, 0x00a9, 0x2122, 0x220f, 0x221a, 0x002e,
0x00ac, 0x2227, 0x2228, 0x21d4, 0x21d0, 0x21d1, 0x21d2, 0x2103,
/*0xe0*/
0x25c7, 0x2329, 0x2093, 0x2063, 0x1105, 0x2211, 0x0600, 0x2503,
0x0602, 0x2308, 0x2502, 0x230a, 0x0600, 0x0601, 0x0602, 0x2758,
/*0xf0*/
0xffff, 0x232a, 0x222b, 0x2320, 0x2503, 0x2321, 0x0610, 0x2503,
0x0612, 0x2309, 0x2502, 0x230b, 0x0610, 0x0611, 0x0612, 0xffff
  }
};

/***********************************
 * Wingdings Font (L$) MSL mapping *
 ***********************************/
private const pl_symbol_map_t map_579L_msl = {
  map_header(579, 'L', plgv_MSL, 2, 0, 0, 0, 1, 0, 0, 0, 0, PLGV_NO_MAPPING),
  {
/*00*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*10*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*20*/
ffff, ffff, 2097, 2109, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*30*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, 2458, 2515,
/*40*/
ffff, 2313, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff,  203, ffff, ffff, ffff, ffff, ffff,
/*50*/
ffff, 2013, ffff, ffff, 2464, ffff, 2076, ffff,
2230, 2079, ffff, ffff, ffff, ffff, ffff, ffff,
/*60*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff,  209, 2116,  661, ffff,
/*70*/
ffff, 2250, 2308, ffff, 2433, 2491, 2089, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*80*/
ffff, 2016, 2017, 2018, 2019, 2020, 2021, 2022,
2023, 2024, 2015, ffff, 2000, 2031, 2002, 2003,
/*90*/
2004, 2061, 2005, 2009, 2007, 2008, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff,  302,  331,
/*a0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff,  305,
ffff, ffff, ffff, 2083, ffff, 2737, ffff, 2479,
/*b0*/
ffff, ffff, ffff, ffff, ffff, 2052, 2056, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*c0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*d0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, 2412, ffff, ffff, 2505,
/*e0*/
2237, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
2241, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*f0*/
2469, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, 1108, 2027, 2010, ffff, ffff, ffff
  }
};

/*****************************************
 * PS ITC Zapf Dingbats (DS) MSL mapping *
 *****************************************/
private const pl_symbol_map_t map_10L_msl = {
  map_header(10, 'L', plgv_MSL, 1, 0, 0, 0, 1, 0, 0, 0, 0, PLGV_NO_MAPPING),
  {
/*00*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*10*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*20*/
ffff, 2109, 2096, 2120, 2497, 2498, 2315, 2458,
2013, 2108, 2095, 2295, 2313, 2515, 2499, 2307,
/*30*/
2710, 2324, 2121, 2010, 2210, 2286, 2254, 2027,
2077, 2444, 2054, 2488, 2456, 2044, 2076, 2476,
/*40*/
2230, 2411, 2014, 2472, 2478, 2502, 2448, 2011,
2051, 2729, 2052, 2047, 2032, 2060, 2078, 2092,
/*50*/
2058, 2256, 2252, 2484, 2447, 2479, 2046, 2090,
2240, 2739, 2452, 2279, 2483, 2430, 2290, 2451,
/*60*/
2460, 2288, 2490, 2258, 2464, 2492, 2432, 2260,
2292, 2072, 2264, 2232, 2091, 2116, 2291, 2282,
/*70*/
2325, 2250, 2308, 2048, 2248, 2491, 2089, 2281,
2480, 2486, 2454, 2100, 2113, 2501, 2517, ffff,
/*80*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*90*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*a0*/
ffff, 2500, 2428, 2410, 2414, 2213, 2317, 2300,
2445, 2433, 2453, 2434, 2216, 217, 2218, 2219,
/*b0*/
2220, 2221, 2222, 2223, 2224, 2215, 2200, 2231,
2202, 2203, 2204, 2261, 2205, 2209, 2207, 2208,
/*c0*/
2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023,
2024, 2015, 2000, 2031, 2002, 2003, 2004, 2061,
/*d0*/
2005, 2009, 2007, 2008, 2306, 2042, 2043, 2075,
2233, 2305, 2310, 2053, 2037, 2070, 2071, 2520,
/*e0*/
2504, 2001, 2267, 2326, 2235, 2055, 2087, 2041,
2262, 2441, 2523, 2442, 2507, 2443, 2508, 2475,
/*f0*/
ffff, 2524, 2412, 2234, 2265, 2287, 2327, 2245,
2105, 2309, 2285, 2253, 2242, 2104, 2212, 2003
  }
};

/*************************************************
 * ITC Zapf Dingbats series 100 (D1) MSL mapping *
 *************************************************/
private const pl_symbol_map_t map_11L_msl = {
  map_header(11, 'L', plgv_MSL, 1, 0, 0, 0, 1, 0, 0, 0, 0, PLGV_NO_MAPPING),
  {
/*00*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*10*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*20*/
ffff, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014,
/*30*/
2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022,
2023, 2024, 2025, 2026, 2229, 2028, 2029, 2030,
/*40*/
2031, 2032, 2038, 2034, 2323, 2036, 2037, 2070,
2039, 2040, 2041, 2042, 2043, 2044, 2045, 2046,
/*50*/
2047, 2048, 2049, 2050, 2051, 2052, 2053, 2054,
2055, 2064, 2057, 2058, 2059, 2060, 2061, 2062,
/*60*/
2063, 2088, 2065, 2066, 2067, 2068, 2069, 2038,
2071, 2072, 2073, 2074, 2075, 2076, 2077, 2078,
/*70*/
2079, 2080, 2081, 2082, 2083, 2046, 2085, 2086,
2087, 2056, 2089, 2090, 2091, 2092, 2093, ffff,
/*80*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*90*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*a0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*b0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*c0*/
ffff, 2094, 2095, 2096, 2097, 2098, 2099, 2110,
2101, 2425, 2426, 2104, 2105, 2106, ffff, ffff,
/*d0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*e0*/
ffff, 2495, 2108, 2109, 2110, 2111, 2112, 2113,
2114, 2115, 2116, 2117, 2118, 2119, ffff, ffff,
/*f0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff
  }
};

/*************************************************
 * ITC Zapf Dingbats series 200 (D2) MSL mapping *
 *************************************************/
private const pl_symbol_map_t map_12L_msl = {
  map_header(12, 'L', plgv_MSL, 1, 0, 0, 0, 1, 0, 0, 0, 0, PLGV_NO_MAPPING),
  {
/*00*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*10*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*20*/
ffff, 2200, 2201, 2202, 2203, 2204, 2205, 2206,
2207, 2208, 2209, 2210, 2211, 2212, 2213, 2214,
/*30*/
2215, 2216, 2217, 2218, 2219, 2220, 2221, 2222,
2223, 2224, 2225, 2226, 2239, 2228, 2229, 2230,
/*40*/
2231, 2232, 2233, 2234, 2235, 2236, 2237, 2238,
2273, 2240, 2241, 2242, 2243, 2244, 2245, 2246,
/*50*/
2247, 2248, 2249, 2250, 2251, 2252, 2253, 2254,
2255, 2256, 2257, 2258, 2259, 2260, 2261, 2262,
/*60*/
2263, 2264, 2265, 2266, 2267, 2268, 2269, 2270,
2271, 2739, 2241, 2274, 2275, 2276, 2277, 2430,
/*70*/
2279, 2280, 2281, 2282, 2251, 2284, 2285, 2286,
2287, 2288, 2289, 2290, 2291, 2292, 2293, ffff,
/*80*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*90*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*a0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*b0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*c0*/
ffff, 2294, 2295, 2296, 2297, 2298, 2299, 2300,
2301, 2302, 2303, 2304, 2305, 2306, ffff, ffff,
/*d0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*e0*/
ffff, 2494, 2095, 2313, 2314, 2315, 2316, 2317,
2318, 2319, 2320, 2321, 2322, 2271, ffff, ffff,
/*f0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff
  }
};

/*************************************************
 * ITC Zapf Dingbats series 300 (D3) MSL mapping *
 *************************************************/
private const pl_symbol_map_t map_13L_msl = {
  map_header(13, 'L', plgv_MSL, 1, 0, 0, 0, 1, 0, 0, 0, 0, PLGV_NO_MAPPING),
  {
/*00*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*10*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*20*/
ffff, 2400, 2401, 2402, 2403, 2404, 2405, 2406,
2407, 2408, 2409, 2410, 2411, 2412, 2413, 2414,
/*30*/
2415, 2416, 2417, 2418, 2419, 2420, 2421, 2422,
2423, 2424, 2425, 2426, 2427, 2428, 2429, 2430,
/*40*/
2431, 2432, 2433, 2434, 2435, 2436, 2437, 2438,
2439, 2440, 2441, 2442, 2443, 2444, 2445, 2446,
/*50*/
2477, 2488, 2499, 2450, 2451, 2452, 2453, 2454,
2455, 2456, 2457, 2458, 2459, 2460, 2461, 2462,
/*60*/
2463, 2464, 2465, 2466, 2467, 2468, 2469, 2470,
2471, 2427, 2473, 2474, 2475, 2476, 2477, 2478,
/*70*/
2479, 2480, 2481, 2482, 2483, 2484, 2485, 2486,
2487, 2488, 2457, 2490, 2491, 2492, 2493, ffff,
/*80*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*90*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*a0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*b0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*c0*/
ffff, 2494, 2107, 2496, 2497, 2498, 2499, 2500,
2501, 2502, 2252, 2504, 2505, 2506, ffff, ffff,
/*d0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
/*e0*/
ffff, 2510, 2511, 2512, 2513, 2514, 2515, 2516,
2517, 2518, 2519, 2520, 2521, 2522, ffff, ffff,
/*f0*/
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff,
ffff, ffff, ffff, ffff, ffff, ffff, ffff, ffff
  }
};

/*************************************************************
 * HP-GL/2 stick font extended character set Unicode mapping *
 * (Note: this symbol set is not documented anywhere.)       *
 *************************************************************/
private const pl_symbol_map_t map_0E_unicode = {
  map_header(0, 'E', plgv_Unicode, 0, 0, 0, 0, 0, 0x40, 0, 0, 0, PLGV_U2M_MAPPING),
  {
/* 0x00 */
    0x0000, 0x0002, 0x0001, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
    0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f,
/* 0x10 */
    0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
    0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f,
/* 0x20 */
    0x0020, 0x00c0, 0x00c2, 0x00c8, 0x00ca, 0x00cb, 0x00ce, 0x00cf,
    0x02ca, 0x02cb, 0x005e, 0x00a8, 0x02dc, 0x00d9, 0x00db, 0x00a3,
/* 0x30 */
    0x00af, 0x00dd, 0x00fd, 0x00b0, 0x00c7, 0x00e7, 0x00d1, 0x00f1,
    0x00a1, 0x00bf, 0x00a4, 0x00a3, 0x00a5, 0x00a7, 0x0192, 0x00a2,
/* 0x40 */
    0x00e2, 0x00ea, 0x00f4, 0x00fb, 0x00e1, 0x00e9, 0x00f3, 0x00fa,
    0x00e0, 0x00e8, 0x00f2, 0x00f9, 0x00e4, 0x00eb, 0x00f6, 0x00fc,
/* 0x50 */
    0x00c5, 0x00ee, 0x00d8, 0x00c6, 0x00e5, 0x00ed, 0x00fb, 0x00e6,
    0x00c4, 0x00ec, 0x00d6, 0x00dc, 0x00c9, 0x00ef, 0x00df, 0x00d4,
/* 0x60 */
    0x00c1, 0x00c3, 0x00e3, 0x00d0, 0x00f0, 0x00cd, 0x00cc, 0x00d3,
    0x00d2, 0x00d5, 0x00f5, 0x0160, 0x0161, 0x00da, 0x0178, 0x00ff,
/* 0x70 */
    0x00de, 0x00fe, 0x00b7, 0x00b5, 0x00b6, 0x00be, 0x002d, 0x00bc,
    0x00bd, 0x00aa, 0x00ba, 0x00ab, 0x25a1, 0x00bb, 0x00b1, 0xffff,
/* 0x80 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0x90 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xa0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xb0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xc0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xd0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xe0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
/* 0xf0 */
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
  }
};

/*
 * Define the list of built-in symbol maps.
 */
const pl_symbol_map_t *pl_built_in_symbol_maps[] = {
  &map_0U_unicode,
  &map_1E_unicode,
  &map_1F_unicode,
  &map_1G_unicode,
  &map_0I_unicode,
  &map_0S_unicode,
  &map_2S_unicode,
  &map_0D_unicode,
  &map_8U_unicode,
  &map_7J_unicode,
  &map_19U_unicode,
  &map_0N_unicode,
  &map_10U_unicode,
  &map_12U_unicode,
  &map_10J_unicode,
  &map_12J_unicode,
  &map_11U_unicode,
  &map_1U_unicode,
  &map_9U_unicode,
  &map_6J_unicode,
  &map_17U_unicode,
  &map_9T_unicode,
  &map_2N_unicode,
  &map_9E_unicode,
  &map_5N_unicode,
  &map_5T_unicode,
  &map_8M_unicode,
  &map_15U_unicode,
  &map_5M_unicode,
  &map_19M_unicode,
  &map_579L_msl,
  &map_10L_msl,
  &map_11L_msl,
  &map_12L_msl,
  &map_13L_msl,
  &map_0E_unicode,
  0                 /* end marker */
};

const int pl_built_in_symbol_map_count =
  countof(pl_built_in_symbol_maps) - 1;


ulong
pl_map_symbol(const pl_symbol_map_t *psm, uint chr, bool resident_font)
{
    uint first_code, last_code;
    /*
     * If there is no symbol map we assume the the character
     * implicitly indexes the font.
     */
    if (psm == 0) {
	if ( resident_font )
	    return chr + 0xf000;
        else
            return chr;
    }

    first_code = pl_get_uint16(psm->first_code);
    last_code = pl_get_uint16(psm->last_code);
    if ((chr < first_code) || (chr > last_code))
	return ((last_code <= 0xff) && (chr > 0xff) ? chr : 0xffff);
    else
        return psm->codes[chr - first_code];
}

        

