/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.compound;

import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.PortType;

public class CrossHierarchyEdge {
    private LEdge newEdge;
    private LGraph graph;
    private PortType type;

    CrossHierarchyEdge(LEdge newEdge, LGraph graph, PortType type) {
        this.newEdge = newEdge;
        this.graph = graph;
        this.type = type;
    }

    public String toString() {
        return this.type.toString() + ":" + this.newEdge.toString();
    }

    public LEdge getEdge() {
        return this.newEdge;
    }

    public LGraph getGraph() {
        return this.graph;
    }

    public PortType getType() {
        return this.type;
    }

    public LPort getActualSource() {
        if (this.newEdge.getSource().getNode().getType() == LNode.NodeType.EXTERNAL_PORT) {
            return (LPort)this.newEdge.getSource().getNode().getProperty(InternalProperties.ORIGIN);
        }
        return this.newEdge.getSource();
    }

    public LPort getActualTarget() {
        if (this.newEdge.getTarget().getNode().getType() == LNode.NodeType.EXTERNAL_PORT) {
            return (LPort)this.newEdge.getTarget().getNode().getProperty(InternalProperties.ORIGIN);
        }
        return this.newEdge.getTarget();
    }
}

