/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import com.plantuml.ubrex.UMatcher;
import com.plantuml.ubrex.UnicodeBracketedExpression;
import java.util.Objects;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public abstract class UBrexSingleLineCommand2<S extends Diagram>
implements Command<S> {
    private final UnicodeBracketedExpression pattern;
    private final boolean doTrim;

    public UBrexSingleLineCommand2(UnicodeBracketedExpression pattern) {
        this(true, pattern);
    }

    public UBrexSingleLineCommand2(boolean doTrim, UnicodeBracketedExpression pattern) {
        this.doTrim = doTrim;
        this.pattern = Objects.requireNonNull(pattern);
    }

    public boolean syntaxWithFinalBracket() {
        return false;
    }

    private String myTrim(StringLocated s) {
        if (this.doTrim) {
            return s.getTrimmed().getString();
        }
        return s.getString();
    }

    private StringLocated myTrim2(StringLocated s) {
        if (this.doTrim) {
            return s.getTrimmed();
        }
        return s;
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        if (lines.size() == 2 && this.syntaxWithFinalBracket()) {
            return this.isValidBracket(lines);
        }
        if (lines.size() != 1) {
            return CommandControl.NOT_OK;
        }
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        StringLocated line2 = this.myTrim2(lines.getFirst());
        if (this.syntaxWithFinalBracket() && !line2.getString().endsWith("{")) {
            String vline = lines.getAt(0).getString() + " {";
            if (this.isValid(BlocLines.singleString(vline)) == CommandControl.OK) {
                return CommandControl.OK_PARTIAL;
            }
            return CommandControl.NOT_OK;
        }
        UMatcher result = this.pattern.match(line2.getString());
        if (result.exactMatch()) {
            return this.finalVerification();
        }
        return CommandControl.NOT_OK;
    }

    private CommandControl isValidBracket(BlocLines lines) {
        assert (lines.size() == 2);
        assert (this.syntaxWithFinalBracket());
        if (!this.myTrim(lines.getAt(1)).equals("{")) {
            return CommandControl.NOT_OK;
        }
        String vline = lines.getAt(0).getString() + " {";
        return this.isValid(BlocLines.singleString(vline));
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected CommandControl finalVerification() {
        return CommandControl.OK;
    }

    @Override
    public final CommandExecutionResult execute(S system, BlocLines lines, ParserPass currentPass) {
        if (this.syntaxWithFinalBracket() && lines.size() == 2) {
            assert (this.myTrim(lines.getAt(1)).equals("{"));
            lines = BlocLines.singleString(lines.getFirst().getString() + " {");
        }
        if (lines.size() != 1) {
            throw new IllegalArgumentException();
        }
        StringLocated first = lines.getFirst();
        String line = this.myTrim(first);
        if (this.isForbidden(line)) {
            return CommandExecutionResult.error("Syntax error: " + line);
        }
        UMatcher result = this.pattern.match(line);
        if (!result.exactMatch()) {
            return CommandExecutionResult.error("Cannot parse line " + line);
        }
        if (system instanceof PSystemError) {
            return CommandExecutionResult.error("PSystemError cannot be cast");
        }
        try {
            return this.executeArg(system, first.getLocation(), new RegexResult(result), currentPass);
        }
        catch (NoSuchColorException e) {
            return CommandExecutionResult.badColor();
        }
    }

    protected boolean isForbidden(CharSequence line) {
        return false;
    }

    protected abstract CommandExecutionResult executeArg(S var1, LineLocation var2, RegexResult var3, ParserPass var4) throws NoSuchColorException;

    @Override
    public boolean isEligibleFor(ParserPass pass) {
        return pass == ParserPass.ONE;
    }
}

