/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tools.BuilderOptions;
import org.languagetool.tools.DictionaryBuilder;

final class SynthDictionaryBuilder
extends DictionaryBuilder {
    private static final String POLISH_IGNORE_REGEX = ":neg|qub|depr";
    private static String tagsFilename;

    SynthDictionaryBuilder(File infoFile) throws IOException {
        super(infoFile);
    }

    public static void main(String[] args) throws Exception {
        BuilderOptions builderOptions = new BuilderOptions();
        builderOptions.addOption("i", true, "tab-separated plain-text dictionary file with format: wordform<tab>lemma<tab>postag", true);
        builderOptions.addOption("info", true, "*.info properties file, see https://dev.languagetool.org/developing-a-tagger-dictionary", true);
        CommandLine cmdLine = builderOptions.parseArguments(args, SynthDictionaryBuilder.class);
        File plainTextDictFile = new File(cmdLine.getOptionValue("i"));
        File infoFile = new File(cmdLine.getOptionValue("info"));
        SynthDictionaryBuilder builder = new SynthDictionaryBuilder(infoFile);
        builder.setOutputFilename(cmdLine.getOptionValue("o"));
        tagsFilename = cmdLine.getOptionValue("o") + "_tags.txt";
        builder.build(plainTextDictFile, infoFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File build(File plainTextDictFile, File infoFile) throws Exception {
        String outputFilename = this.getOutputFilename();
        File outputDirectory = new File(outputFilename).getParentFile();
        File tempFile = File.createTempFile(SynthDictionaryBuilder.class.getSimpleName(), ".txt", outputDirectory);
        File reversedFile = null;
        try {
            Set<String> itemsToBeIgnored = this.getIgnoreItems(new File(infoFile.getParent(), "filter-archaic.txt"));
            Pattern ignorePosRegex = this.getPosTagIgnoreRegex(infoFile);
            reversedFile = this.reverseLineContent(plainTextDictFile, itemsToBeIgnored, ignorePosRegex);
            this.writePosTagsToFile(plainTextDictFile, new File(tagsFilename));
            File file = this.buildDict(reversedFile);
            return file;
        }
        finally {
            tempFile.delete();
            if (reversedFile != null) {
                reversedFile.delete();
            }
        }
    }

    private Set<String> getIgnoreItems(File file) throws FileNotFoundException {
        HashSet<String> result = new HashSet<String>();
        if (file.exists()) {
            try (Scanner scanner = new Scanner(file, this.getOption("fsa.dict.encoding"));){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.startsWith("#")) continue;
                    result.add(line);
                }
            }
            System.out.println("Loaded " + result.size() + " words to be ignored from " + file);
        } else {
            System.out.println("File " + file.getAbsolutePath() + " does not exist, no items will be ignored");
        }
        return result;
    }

    @Nullable
    private Pattern getPosTagIgnoreRegex(File infoFile) {
        String fileName = infoFile.getName();
        int underscorePos = fileName.indexOf(95);
        if (underscorePos == -1) {
            throw new IllegalArgumentException("Please specify an .info file for a synthesizer as the second parameter, named '<xyz>_synth.info', with <xyz> being a language'");
        }
        String baseName = fileName.substring(0, underscorePos);
        if (baseName.equals("polish")) {
            return Pattern.compile(POLISH_IGNORE_REGEX);
        }
        return null;
    }

    private File reverseLineContent(File plainTextDictFile, Set<String> itemsToBeIgnored, Pattern ignorePosRegex) throws IOException {
        File reversedFile = File.createTempFile(SynthDictionaryBuilder.class.getSimpleName() + "_reversed", ".txt");
        reversedFile.deleteOnExit();
        String separator = this.getOption("fsa.dict.separator");
        if (separator == null || separator.trim().isEmpty()) {
            throw new IOException("A separator character (fsa.dict.separator) must be defined in the dictionary info file.");
        }
        String encoding = this.getOption("fsa.dict.encoding");
        int posIgnoreCount = 0;
        Scanner scanner = new Scanner(plainTextDictFile, encoding);
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reversedFile), encoding));){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (itemsToBeIgnored.contains(line)) {
                    System.out.println("Ignoring: " + line);
                    continue;
                }
                String[] parts = line.split("\t");
                if (parts.length == 3) {
                    String posTag = parts[2];
                    if (ignorePosRegex != null && ignorePosRegex.matcher(posTag).find()) {
                        ++posIgnoreCount;
                        continue;
                    }
                    out.write(parts[0] + separator + parts[1] + "|" + posTag);
                    ((Writer)out).write(10);
                    continue;
                }
                System.err.println("Invalid input, expected three tab-separated columns in " + plainTextDictFile + ": " + line + " => ignoring");
            }
            scanner.close();
        }
        System.out.println("Number of lines ignored due to POS tag filter ('" + ignorePosRegex + "'): " + posIgnoreCount);
        return reversedFile;
    }

    private void writePosTagsToFile(File plainTextDictFile, File tagFile) throws IOException {
        Set<String> posTags = this.collectTags(plainTextDictFile);
        ArrayList<String> sortedTags = new ArrayList<String>(posTags);
        Collections.sort(sortedTags);
        System.out.println("Writing tag file to " + tagFile);
        try (FileWriter out = new FileWriter(tagFile);){
            for (String tag : sortedTags) {
                out.write(tag);
                out.write(10);
            }
        }
    }

    private Set<String> collectTags(File plainTextDictFile) throws IOException {
        HashSet<String> posTags = new HashSet<String>();
        try (Scanner scanner = new Scanner(plainTextDictFile, this.getOption("fsa.dict.encoding"));){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] parts = line.split("\t");
                if (parts.length == 3) {
                    String posTag = parts[2];
                    posTags.add(posTag);
                    continue;
                }
                System.err.println("Invalid input, expected three tab-separated columns in " + plainTextDictFile + ": " + line + " => ignoring");
            }
        }
        return posTags;
    }
}

