/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.prompts;

import java.util.List;
import net.rubygrapefruit.platform.prompts.AbstractListener;
import net.rubygrapefruit.platform.prompts.SelectView;
import net.rubygrapefruit.platform.terminal.TerminalInputListener;

class SelectionListener
extends AbstractListener {
    private final SelectView view;
    private final List<String> options;
    private int selected;

    SelectionListener(SelectView view, List<String> options) {
        this.view = view;
        this.options = options;
        this.selected = -1;
    }

    @Override
    boolean isFinished() {
        return this.selected != -1;
    }

    Integer getSelected() {
        return this.selected < 0 ? null : Integer.valueOf(this.selected);
    }

    @Override
    public void character(char ch) {
        int index;
        if (Character.isDigit(ch) && (index = ch - 48 - 1) >= 0 && index < this.options.size()) {
            this.selected = index;
        }
    }

    @Override
    public void controlKey(TerminalInputListener.Key key) {
        if (key == TerminalInputListener.Key.Enter) {
            this.selected = this.view.getSelected();
        } else if (key == TerminalInputListener.Key.UpArrow) {
            this.view.selectPrevious();
        } else if (key == TerminalInputListener.Key.DownArrow) {
            this.view.selectNext();
        }
    }

    @Override
    public void endInput() {
        this.selected = -2;
    }
}

