/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.terminal;

import java.io.Closeable;
import java.io.Flushable;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.jetbrains.kotlin.org.jline.terminal.Attributes;
import org.jetbrains.kotlin.org.jline.terminal.Cursor;
import org.jetbrains.kotlin.org.jline.terminal.MouseEvent;
import org.jetbrains.kotlin.org.jline.terminal.Size;
import org.jetbrains.kotlin.org.jline.terminal.impl.NativeSignalHandler;
import org.jetbrains.kotlin.org.jline.utils.ColorPalette;
import org.jetbrains.kotlin.org.jline.utils.InfoCmp;
import org.jetbrains.kotlin.org.jline.utils.NonBlockingReader;

public interface Terminal
extends Closeable,
Flushable {
    public String getName();

    public SignalHandler handle(Signal var1, SignalHandler var2);

    public NonBlockingReader reader();

    public PrintWriter writer();

    public Charset encoding();

    public InputStream input();

    public Attributes enterRawMode();

    public Attributes getAttributes();

    public void setAttributes(Attributes var1);

    public Size getSize();

    default public Size getBufferSize() {
        return this.getSize();
    }

    @Override
    public void flush();

    public String getType();

    public boolean puts(InfoCmp.Capability var1, Object ... var2);

    public boolean getBooleanCapability(InfoCmp.Capability var1);

    public Integer getNumericCapability(InfoCmp.Capability var1);

    public String getStringCapability(InfoCmp.Capability var1);

    public Cursor getCursorPosition(IntConsumer var1);

    public boolean trackMouse(MouseTracking var1);

    public MouseEvent readMouseEvent();

    public MouseEvent readMouseEvent(IntSupplier var1);

    public ColorPalette getPalette();

    public static enum MouseTracking {
        Off,
        Normal,
        Button,
        Any;

    }

    public static interface SignalHandler {
        public static final SignalHandler SIG_DFL = NativeSignalHandler.SIG_DFL;
        public static final SignalHandler SIG_IGN = NativeSignalHandler.SIG_IGN;

        public void handle(Signal var1);
    }

    public static enum Signal {
        INT,
        QUIT,
        TSTP,
        CONT,
        INFO,
        WINCH;

    }
}

