/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.plugins.SoftwareFeatureTransform;
import org.gradle.api.internal.plugins.TargetTypeInformation;
import org.gradle.plugin.software.internal.LegacySoftwareTypeImplementation;
import org.gradle.plugin.software.internal.ModelDefault;
import org.jspecify.annotations.Nullable;

public class DefaultLegacySoftwareTypeImplementation<T>
implements LegacySoftwareTypeImplementation<T> {
    private final String softwareTypeName;
    private final Class<T> modelPublicType;
    private final Class<? extends Plugin<Project>> pluginClass;
    private final Class<? extends Plugin<Settings>> registeringPluginClass;
    private final @Nullable String registeringPluginId;
    private final List<ModelDefault<?>> defaults = new ArrayList();

    public DefaultLegacySoftwareTypeImplementation(String softwareTypeName, Class<T> modelPublicType, Class<? extends Plugin<Project>> pluginClass, Class<? extends Plugin<Settings>> registeringPluginClass, @Nullable String registeringPluginId) {
        this.softwareTypeName = softwareTypeName;
        this.modelPublicType = modelPublicType;
        this.pluginClass = pluginClass;
        this.registeringPluginClass = registeringPluginClass;
        this.registeringPluginId = registeringPluginId;
    }

    public String getTypeName() {
        return this.softwareTypeName;
    }

    public String getFeatureName() {
        return this.softwareTypeName;
    }

    public Class<T> getDefinitionPublicType() {
        return this.modelPublicType;
    }

    public Class<? extends T> getDefinitionImplementationType() {
        return this.modelPublicType;
    }

    public TargetTypeInformation<?> getTargetDefinitionType() {
        return new TargetTypeInformation.DefinitionTargetTypeInformation(Project.class);
    }

    public Class<T> getBuildModelType() {
        return this.modelPublicType;
    }

    public Class<T> getBuildModelImplementationType() {
        return this.modelPublicType;
    }

    public Class<? extends Plugin<Project>> getPluginClass() {
        return this.pluginClass;
    }

    public Class<? extends Plugin<Settings>> getRegisteringPluginClass() {
        return this.registeringPluginClass;
    }

    public SoftwareFeatureTransform<T, T, ?> getBindingTransform() {
        return (context, t, v, u) -> {};
    }

    public void addModelDefault(ModelDefault<?> modelDefault) {
        this.defaults.add(modelDefault);
    }

    public <M extends ModelDefault.Visitor<?>> void visitModelDefaults(Class<? extends ModelDefault<M>> type, M visitor) {
        this.defaults.stream().filter(type::isInstance).map(type::cast).forEach(modelDefault -> modelDefault.visit(visitor));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLegacySoftwareTypeImplementation that = (DefaultLegacySoftwareTypeImplementation)o;
        return Objects.equals(this.softwareTypeName, that.softwareTypeName) && Objects.equals(this.modelPublicType, that.modelPublicType) && Objects.equals(this.pluginClass, that.pluginClass);
    }

    public int hashCode() {
        return Objects.hash(this.softwareTypeName, this.modelPublicType, this.pluginClass);
    }

    public @Nullable String getRegisteringPluginId() {
        return this.registeringPluginId;
    }
}

