﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/storagegateway/StorageGateway_EXPORTS.h>
#include <aws/storagegateway/model/Disk.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace StorageGateway {
namespace Model {
class ListLocalDisksResult {
 public:
  AWS_STORAGEGATEWAY_API ListLocalDisksResult() = default;
  AWS_STORAGEGATEWAY_API ListLocalDisksResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_STORAGEGATEWAY_API ListLocalDisksResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const Aws::String& GetGatewayARN() const { return m_gatewayARN; }
  template <typename GatewayARNT = Aws::String>
  void SetGatewayARN(GatewayARNT&& value) {
    m_gatewayARNHasBeenSet = true;
    m_gatewayARN = std::forward<GatewayARNT>(value);
  }
  template <typename GatewayARNT = Aws::String>
  ListLocalDisksResult& WithGatewayARN(GatewayARNT&& value) {
    SetGatewayARN(std::forward<GatewayARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A JSON object containing the following fields:</p> <ul> <li> <p>
   * <a>ListLocalDisksOutput$Disks</a> </p> </li> </ul>
   */
  inline const Aws::Vector<Disk>& GetDisks() const { return m_disks; }
  template <typename DisksT = Aws::Vector<Disk>>
  void SetDisks(DisksT&& value) {
    m_disksHasBeenSet = true;
    m_disks = std::forward<DisksT>(value);
  }
  template <typename DisksT = Aws::Vector<Disk>>
  ListLocalDisksResult& WithDisks(DisksT&& value) {
    SetDisks(std::forward<DisksT>(value));
    return *this;
  }
  template <typename DisksT = Disk>
  ListLocalDisksResult& AddDisks(DisksT&& value) {
    m_disksHasBeenSet = true;
    m_disks.emplace_back(std::forward<DisksT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListLocalDisksResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_gatewayARN;

  Aws::Vector<Disk> m_disks;

  Aws::String m_requestId;
  bool m_gatewayARNHasBeenSet = false;
  bool m_disksHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace StorageGateway
}  // namespace Aws
