﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>The FireLens configuration for the container. The configuration specifies and
 * configures a log router for container logs.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails">AWS
 * API Reference</a></p>
 */
class AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails {
 public:
  AWS_SECURITYHUB_API AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails() = default;
  AWS_SECURITYHUB_API AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The options to use to configure the log router.</p> <p>The valid option keys
   * are as follows:</p> <ul> <li> <p> <code>enable-ecs-log-metadata</code>. The
   * value can be <code>true</code> or <code>false</code>.</p> </li> <li> <p>
   * <code>config-file-type</code>. The value can be <code>s3</code> or
   * <code>file</code>.</p> </li> <li> <p> <code>config-file-value</code>. The value
   * is either an S3 ARN or a file path.</p> </li> </ul>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetOptions() const { return m_options; }
  inline bool OptionsHasBeenSet() const { return m_optionsHasBeenSet; }
  template <typename OptionsT = Aws::Map<Aws::String, Aws::String>>
  void SetOptions(OptionsT&& value) {
    m_optionsHasBeenSet = true;
    m_options = std::forward<OptionsT>(value);
  }
  template <typename OptionsT = Aws::Map<Aws::String, Aws::String>>
  AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails& WithOptions(OptionsT&& value) {
    SetOptions(std::forward<OptionsT>(value));
    return *this;
  }
  template <typename OptionsKeyT = Aws::String, typename OptionsValueT = Aws::String>
  AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails& AddOptions(OptionsKeyT&& key, OptionsValueT&& value) {
    m_optionsHasBeenSet = true;
    m_options.emplace(std::forward<OptionsKeyT>(key), std::forward<OptionsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The log router to use. Valid values are <code>fluentbit</code> or
   * <code>fluentd</code>.</p>
   */
  inline const Aws::String& GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  template <typename TypeT = Aws::String>
  void SetType(TypeT&& value) {
    m_typeHasBeenSet = true;
    m_type = std::forward<TypeT>(value);
  }
  template <typename TypeT = Aws::String>
  AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails& WithType(TypeT&& value) {
    SetType(std::forward<TypeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Map<Aws::String, Aws::String> m_options;

  Aws::String m_type;
  bool m_optionsHasBeenSet = false;
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
