﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/Glue_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {

/**
 * <p>A classifier for <code>JSON</code> content.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/JsonClassifier">AWS
 * API Reference</a></p>
 */
class JsonClassifier {
 public:
  AWS_GLUE_API JsonClassifier() = default;
  AWS_GLUE_API JsonClassifier(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API JsonClassifier& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the classifier.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  JsonClassifier& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time that this classifier was registered.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  JsonClassifier& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time that this classifier was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdated() const { return m_lastUpdated; }
  inline bool LastUpdatedHasBeenSet() const { return m_lastUpdatedHasBeenSet; }
  template <typename LastUpdatedT = Aws::Utils::DateTime>
  void SetLastUpdated(LastUpdatedT&& value) {
    m_lastUpdatedHasBeenSet = true;
    m_lastUpdated = std::forward<LastUpdatedT>(value);
  }
  template <typename LastUpdatedT = Aws::Utils::DateTime>
  JsonClassifier& WithLastUpdated(LastUpdatedT&& value) {
    SetLastUpdated(std::forward<LastUpdatedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of this classifier.</p>
   */
  inline long long GetVersion() const { return m_version; }
  inline bool VersionHasBeenSet() const { return m_versionHasBeenSet; }
  inline void SetVersion(long long value) {
    m_versionHasBeenSet = true;
    m_version = value;
  }
  inline JsonClassifier& WithVersion(long long value) {
    SetVersion(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A <code>JsonPath</code> string defining the JSON data for the classifier to
   * classify. Glue supports a subset of JsonPath, as described in <a
   * href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing
   * JsonPath Custom Classifiers</a>.</p>
   */
  inline const Aws::String& GetJsonPath() const { return m_jsonPath; }
  inline bool JsonPathHasBeenSet() const { return m_jsonPathHasBeenSet; }
  template <typename JsonPathT = Aws::String>
  void SetJsonPath(JsonPathT&& value) {
    m_jsonPathHasBeenSet = true;
    m_jsonPath = std::forward<JsonPathT>(value);
  }
  template <typename JsonPathT = Aws::String>
  JsonClassifier& WithJsonPath(JsonPathT&& value) {
    SetJsonPath(std::forward<JsonPathT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::Utils::DateTime m_creationTime{};

  Aws::Utils::DateTime m_lastUpdated{};

  long long m_version{0};

  Aws::String m_jsonPath;
  bool m_nameHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_lastUpdatedHasBeenSet = false;
  bool m_versionHasBeenSet = false;
  bool m_jsonPathHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
