﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {
class ListApprovedOriginsResult {
 public:
  AWS_CONNECT_API ListApprovedOriginsResult() = default;
  AWS_CONNECT_API ListApprovedOriginsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CONNECT_API ListApprovedOriginsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The approved origins.</p>
   */
  inline const Aws::Vector<Aws::String>& GetOrigins() const { return m_origins; }
  template <typename OriginsT = Aws::Vector<Aws::String>>
  void SetOrigins(OriginsT&& value) {
    m_originsHasBeenSet = true;
    m_origins = std::forward<OriginsT>(value);
  }
  template <typename OriginsT = Aws::Vector<Aws::String>>
  ListApprovedOriginsResult& WithOrigins(OriginsT&& value) {
    SetOrigins(std::forward<OriginsT>(value));
    return *this;
  }
  template <typename OriginsT = Aws::String>
  ListApprovedOriginsResult& AddOrigins(OriginsT&& value) {
    m_originsHasBeenSet = true;
    m_origins.emplace_back(std::forward<OriginsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If there are additional results, this is the token for the next set of
   * results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListApprovedOriginsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListApprovedOriginsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_origins;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_originsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
