﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codebuild/CodeBuild_EXPORTS.h>
#include <aws/codebuild/model/ReportGroup.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeBuild {
namespace Model {
class CreateReportGroupResult {
 public:
  AWS_CODEBUILD_API CreateReportGroupResult() = default;
  AWS_CODEBUILD_API CreateReportGroupResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEBUILD_API CreateReportGroupResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> Information about the report group that was created. </p>
   */
  inline const ReportGroup& GetReportGroup() const { return m_reportGroup; }
  template <typename ReportGroupT = ReportGroup>
  void SetReportGroup(ReportGroupT&& value) {
    m_reportGroupHasBeenSet = true;
    m_reportGroup = std::forward<ReportGroupT>(value);
  }
  template <typename ReportGroupT = ReportGroup>
  CreateReportGroupResult& WithReportGroup(ReportGroupT&& value) {
    SetReportGroup(std::forward<ReportGroupT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateReportGroupResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ReportGroup m_reportGroup;

  Aws::String m_requestId;
  bool m_reportGroupHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeBuild
}  // namespace Aws
