/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.LibraryIdentifier;
import org.gradle.platform.base.ComponentSpecContainer;
import org.jspecify.annotations.Nullable;

public class ProjectLibraryBinaryLocator
implements LibraryBinaryLocator {
    private final ProjectModelResolver projectModelResolver;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;

    public ProjectLibraryBinaryLocator(ProjectModelResolver projectModelResolver, DomainObjectCollectionFactory domainObjectCollectionFactory) {
        this.projectModelResolver = projectModelResolver;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
    }

    @Override
    public @Nullable DomainObjectSet<NativeLibraryBinary> getBinaries(LibraryIdentifier libraryIdentifier) {
        ModelRegistry projectModel = this.projectModelResolver.resolveProjectModel(libraryIdentifier.getProjectPath());
        ComponentSpecContainer components = (ComponentSpecContainer)projectModel.find("components", ComponentSpecContainer.class);
        if (components == null) {
            return null;
        }
        String libraryName = libraryIdentifier.getLibraryName();
        NativeLibrarySpec library = (NativeLibrarySpec)components.withType(NativeLibrarySpec.class).get(libraryName);
        if (library == null) {
            return null;
        }
        ModelMap projectBinaries = library.getBinaries().withType(NativeBinarySpec.class);
        DomainObjectSet binaries = this.domainObjectCollectionFactory.newDomainObjectSet(NativeLibraryBinary.class);
        for (NativeBinarySpec nativeBinarySpec : projectBinaries.values()) {
            binaries.add((Object)((NativeLibraryBinary)((Object)nativeBinarySpec)));
        }
        return binaries;
    }
}

