/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.jkiss.dbeaver.ui.controls.lightgrid.LightGrid;

public class SpreadsheetCellEditor
extends ControlEditor {
    private LightGrid grid;
    private int column = -1;
    private int row = -1;
    private ControlListener columnListener;
    private Listener resizeListener;
    private SelectionListener scrollListener;

    public SpreadsheetCellEditor(LightGrid grid) {
        super((Composite)grid);
        this.grid = grid;
        this.columnListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                SpreadsheetCellEditor.this.layout();
            }

            public void controlResized(ControlEvent e) {
                SpreadsheetCellEditor.this.layout();
            }
        };
        this.resizeListener = event -> this.layout();
        this.scrollListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpreadsheetCellEditor.this.layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        grid.addListener(11, this.resizeListener);
        if (grid.getVerticalScrollBarProxy() != null) {
            grid.getVerticalScrollBarProxy().addSelectionListener(this.scrollListener);
        }
        if (grid.getHorizontalScrollBarProxy() != null) {
            grid.getHorizontalScrollBarProxy().addSelectionListener(this.scrollListener);
        }
        this.grabVertical = true;
    }

    private Rectangle computeEditorBounds() {
        if (this.row == -1 || this.column == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle cell = this.grid.getCellBounds(this.column, this.row);
        Rectangle area = this.grid.getClientArea();
        if (cell.x < area.x + area.width && cell.x + cell.width > area.x + area.width) {
            cell.width = area.x + area.width - cell.x;
        }
        Rectangle editorRect = new Rectangle(cell.x, cell.y, this.minimumWidth, this.minimumHeight);
        if (this.grabHorizontal) {
            editorRect.width = Math.max(cell.width, this.minimumWidth);
        }
        if (this.grabVertical) {
            editorRect.height = Math.max(cell.height, this.minimumHeight);
        }
        if (this.horizontalAlignment == 131072) {
            editorRect.x += cell.width - editorRect.width;
        } else if (this.horizontalAlignment != 16384) {
            editorRect.x += (cell.width - editorRect.width) / 2;
        }
        if (this.verticalAlignment == 1024) {
            editorRect.y += cell.height - editorRect.height;
        } else if (this.verticalAlignment != 128) {
            editorRect.y += (cell.height - editorRect.height) / 2;
        }
        return editorRect;
    }

    public void dispose() {
        if (!this.grid.isDisposed()) {
            this.grid.removeListener(11, this.resizeListener);
            if (this.grid.getVerticalScrollBarProxy() != null) {
                this.grid.getVerticalScrollBarProxy().removeSelectionListener(this.scrollListener);
            }
            if (this.grid.getHorizontalScrollBarProxy() != null) {
                this.grid.getHorizontalScrollBarProxy().removeSelectionListener(this.scrollListener);
            }
        }
        this.columnListener = null;
        this.resizeListener = null;
        this.grid = null;
        this.row = -1;
        this.column = -1;
        super.dispose();
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
        this.layout();
    }

    public void setColumn(int column) {
        int columnCount = this.grid.getColumnCount();
        if (columnCount == 0) {
            this.column = column == 0 ? 0 : -1;
            this.layout();
            return;
        }
        if (this.column > -1 && this.column < columnCount) {
            this.column = -1;
        }
        if (column < 0 || column >= this.grid.getColumnCount()) {
            return;
        }
        this.column = column;
        this.layout();
    }

    public void setEditor(Control editor, int column, int row) {
        this.setRow(row);
        this.setColumn(column);
        this.setEditor(editor);
        this.layout();
    }

    public void layout() {
        if (this.grid.isDisposed()) {
            return;
        }
        if (this.row == -1) {
            return;
        }
        int columnCount = this.grid.getColumnCount();
        if (columnCount == 0 && this.column != 0) {
            return;
        }
        if (columnCount > 0 && (this.column < 0 || this.column >= columnCount)) {
            return;
        }
        boolean hadFocus = false;
        if (this.getEditor() == null || this.getEditor().isDisposed()) {
            return;
        }
        if (this.getEditor().getVisible()) {
            hadFocus = this.getEditor().isFocusControl();
        }
        this.getEditor().setBounds(this.computeEditorBounds());
        if (hadFocus) {
            if (this.getEditor() == null || this.getEditor().isDisposed()) {
                return;
            }
            this.getEditor().setFocus();
        }
    }
}

